/*
 * Decompiled with CFR 0.152.
 */
package de.renew.appleui;

import de.renew.appleui.AboutDisplayer;
import de.renew.appleui.AppleUIListener;
import de.renew.plugin.IPlugin;
import de.renew.plugin.PluginAdapter;
import de.renew.plugin.PluginProperties;
import de.renew.plugin.SoftDependency;
import java.awt.Desktop;

public class AppleUI
extends PluginAdapter {
    private Desktop desktop = null;
    private AppleUIListener listener = null;
    private SoftDependency guiDependency;

    public AppleUI(PluginProperties props) {
        super(props);
        String useScreenMenubar = props.getProperty("com.apple.macos.useScreenMenubar", "true");
        String menuAboutName = props.getProperty("com.apple.mrj.application.apple.menu.about.name", "Renew");
        System.setProperty("com.apple.macos.useScreenMenubar", useScreenMenubar);
        System.setProperty("apple.laf.useScreenMenuBar", useScreenMenubar);
        System.setProperty("com.apple.mrj.application.apple.menu.about.name", menuAboutName);
    }

    public void init() {
        this.desktop = Desktop.getDesktop();
        this.listener = new AppleUIListener();
        this.setAboutDisplayer(null);
        this.desktop.setAboutHandler(this.listener);
        this.desktop.addAppEventListener(this.listener);
        this.desktop.setQuitHandler(this.listener);
        this.desktop.setOpenFileHandler(this.listener);
        this.guiDependency = new SoftDependency((IPlugin)this, "de.renew.gui", "de.renew.appleui.GuiDependencyListener");
    }

    public boolean cleanup() {
        if (this.desktop != null) {
            this.desktop.removeAppEventListener(this.listener);
            this.desktop = null;
            this.listener = null;
        }
        if (this.guiDependency != null) {
            this.guiDependency.discard();
            this.guiDependency = null;
        }
        return true;
    }

    void setAboutDisplayer(AboutDisplayer displayer) {
        if (this.desktop != null && this.listener != null) {
            this.listener.setAboutDisplayer(displayer);
        }
    }
}

