/*
 * Decompiled with CFR 0.152.
 */
package de.renew.guiprompt;

import CH.ifa.draw.DrawPlugin;
import de.renew.guiprompt.ResponseDocument;
import de.renew.plugin.PluginAdapter;
import de.renew.plugin.PluginException;
import de.renew.plugin.PluginManager;
import de.renew.plugin.PluginProperties;
import de.renew.plugin.command.CLCommand;
import de.renew.util.StringUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.io.PipedOutputStream;
import java.io.PrintStream;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import org.apache.log4j.Logger;

public class GuiPromptPlugin
extends PluginAdapter {
    public static Logger logger = Logger.getLogger(GuiPromptPlugin.class);
    JMenuItem _menu;
    PromptDialog _promptDialog;

    public GuiPromptPlugin(URL location) throws PluginException {
        super(location);
    }

    public GuiPromptPlugin(PluginProperties props) {
        super(props);
    }

    public void init() {
        this._menu = this.createMenu();
        DrawPlugin.getCurrent().getMenuManager().registerMenu(DrawPlugin.PLUGINS_MENU, this._menu);
        PluginManager.getInstance().addCLCommand("guiprompt", (CLCommand)new GuiPromptCommand());
    }

    public boolean cleanup() {
        PluginManager.getInstance().removeCLCommand("guiprompt");
        DrawPlugin current = DrawPlugin.getCurrent();
        if (current != null) {
            current.getMenuManager().unregisterMenu(this._menu);
        }
        if (this._promptDialog != null) {
            this._promptDialog.dispose();
            this._promptDialog = null;
        }
        return true;
    }

    private JMenuItem createMenu() {
        JMenuItem mi = new JMenuItem("Show Gui prompt...");
        mi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GuiPromptPlugin.this.showPromptDialog();
            }
        });
        mi.putClientProperty("ch.ifa.draw.menu.id", this.getProperties().getProperty("requires"));
        return mi;
    }

    private void showPromptDialog() {
        if (this._promptDialog == null) {
            this._promptDialog = new PromptDialog();
        }
        this._promptDialog.setVisible(true);
    }

    private class GuiPromptCommand
    implements CLCommand {
        private GuiPromptCommand() {
        }

        public String getDescription() {
            return "Opens a window where commands can be executed.";
        }

        public String getArguments() {
            return null;
        }

        public void execute(String[] args, final PrintStream response) {
            try {
                EventQueue.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        GuiPromptPlugin.this.showPromptDialog();
                        response.println("Prompt dialog now visible.");
                    }
                });
            }
            catch (InterruptedException interruptedException) {
            }
            catch (InvocationTargetException e) {
                response.println("Exception while showing prompt dialog: " + e.getTargetException());
                logger.error((Object)e.getTargetException().toString(), (Throwable)e);
            }
        }
    }

    private class PromptDialog
    extends JFrame {
        JTextField _inputField;
        private JEditorPane _responseArea;
        private PrintStream _responseStream;
        private ResponseDocument _responseDocument;

        public PromptDialog() {
            super("Command Input");
            this._inputField = new JTextField(30);
            JButton execute = new JButton("execute");
            JButton clear = new JButton("clear");
            execute.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    PromptDialog.this.executeCommand();
                }
            });
            clear.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    PromptDialog.this.clearFields();
                }
            });
            JPanel buttonPanel = new JPanel();
            buttonPanel.add(this._inputField);
            buttonPanel.add(execute);
            buttonPanel.add(clear);
            this._responseArea = new JEditorPane();
            this._responseArea.setEditable(false);
            this.setupResponseDocument();
            JRootPane root = this.getRootPane();
            root.setLayout(new BorderLayout());
            root.add((Component)buttonPanel, "North");
            root.add((Component)new JScrollPane(this._responseArea), "Center");
            this.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent e) {
                    logger.debug((Object)"window closing.");
                    PromptDialog.this._responseStream.close();
                    if (PromptDialog.this._responseDocument != null) {
                        PromptDialog.this._responseDocument.terminate();
                        PromptDialog.this._responseDocument = null;
                    }
                    GuiPromptPlugin.this._promptDialog = null;
                    PromptDialog.this._responseStream = null;
                    PromptDialog.this.dispose();
                }
            });
            this._inputField.addKeyListener(new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent e) {
                    if (e.getKeyCode() == 10) {
                        PromptDialog.this.executeCommand();
                    }
                }
            });
            this.pack();
        }

        private void executeCommand() {
            try {
                String input = this._inputField.getText();
                Map commands = PluginManager.getInstance().getCLCommands();
                String[] cl = StringUtil.splitStringWithEscape((String)input);
                if (cl.length == 0) {
                    return;
                }
                final CLCommand c = (CLCommand)commands.get(cl[0]);
                if (c == null) {
                    this._responseStream.println("unknown command: " + cl[0]);
                } else {
                    final String[] nc = new String[cl.length - 1];
                    for (int i = 0; i < nc.length; ++i) {
                        nc[i] = cl[i + 1];
                    }
                    logger.debug((Object)("GuiPrompt: scheduling command: " + input));
                    this._responseStream.println(">" + input);
                    new Thread(){

                        @Override
                        public void run() {
                            PromptDialog.this._responseDocument.revive();
                            c.execute(nc, PromptDialog.this._responseStream);
                        }
                    }.start();
                }
            }
            catch (RuntimeException e) {
                this._responseStream.println("GuiPrompt: an exeption occurred: " + e);
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
        }

        private void clearFields() {
            this._inputField.setText("");
            this.setupResponseDocument();
        }

        private void setupResponseDocument() {
            try {
                PipedOutputStream pipe = new PipedOutputStream();
                this._responseStream = new PrintStream(pipe, true);
                this._responseDocument = new ResponseDocument(pipe);
                this._responseArea.setDocument(this._responseDocument);
                this._responseStream.println("Execution feedback:\n");
            }
            catch (IOException e) {
                this._responseDocument = null;
                this._responseStream = System.out;
                this._responseArea.setDocument(this._responseArea.getEditorKit().createDefaultDocument());
                this._responseArea.setText("Feedback stream could not be established: " + e.toString() + "\nFallback to console output.");
                logger.error((Object)e.toString(), (Throwable)e);
            }
        }

        @Override
        public void setVisible(boolean visible) {
            super.setVisible(visible);
            if (visible) {
                GuiPromptPlugin.this.registerExitBlock();
                DrawPlugin.getCurrent().getMenuManager().getWindowsMenu().addFrame("Tools", (Frame)this);
            }
        }

        @Override
        public void dispose() {
            DrawPlugin.getCurrent().getMenuManager().getWindowsMenu().removeFrame((Frame)this);
            GuiPromptPlugin.this.registerExitOk();
            super.dispose();
        }
    }
}

