/*
 * Decompiled with CFR 0.152.
 */
package de.renew.guiprompt;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;
import org.apache.log4j.Logger;

public class ResponseDocument
extends PlainDocument {
    public static Logger logger = Logger.getLogger(ResponseDocument.class);
    private final BufferedReader reader;
    private boolean terminated = false;
    private Object monitor = new Object();
    private Thread responseReaderThread;

    public ResponseDocument(PipedOutputStream stream) throws IOException {
        this.reader = new BufferedReader(new InputStreamReader(new PipedInputStream(stream)));
        this.responseReaderThread = new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                while (!ResponseDocument.this.terminated) {
                    try {
                        ResponseDocument.this.appendText(ResponseDocument.this.reader.readLine());
                    }
                    catch (IOException e) {
                        if ("Write end dead".equals(e.getMessage())) {
                            ResponseDocument.this.appendText("\n----\n");
                            Object object = ResponseDocument.this.monitor;
                            synchronized (object) {
                                try {
                                    ResponseDocument.this.monitor.wait();
                                }
                                catch (InterruptedException e2) {
                                    logger.debug((Object)"Feedback thread interrupted.");
                                    ResponseDocument.this.appendText("\nFeedback thread interrupted.");
                                    ResponseDocument.this.terminate();
                                }
                                continue;
                            }
                        }
                        logger.debug((Object)("Feedback exception: " + e), (Throwable)e);
                        ResponseDocument.this.appendText("\nFeedback exception: " + e);
                        ResponseDocument.this.terminate();
                    }
                }
                ResponseDocument.this.appendText("\nFeedback terminated. Press [Clear] to reinitialize.");
            }
        };
        this.responseReaderThread.setName("GuiPrompt feedback reader thread");
        this.responseReaderThread.start();
    }

    public void appendText(String line) {
        try {
            this.insertString(this.getLength(), line + "\n", null);
        }
        catch (BadLocationException e) {
            logger.error((Object)("Bad location!? getLength=" + this.getLength()), (Throwable)e);
        }
    }

    public void terminate() {
        this.terminated = true;
        this.responseReaderThread.interrupt();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void revive() {
        Object object = this.monitor;
        synchronized (object) {
            this.monitor.notifyAll();
        }
    }
}

