/*
 * Decompiled with CFR 0.152.
 */
package de.renew.navigator.vc.git;

import de.renew.navigator.vc.AbstractRepository;
import de.renew.navigator.vc.Commit;
import de.renew.navigator.vc.VersionControl;
import de.renew.navigator.vc.git.GitVersionControl;
import de.renew.util.StringUtil;
import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.apache.log4j.Logger;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.Status;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.storage.file.FileBasedConfig;
import org.eclipse.jgit.storage.file.FileRepository;

public class GitRepository
extends AbstractRepository {
    public static final Logger logger = Logger.getLogger(GitRepository.class);
    protected final Git git;
    protected final FileRepository fileRepository;

    public GitRepository(FileRepository fileRepository, GitVersionControl versionControl) {
        super(fileRepository.getWorkTree(), (VersionControl)versionControl);
        this.fileRepository = fileRepository;
        this.git = new Git((Repository)fileRepository);
        this.lastCommit = this.retrieveLastCommit();
        this.update();
    }

    public String getBranch() {
        try {
            return this.fileRepository.getBranch();
        }
        catch (IOException e) {
            return null;
        }
    }

    public String getRemoteURL() {
        FileBasedConfig config = this.fileRepository.getConfig();
        Set remotes = config.getSubsections("remote");
        Set svnRemotes = config.getSubsections("svn-remote");
        HashSet<String> urls = new HashSet<String>(remotes.size() + svnRemotes.size());
        for (String remote : remotes) {
            urls.add(config.getString("remote", remote, "url"));
        }
        for (String svnRemote : svnRemotes) {
            urls.add(config.getString("svn-remote", svnRemote, "url"));
        }
        return StringUtil.join(urls, (String)",");
    }

    public void update() {
        this.modified.clear();
        this.added.clear();
        this.ignored.clear();
        try {
            Status status = this.git.status().call();
            this.modified.addAll(this.makeFileSet(status.getModified(), true));
            this.added.addAll(this.makeFileSet(status.getAdded(), false));
            this.ignored.addAll(this.makeFileSet(status.getUntracked(), false));
        }
        catch (GitAPIException gitAPIException) {
            // empty catch block
        }
    }

    protected Commit retrieveLastCommit() {
        try {
            Iterator iterator = this.git.log().call().iterator();
            if (iterator.hasNext()) {
                RevCommit revCommit = (RevCommit)iterator.next();
                Commit commit = new Commit();
                commit.setAuthor(revCommit.getAuthorIdent().getName());
                commit.setDate(revCommit.getCommitTime());
                commit.setMessage(revCommit.getFullMessage());
                commit.setRevision(revCommit.getName());
                return commit;
            }
        }
        catch (GitAPIException e) {
            logger.error((Object)"Could not get last commit", (Throwable)e);
        }
        return null;
    }

    private Set<File> makeFileSet(Set<String> gitFileSet, boolean recursive) {
        HashSet<File> target = new HashSet<File>();
        String workTree = this.getRootDirectory().getAbsolutePath();
        File absoluteRootDir = new File(workTree);
        for (String file : gitFileSet) {
            String filename = workTree + File.separatorChar + file;
            File newFile = new File(filename);
            if (!newFile.exists()) continue;
            do {
                target.add(newFile);
                newFile = newFile.getParentFile();
            } while (recursive && !newFile.equals(absoluteRootDir));
        }
        return target;
    }
}

