/*
 * Decompiled with CFR 0.152.
 */
package de.renew.navigator.vc.git;

import CH.ifa.draw.framework.Drawing;
import CH.ifa.draw.io.DrawingFileHelper;
import CH.ifa.draw.io.StatusDisplayer;
import CH.ifa.draw.io.StorableInputDrawingLoader;
import CH.ifa.draw.util.StorableInput;
import de.renew.imagenetdiff.PNGDiffCommand;
import de.renew.logging.CliColor;
import de.renew.navigator.vc.AbstractVersionControl;
import de.renew.navigator.vc.Repository;
import de.renew.navigator.vc.StdoutStatusDisplayer;
import de.renew.navigator.vc.git.GitRepository;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.Optional;
import org.eclipse.jgit.api.LogCommand;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.api.errors.NoHeadException;
import org.eclipse.jgit.errors.AmbiguousObjectException;
import org.eclipse.jgit.errors.IncorrectObjectTypeException;
import org.eclipse.jgit.errors.MissingObjectException;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.storage.file.FileRepository;
import org.eclipse.jgit.storage.file.FileRepositoryBuilder;
import org.gitective.core.BlobUtils;

public class GitVersionControl
extends AbstractVersionControl {
    public boolean diff(File file) {
        logger.debug((Object)("diff with head: " + file.getAbsolutePath()));
        try {
            String bytes;
            GitRepository repository = this.buildGitRepository(file);
            URI relative = repository.makeRelativeURI(file);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Git Repository Branch:  " + repository.getBranch()));
                logger.debug((Object)("Git file path:          " + file.getPath()));
                logger.debug((Object)("Git relative file path: " + relative.getPath()));
            }
            if ((bytes = BlobUtils.getContent((org.eclipse.jgit.lib.Repository)repository.fileRepository, (String)"HEAD", (String)relative.getPath())) == null) {
                if (logger.isInfoEnabled()) {
                    logger.info((Object)"Git: There is no HEAD here. File possibly not in repository. Received null.");
                }
                return false;
            }
            Drawing drawing = StorableInputDrawingLoader.readStorableDrawing((StorableInput)new StorableInput(bytes));
            StdoutStatusDisplayer displayer = new StdoutStatusDisplayer();
            Drawing drawing2 = DrawingFileHelper.loadDrawing((File)file.getAbsoluteFile(), (StatusDisplayer)displayer);
            if (drawing2 == null) {
                logger.warn((Object)("Something went wrong. Given Drawing could not be loaded: " + drawing.getName()));
                return false;
            }
            drawing.setName(drawing2.getName() + "[HEAD]");
            PNGDiffCommand diffCommand = new PNGDiffCommand();
            diffCommand.doDiff((StatusDisplayer)displayer, drawing, drawing2, false);
            return true;
        }
        catch (AmbiguousObjectException exception) {
            this.errorException((Exception)((Object)exception), "performing diff with head");
        }
        catch (MissingObjectException exception) {
            this.errorException((Exception)((Object)exception), "performing diff with head");
        }
        catch (IncorrectObjectTypeException exception) {
            this.errorException((Exception)((Object)exception), "performing diff with head");
        }
        catch (IOException exception) {
            this.errorException(exception, "performing diff with head");
        }
        return false;
    }

    public boolean log(File file) {
        try {
            boolean result = false;
            GitRepository repository = this.buildGitRepository(file);
            LogCommand log2 = repository.git.log();
            URI relative = repository.makeRelativeURI(file);
            logger.info((Object)("Branch: " + repository.getBranch() + " File: " + relative + "\n Revisions: "));
            Iterable call = log2.addPath(relative.getPath()).call();
            for (RevCommit revCommit : call) {
                System.out.println("\n\n" + CliColor.color((String)revCommit.toString(), (CliColor[])new CliColor[]{CliColor.BLUE}) + "\n" + CliColor.color((String)("Author: " + revCommit.getAuthorIdent().getEmailAddress() + "\nDate:   " + revCommit.getAuthorIdent().getWhen()), (CliColor[])new CliColor[]{CliColor.WHITE}) + "\n\n" + revCommit.getFullMessage().replaceAll("(?m)^", "\t"));
                result = true;
            }
            return result;
        }
        catch (NoHeadException e) {
            e.printStackTrace();
        }
        catch (GitAPIException e) {
            e.printStackTrace();
        }
        return false;
    }

    public File findRootDirectory(File fileInRepository) {
        FileRepositoryBuilder repositoryBuilder = new FileRepositoryBuilder();
        ((FileRepositoryBuilder)((FileRepositoryBuilder)repositoryBuilder.findGitDir(fileInRepository)).setMustExist(true)).readEnvironment();
        return Optional.ofNullable(repositoryBuilder.getGitDir()).map(f -> f.getParentFile()).orElse(null);
    }

    protected Repository buildRepository(File fileInRepository) {
        return this.buildGitRepository(fileInRepository);
    }

    protected GitRepository buildGitRepository(File fileInRepository) {
        logger.debug((Object)("Locating Git repository for [" + fileInRepository + "]"));
        FileRepositoryBuilder repositoryBuilder = new FileRepositoryBuilder();
        ((FileRepositoryBuilder)((FileRepositoryBuilder)repositoryBuilder.findGitDir(fileInRepository)).setMustExist(true)).readEnvironment();
        if (null == repositoryBuilder.getGitDir()) {
            logger.debug((Object)("This is not in a Git repo   [" + fileInRepository + "]"));
            return null;
        }
        try {
            FileRepository repository = repositoryBuilder.build();
            System.out.println(repository);
            return new GitRepository(repository, this);
        }
        catch (IOException e) {
            logger.error((Object)"Unable to locate Git repo", (Throwable)e);
            return null;
        }
        catch (IllegalArgumentException e) {
            logger.error((Object)"Unable to locate Git repo", (Throwable)e);
            return null;
        }
    }

    public boolean displayListForFile(File file) {
        try {
            boolean result = false;
            GitRepository repository = this.buildGitRepository(file);
            LogCommand log2 = repository.git.log();
            URI relative = repository.makeRelativeURI(file);
            logger.info((Object)("Branch: " + repository.getBranch()));
            logger.info((Object)("File:   " + relative));
            Iterable call = log2.addPath(relative.getPath()).call();
            for (RevCommit revCommit : call) {
                logger.info((Object)("Revisions: " + revCommit.toString()));
                result = true;
            }
            return result;
        }
        catch (NoHeadException e) {
            e.printStackTrace();
        }
        catch (GitAPIException e) {
            e.printStackTrace();
        }
        return false;
    }
}

