/*
 * Decompiled with CFR 0.152.
 */
package de.renew.logging.gui;

import CH.ifa.draw.framework.Drawing;
import CH.ifa.draw.framework.DrawingView;
import CH.ifa.draw.framework.Figure;
import de.renew.application.SimulatorPlugin;
import de.renew.engine.events.NetEvent;
import de.renew.engine.events.PlaceEvent;
import de.renew.engine.events.SimulationEvent;
import de.renew.engine.events.TransitionEvent;
import de.renew.gui.CPNApplication;
import de.renew.gui.CPNInstanceDrawing;
import de.renew.gui.GuiPlugin;
import de.renew.gui.InstanceDrawing;
import de.renew.gui.InstanceFigure;
import de.renew.logging.gui.ErrorLevelTableRenderer;
import de.renew.logging.gui.MainRepositoryManager;
import de.renew.logging.gui.RepositoryChangeBuffer;
import de.renew.logging.gui.RepositoryChangeListener;
import de.renew.logging.gui.StepTableModel;
import de.renew.logging.gui.StepTrace;
import de.renew.logging.gui.StepTraceRemoveRequest;
import de.renew.logging.gui.StepTraceRepository;
import de.renew.logging.gui.TableModel;
import de.renew.net.NetElementID;
import de.renew.remote.NetInstanceAccessor;
import de.renew.remote.PlaceInstanceAccessor;
import de.renew.remote.RemotePlugin;
import de.renew.remote.TransitionInstanceAccessor;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.ListSelectionModel;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import org.apache.log4j.Logger;

public class LoggerTableModel
extends TableModel
implements RepositoryChangeListener {
    private static final Logger LOGGER = Logger.getLogger(LoggerTableModel.class);
    private boolean _permanentUpdate = true;
    private Set<RepositoryChangeListener> _listeners = new HashSet<RepositoryChangeListener>();
    private StepTraceRepository _repository;
    private List<StepTrace> _traces = new ArrayList<StepTrace>();
    private RepositoryChangeBuffer _eventBuffer = new RepositoryChangeBuffer();
    private Map<StepTrace, StepTableModel> _stepModels = new HashMap<StepTrace, StepTableModel>();

    public LoggerTableModel(String loggerName) {
        super(true);
        this._repository = MainRepositoryManager.getInstance().getCurrentRepository(loggerName);
        this._eventBuffer.addStepTraceChangeListener(this);
        if (this._repository != null) {
            this._repository.addRepositoryChangeListener(this._eventBuffer);
            StepTrace[] stepTraces = this._repository.getAllStepTraces();
            for (int x = 0; x < stepTraces.length; ++x) {
                this.addStepTrace(stepTraces[x]);
            }
        }
    }

    public void setPermanentUpdate(boolean update) {
        this._permanentUpdate = update;
    }

    private void addStepTrace(StepTrace stepTrace) {
        if (stepTrace.getStepIdentifier().getComponents().length > 0) {
            JPanel panel = new JPanel(new GridLayout(1, 1));
            StepTableModel stepModel = new StepTableModel(stepTrace, this._eventBuffer);
            JTable tb = new JTable(stepModel);
            ErrorLevelTableRenderer elr = new ErrorLevelTableRenderer();
            tb.setDefaultRenderer(Object.class, elr);
            stepModel.addTableModelListener(new TableModelListenerImpl(stepTrace));
            tb.addMouseListener(new PopupMenuMouseListener());
            panel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(0), stepTrace.toString()));
            panel.add(tb);
            this.addRow(new Object[]{panel});
            this._traces.add(stepTrace);
            this._stepModels.put(stepTrace, stepModel);
            this.fireTableRowsInserted(this.getRowCount() - 1, this.getRowCount() - 1);
            this.fireTableCellUpdated(this.getRowCount() - 1, 0);
        }
    }

    private void removeStepTrace(StepTrace stepTrace) {
        int row;
        if (stepTrace.getStepIdentifier().getComponents().length > 0 && (row = this._traces.indexOf(stepTrace)) != -1) {
            StepTableModel stepModel;
            this.removeRow(row);
            this._traces.remove(row);
            if (this._permanentUpdate) {
                this.fireTableRowsDeleted(row, row);
            }
            if ((stepModel = this._stepModels.get(stepTrace)) != null) {
                stepModel.dispose();
                this._stepModels.remove(stepTrace);
            }
        }
    }

    @Override
    public void stepTraceChanged(StepTrace stepTrace) {
        if (this._permanentUpdate) {
            this.fireStepTraceChanged(stepTrace);
        }
    }

    @Override
    public void stepTraceAdded(StepTraceRepository repository, StepTrace stepTrace) {
        if (this._permanentUpdate && this._eventBuffer != null) {
            this.addStepTrace(stepTrace);
            this.fireStepTraceAdded(repository, stepTrace);
        }
    }

    @Override
    public void stepTraceRemoved(StepTraceRepository repository, StepTrace stepTrace) {
        if (this._permanentUpdate) {
            this.removeStepTrace(stepTrace);
            this.fireStepTraceRemoved(repository, stepTrace);
        }
    }

    @Override
    public void stepTraceRemoveRequest(StepTraceRemoveRequest request) {
        assert (false) : "A stepTraceRemoveRequest should never reach a LoggerTableModel.";
    }

    public int getIndexOf(StepTrace stepTrace) {
        return this._traces.indexOf(stepTrace);
    }

    @Deprecated
    public void addRepositoryChangeListener(RepositoryChangeListener listener) {
        this._listeners.add(listener);
    }

    @Deprecated
    public void fireStepTraceChanged(StepTrace stepTrace) {
        RepositoryChangeListener[] l = this._listeners.toArray(new RepositoryChangeListener[0]);
        for (int x = 0; x < l.length; ++x) {
            l[x].stepTraceChanged(stepTrace);
        }
    }

    @Deprecated
    public void fireStepTraceAdded(StepTraceRepository repository, StepTrace stepTrace) {
        RepositoryChangeListener[] l = this._listeners.toArray(new RepositoryChangeListener[0]);
        for (int x = 0; x < l.length; ++x) {
            l[x].stepTraceAdded(repository, stepTrace);
        }
    }

    @Deprecated
    public void fireStepTraceRemoved(StepTraceRepository repository, StepTrace stepTrace) {
        RepositoryChangeListener[] l = this._listeners.toArray(new RepositoryChangeListener[0]);
        for (int x = 0; x < l.length; ++x) {
            l[x].stepTraceRemoved(repository, stepTrace);
        }
    }

    @Deprecated
    public void fireStepTraceRemoveRequest(StepTraceRemoveRequest request) {
        RepositoryChangeListener[] l = this._listeners.toArray(new RepositoryChangeListener[0]);
        for (int x = 0; x < l.length; ++x) {
            l[x].stepTraceRemoveRequest(request);
        }
    }

    protected void removeAll() {
        this._listeners.removeAll(this._listeners);
        this._traces.removeAll(this._traces);
        this._eventBuffer.stopBuffer();
        this._eventBuffer = null;
    }

    private class TableModelListenerImpl
    implements TableModelListener {
        private StepTrace _stepTrace;

        public TableModelListenerImpl(StepTrace stepTrace) {
            this._stepTrace = stepTrace;
        }

        @Override
        public void tableChanged(TableModelEvent e) {
            if (e.getType() == 1 || e.getType() == 0) {
                LoggerTableModel.this.fireTableCellUpdated(LoggerTableModel.this.getIndexOf(this._stepTrace), 0);
            }
        }
    }

    private class PopupMenuMouseListener
    extends MouseAdapter {
        private PopupMenuMouseListener() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            Component c = e.getComponent();
            if (c instanceof JTable && e.isPopupTrigger()) {
                this.openPopup((JTable)c, e);
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            Component c = e.getComponent();
            if (c instanceof JTable && e.isPopupTrigger()) {
                this.openPopup((JTable)c, e);
            }
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            Component c;
            if (e.getClickCount() == 2 && (c = e.getComponent()) instanceof JTable) {
                this.openDetailView((JTable)c, e);
            }
        }

        private void openPopup(JTable table, MouseEvent e) {
            Point p = e.getPoint();
            int row = table.rowAtPoint(p);
            ListSelectionModel selectionModel = table.getSelectionModel();
            selectionModel.setSelectionInterval(row, row);
            StepTableModel model = (StepTableModel)table.getModel();
            SimulationEvent simEvent = (SimulationEvent)model.getValueAt(row, 0);
            JPopupMenu popup = new JPopupMenu();
            if (SimulatorPlugin.getCurrent().isSimulationActive()) {
                RemotePlugin remote = RemotePlugin.getInstance();
                JMenuItem item1 = new JMenuItem("show net pattern");
                if (!(simEvent instanceof NetEvent)) {
                    item1.setEnabled(false);
                } else {
                    item1.addActionListener(new OpenNetPatternAction(remote.wrapInstance(((NetEvent)simEvent).getNetInstance())));
                }
                popup.add(item1);
                JMenuItem item2 = new JMenuItem("show net instance");
                if (!(simEvent instanceof NetEvent)) {
                    item2.setEnabled(false);
                } else {
                    item2.addActionListener(new OpenNetInstanceAction(remote.wrapInstance(((NetEvent)simEvent).getNetInstance())));
                }
                popup.add(item2);
                popup.addSeparator();
                JMenuItem item3 = new JMenuItem("show net pattern element");
                if (simEvent instanceof PlaceEvent || simEvent instanceof TransitionEvent) {
                    if (simEvent instanceof PlaceEvent) {
                        item3.addActionListener(new OpenNetPatternElementAction(remote.wrapInstance(((PlaceEvent)simEvent).getPlaceInstance())));
                    } else {
                        item3.addActionListener(new OpenNetPatternElementAction(remote.wrapInstance(((TransitionEvent)simEvent).getTransitionInstance())));
                    }
                } else {
                    item3.setEnabled(false);
                }
                popup.add(item3);
                JMenuItem item4 = new JMenuItem("show net instance element");
                if (simEvent instanceof PlaceEvent || simEvent instanceof TransitionEvent) {
                    if (simEvent instanceof PlaceEvent) {
                        item4.addActionListener(new OpenNetInstanceElementAction(remote.wrapInstance(((PlaceEvent)simEvent).getPlaceInstance())));
                    } else {
                        item4.addActionListener(new OpenNetInstanceElementAction(remote.wrapInstance(((TransitionEvent)simEvent).getTransitionInstance())));
                    }
                } else {
                    item4.setEnabled(false);
                }
                popup.add(item4);
            } else {
                JMenuItem item5 = new JMenuItem("Simulation terminated");
                item5.setEnabled(false);
                popup.add(item5);
            }
            popup.show(table, e.getX(), e.getY());
        }

        private void openDetailView(JTable table, MouseEvent e) {
            Point p = e.getPoint();
            int row = table.rowAtPoint(p);
            StepTableModel model = (StepTableModel)table.getModel();
            SimulationEvent simEvent = (SimulationEvent)model.getValueAt(row, 0);
            JFrame detailFrame = new JFrame();
            detailFrame.setSize(600, 300);
            detailFrame.getContentPane().setLayout(new BorderLayout());
            JTextArea textArea = new JTextArea(simEvent.toString());
            JScrollPane scrollPane = new JScrollPane(textArea);
            detailFrame.getContentPane().add((Component)scrollPane, "Center");
            detailFrame.setVisible(true);
        }

        private class OpenNetPatternAction
        implements ActionListener {
            private NetInstanceAccessor _netInstance;

            public OpenNetPatternAction(NetInstanceAccessor instance) {
                this._netInstance = instance;
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    GuiPlugin.getCurrent().getGui().openNetPatternDrawing(this._netInstance.getNet().getName());
                }
                catch (Exception ex) {
                    LOGGER.error((Object)ex.getMessage(), (Throwable)ex);
                }
            }
        }

        private class OpenNetInstanceAction
        implements ActionListener {
            private NetInstanceAccessor _netInstance;

            public OpenNetInstanceAction(NetInstanceAccessor instance) {
                this._netInstance = instance;
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                GuiPlugin.getCurrent().getGui().openInstanceDrawing(this._netInstance);
            }
        }

        private class OpenNetPatternElementAction
        implements ActionListener {
            private Object _elementInstance;

            public OpenNetPatternElementAction(PlaceInstanceAccessor instance) {
                this._elementInstance = instance;
            }

            public OpenNetPatternElementAction(TransitionInstanceAccessor instance) {
                this._elementInstance = instance;
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    NetInstanceAccessor netInstance = null;
                    NetElementID elementID = null;
                    if (this._elementInstance instanceof PlaceInstanceAccessor) {
                        PlaceInstanceAccessor placeInstance = (PlaceInstanceAccessor)this._elementInstance;
                        netInstance = placeInstance.getNetInstance();
                        elementID = placeInstance.getID();
                    } else if (this._elementInstance instanceof TransitionInstanceAccessor) {
                        TransitionInstanceAccessor transitionInstance = (TransitionInstanceAccessor)this._elementInstance;
                        netInstance = transitionInstance.getNetInstance();
                        elementID = transitionInstance.getID();
                    }
                    int figureID = 0;
                    if (elementID != null) {
                        figureID = elementID.getFigureID();
                    }
                    GuiPlugin guiPlugin = GuiPlugin.getCurrent();
                    CPNApplication gui = guiPlugin.getGui();
                    if (netInstance != null) {
                        String netName = netInstance.getNet().getName();
                        gui.openNetPatternDrawing(netName, figureID);
                    }
                }
                catch (Exception ex) {
                    LOGGER.error((Object)ex.getMessage(), (Throwable)ex);
                }
            }
        }

        private class OpenNetInstanceElementAction
        implements ActionListener {
            private Object _elementInstance;

            public OpenNetInstanceElementAction(PlaceInstanceAccessor instance) {
                this._elementInstance = instance;
            }

            public OpenNetInstanceElementAction(TransitionInstanceAccessor instance) {
                this._elementInstance = instance;
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    NetInstanceAccessor netInstance = null;
                    NetElementID elementID = null;
                    if (this._elementInstance instanceof PlaceInstanceAccessor) {
                        PlaceInstanceAccessor placeInstance = (PlaceInstanceAccessor)this._elementInstance;
                        netInstance = placeInstance.getNetInstance();
                        elementID = placeInstance.getID();
                    } else if (this._elementInstance instanceof TransitionInstanceAccessor) {
                        TransitionInstanceAccessor transitionInstance = (TransitionInstanceAccessor)this._elementInstance;
                        netInstance = transitionInstance.getNetInstance();
                        elementID = transitionInstance.getID();
                    }
                    int figureID = 0;
                    if (elementID != null) {
                        figureID = elementID.getFigureID();
                    }
                    GuiPlugin guiPlugin = GuiPlugin.getCurrent();
                    CPNApplication gui = guiPlugin.getGui();
                    gui.openInstanceDrawing(netInstance);
                    InstanceDrawing instDwg = CPNInstanceDrawing.getInstanceDrawing((NetInstanceAccessor)netInstance);
                    if (instDwg != null && figureID != 0) {
                        InstanceFigure figure = instDwg.getInstanceFigureOfFigureWithID(figureID);
                        DrawingView view = gui.getView((Drawing)instDwg);
                        if (figure != null && view != null) {
                            view.clearSelection();
                            view.addToSelection((Figure)figure);
                            view.repairDamage();
                        }
                    }
                }
                catch (Exception ex) {
                    LOGGER.error((Object)ex.getMessage(), (Throwable)ex);
                }
            }
        }
    }
}

