/*
 * Decompiled with CFR 0.152.
 */
package de.renew.logging.gui;

import de.renew.engine.events.SimulationEvent;
import de.renew.logging.gui.RepositoryChangeBuffer;
import de.renew.logging.gui.StepTrace;
import de.renew.logging.gui.StepTraceChangeListener;
import de.renew.logging.gui.TableModel;
import java.util.Arrays;
import org.apache.log4j.Logger;

public class StepTableModel
extends TableModel
implements StepTraceChangeListener {
    private static final Logger LOGGER = Logger.getLogger(StepTableModel.class);
    private StepTrace _stepTrace;
    private RepositoryChangeBuffer _eventBuffer;

    public StepTableModel(StepTrace stepTrace, RepositoryChangeBuffer eventBuffer) {
        super(false);
        this._stepTrace = stepTrace;
        this._eventBuffer = eventBuffer;
        eventBuffer.addStepTraceChangeListener(this);
        stepTrace.addStepTraceChangeListener(eventBuffer);
        Object[] messages = stepTrace.getEvents();
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace((Object)(StepTableModel.class.getSimpleName() + ": Initially including " + messages.length + " events for " + String.valueOf(stepTrace) + ".\n" + Arrays.toString(messages)));
        }
        for (int x = 0; x < messages.length; ++x) {
            this.addRow(new Object[]{messages[x]});
        }
    }

    @Override
    public void stepTraceChanged(StepTrace stepTrace) {
        if (stepTrace == this._stepTrace) {
            SimulationEvent[] messages = stepTrace.getEvents();
            for (int x = this.getRowCount(); x < messages.length; ++x) {
                this.addRow(new Object[]{messages[x]});
            }
            this.fireTableRowsInserted(this.getRowCount() - messages.length - 1, this.getRowCount() - 1);
        }
    }

    public void dispose() {
        this._stepTrace.removeStepTraceChangeListener(this._eventBuffer);
        this._eventBuffer.removeStepTraceChangeListener(this);
    }
}

