/*
 * Decompiled with CFR 0.152.
 */
package de.renew.refactoring.edit;

import de.renew.refactoring.edit.IteratorEditor;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.util.List;
import org.apache.log4j.Logger;

public abstract class LineByLineFileEditor
extends IteratorEditor<File, Void> {
    private static final Logger LOGGER = Logger.getLogger(LineByLineFileEditor.class);

    public LineByLineFileEditor(List<File> edits) {
        super(edits);
    }

    @Override
    public String getCurrentEditString() {
        return ((File)this.getCurrentEdit()).getName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Void performEdit(File file) {
        BufferedReader in = null;
        BufferedWriter out = null;
        try {
            File tmpFile = new File(file.getPath() + "tmp");
            tmpFile.createNewFile();
            in = new BufferedReader(new InputStreamReader(new FileInputStream(file)));
            out = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(tmpFile)));
            String oldLine = in.readLine();
            while (oldLine != null) {
                String newLine = this.editLine(oldLine);
                out.write(newLine);
                out.newLine();
                oldLine = in.readLine();
            }
            if (file.delete() && tmpFile.renameTo(file)) {
                LOGGER.info((Object)("Replacing file successful: " + String.valueOf(file)));
            }
        }
        catch (IOException e) {
            LOGGER.error((Object)("I/O Error occured while trying to replace " + String.valueOf(file) + "."));
            e.printStackTrace();
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            try {
                if (out != null) {
                    out.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    protected abstract String editLine(String var1);
}

