/*
 * Decompiled with CFR 0.152.
 */
package de.renew.refactoring.edit;

import de.renew.refactoring.match.Match;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public abstract class MatchSorter<T extends Match, S> {
    private static final Logger LOGGER = Logger.getLogger(MatchSorter.class);
    private Comparator<T> _comparator;

    public List<T> sorted(List<T> matches) {
        Map<S, List<T>> groups = this.groupedMatches(matches);
        for (List<T> group : groups.values()) {
            this.sortGroup(group);
        }
        ArrayList<T> sortedMatches = new ArrayList<T>();
        for (List<T> group : groups.values()) {
            sortedMatches.addAll(group);
        }
        return sortedMatches;
    }

    protected abstract S group(T var1);

    private Map<S, List<T>> groupedMatches(List<T> matches) {
        HashMap grouped = new HashMap();
        for (Match match : matches) {
            S group = this.group(match);
            if (!grouped.containsKey(group)) {
                grouped.put(group, new ArrayList());
            }
            ((List)grouped.get(group)).add(match);
        }
        return grouped;
    }

    private void sortGroup(List<T> group) {
        if (this._comparator == null) {
            this._comparator = new Comparator<T>(){

                @Override
                public int compare(T first, T second) {
                    return ((Match)second).getStart() - ((Match)first).getStart();
                }
            };
        }
        Collections.sort(group, this._comparator);
    }
}

