/*
 * Decompiled with CFR 0.152.
 */
package de.renew.refactoring.wizard;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ListDataListener;
import org.apache.log4j.Logger;

public abstract class ListPanel<T>
extends JPanel {
    private static final long serialVersionUID = 8757223583811214544L;
    private static final Logger LOGGER = Logger.getLogger(ListPanel.class);
    private final List<T> _data;
    private final JList<String> _list;

    public ListPanel(List<T> list) {
        this(list, null);
    }

    public ListPanel(List<T> list, String title) {
        this._data = list;
        this._list = new JList();
        this.createPanel(title != null ? title : "");
    }

    protected abstract String getTitleForItem(T var1);

    protected abstract void openItem(T var1);

    private void createPanel(String title) {
        this.setLayout(new BorderLayout(0, 10));
        if (!title.isEmpty()) {
            JLabel label = new JLabel(title);
            this.add((Component)label, "North");
        }
        this._list.setModel(new ListModel<String>(){

            @Override
            public int getSize() {
                return ListPanel.this._data.size();
            }

            @Override
            public String getElementAt(int index) {
                return ListPanel.this.getTitleForItem(ListPanel.this._data.get(index));
            }

            @Override
            public void addListDataListener(ListDataListener l) {
            }

            @Override
            public void removeListDataListener(ListDataListener l) {
            }
        });
        this.add(this._list, "Center");
        MouseAdapter mouseListener = new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    int index = ListPanel.this._list.locationToIndex(e.getPoint());
                    LOGGER.debug((Object)("Double clicked on Item " + index));
                    ListPanel.this.openItem(ListPanel.this._data.get(index));
                }
            }
        };
        this._list.addMouseListener(mouseListener);
    }

    public void focus() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ListPanel.this._list.requestFocusInWindow();
            }
        });
    }
}

