/*
 * Decompiled with CFR 0.152.
 */
package de.renew.refactoring.wizard;

import de.renew.refactoring.wizard.WizardPage;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;

public abstract class ProgressBarWizardPage<T>
extends WizardPage {
    private JProgressBar _progressBar;
    private JLabel _statusLabel;
    private boolean _isInProgress = true;

    public ProgressBarWizardPage(String id) {
        super(id);
        JPanel panel = this.getPanel();
        panel.setLayout(new BoxLayout(panel, 3));
        this._progressBar = new JProgressBar();
        panel.add(this._progressBar);
        this._statusLabel = new JLabel();
        panel.add(this._statusLabel);
    }

    public void setProgress(int progress) {
        this._progressBar.setValue(progress);
    }

    public void setStatus(String status) {
        this._statusLabel.setText(status);
    }

    public void setStatus(String status, String itemName) {
        this.setStatus("<html>" + status + ": <i>" + itemName + "</i></html>");
    }

    public boolean isInProgress() {
        return this._isInProgress;
    }

    public final void done(T result) {
        this._isInProgress = false;
        JPanel panel = this.getPanel();
        this.restoreDefaultLayout();
        panel.remove(this._progressBar);
        panel.remove(this._statusLabel);
        panel.repaint();
        panel.revalidate();
        this._progressBar = null;
        this._statusLabel = null;
        this.progressDone(result);
    }

    protected abstract void progressDone(T var1);
}

