/*
 * Decompiled with CFR 0.152.
 */
package de.renew.remote;

import de.renew.application.NoSimulationException;
import de.renew.application.SimulatorExtension;
import de.renew.application.SimulatorPlugin;
import de.renew.net.Net;
import de.renew.net.NetInstance;
import de.renew.net.PlaceInstance;
import de.renew.net.TransitionInstance;
import de.renew.plugin.PluginAdapter;
import de.renew.plugin.PluginException;
import de.renew.plugin.PluginProperties;
import de.renew.remote.NetAccessor;
import de.renew.remote.NetAccessorImpl;
import de.renew.remote.NetInstanceAccessor;
import de.renew.remote.NetInstanceAccessorImpl;
import de.renew.remote.PlaceInstanceAccessor;
import de.renew.remote.PlaceInstanceAccessorImpl;
import de.renew.remote.RemoteExtension;
import de.renew.remote.TransitionInstanceAccessor;
import de.renew.remote.TransitionInstanceAccessorImpl;
import java.net.URL;
import java.rmi.RemoteException;
import java.util.concurrent.Callable;
import org.apache.log4j.Logger;

public class RemotePlugin
extends PluginAdapter {
    public static final Logger LOGGER = Logger.getLogger(SimulatorPlugin.class);
    private static final String RMI_HOST_NAME = "de.renew.remote.rmi-host-name";
    private static RemotePlugin _instance;

    public RemotePlugin(URL url) throws PluginException {
        super(url);
        this.setInstance();
        this.setup();
    }

    public RemotePlugin(PluginProperties props) {
        super(props);
        this.setInstance();
        this.setup();
    }

    private void setup() {
        SimulatorPlugin.getCurrent().addExtension((SimulatorExtension)new RemoteExtension());
    }

    private void setInstance() {
        if (_instance == null) {
            _instance = this;
        }
    }

    public NetInstanceAccessor wrapInstance(final NetInstance instance) throws NoSimulationException {
        final SimulatorPlugin sim = SimulatorPlugin.getCurrent();
        try {
            return (NetInstanceAccessor)sim.submitAndWait((Callable)new Callable<NetInstanceAccessor>(){

                @Override
                public NetInstanceAccessor call() throws NoSimulationException {
                    NetInstanceAccessorImpl returnValue = null;
                    try {
                        returnValue = instance == null ? null : new NetInstanceAccessorImpl(instance, sim.getCurrentEnvironment());
                    }
                    catch (RemoteException e) {
                        LOGGER.error((Object)("Wrapping of net instance failed: " + String.valueOf(e)));
                    }
                    return returnValue;
                }
            });
        }
        catch (InterruptedException e) {
            LOGGER.error((Object)"Timeout while waiting for simulation thread to finish", (Throwable)e);
            return null;
        }
    }

    public PlaceInstanceAccessor wrapInstance(final PlaceInstance instance) {
        final SimulatorPlugin sim = SimulatorPlugin.getCurrent();
        try {
            return (PlaceInstanceAccessor)sim.submitAndWait((Callable)new Callable<PlaceInstanceAccessor>(){

                @Override
                public PlaceInstanceAccessor call() throws NoSimulationException {
                    PlaceInstanceAccessorImpl returnValue = null;
                    try {
                        returnValue = instance == null ? null : new PlaceInstanceAccessorImpl(instance, sim.getCurrentEnvironment());
                    }
                    catch (RemoteException e) {
                        LOGGER.error((Object)("Wrapping of place instance failed: " + String.valueOf(e)));
                    }
                    return returnValue;
                }
            });
        }
        catch (InterruptedException e) {
            LOGGER.error((Object)"Timeout while waiting for simulation thread to finish", (Throwable)e);
            return null;
        }
    }

    public TransitionInstanceAccessor wrapInstance(final TransitionInstance instance) {
        final SimulatorPlugin sim = SimulatorPlugin.getCurrent();
        try {
            return (TransitionInstanceAccessor)sim.submitAndWait((Callable)new Callable<TransitionInstanceAccessor>(){

                @Override
                public TransitionInstanceAccessor call() throws NoSimulationException {
                    TransitionInstanceAccessorImpl returnValue = null;
                    try {
                        returnValue = instance == null ? null : new TransitionInstanceAccessorImpl(instance, sim.getCurrentEnvironment());
                    }
                    catch (RemoteException e) {
                        LOGGER.error((Object)("Wrapping of transition instance failed: " + String.valueOf(e)));
                    }
                    return returnValue;
                }
            });
        }
        catch (InterruptedException e) {
            LOGGER.error((Object)"Timeout while waiting for simulation thread to finish", (Throwable)e);
            return null;
        }
    }

    public NetAccessor wrapNet(final Net net) {
        final SimulatorPlugin sim = SimulatorPlugin.getCurrent();
        try {
            return (NetAccessor)sim.submitAndWait((Callable)new Callable<NetAccessor>(){

                @Override
                public NetAccessor call() throws NoSimulationException {
                    NetAccessorImpl returnValue = null;
                    try {
                        returnValue = net == null ? null : new NetAccessorImpl(net, sim.getCurrentEnvironment());
                    }
                    catch (RemoteException e) {
                        LOGGER.error((Object)("Wrapping of net failed: " + String.valueOf(e)));
                    }
                    return returnValue;
                }
            });
        }
        catch (InterruptedException e) {
            LOGGER.error((Object)"Timeout while waiting for simulation thread to finish", (Throwable)e);
            return null;
        }
    }

    public static RemotePlugin getInstance() {
        return _instance;
    }

    public static void configureInterface() {
        String hostAddress = RemotePlugin.getInstance().getProperties().getProperty(RMI_HOST_NAME);
        if (hostAddress != null) {
            System.setProperty("java.rmi.server.hostname", hostAddress);
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info((Object)(RemoteExtension.class.getSimpleName() + ": RMI host address set to: " + hostAddress));
            }
        }
    }
}

