/*
 * Decompiled with CFR 0.152.
 */
package org.gitective.core.stat;

import java.util.Calendar;
import org.gitective.core.stat.Month;

public class YearCommitActivity {
    public static final int MONTHS = 12;
    public static final int HOURS = 24;
    public static final int DAYS = 31;
    private final int year;
    private final int[][][] commits;
    private int total;

    public YearCommitActivity(int year) {
        this.year = year;
        this.commits = new int[12][][];
        for (Month month : Month.values()) {
            this.commits[month.number] = new int[month.days][24];
        }
    }

    public YearCommitActivity add(Calendar calendar) {
        int month = calendar.get(2);
        int day = calendar.get(5) - 1;
        int hour = calendar.get(11);
        int[] nArray = this.commits[month][day];
        int n = hour;
        nArray[n] = nArray[n] + 1;
        ++this.total;
        return this;
    }

    public int[] getMonths() {
        return this.getMonths(new int[12]);
    }

    public int[] getMonths(int[] months) {
        int[][][] commits = this.commits;
        for (int i = 0; i < 12; ++i) {
            for (int j = 0; j < commits[i].length; ++j) {
                for (int k = 0; k < 24; ++k) {
                    int n = i;
                    months[n] = months[n] + commits[i][j][k];
                }
            }
        }
        return months;
    }

    public int[] getDays() {
        return this.getDays(new int[31]);
    }

    public int[] getDays(int[] days) {
        int[][][] commits = this.commits;
        for (int i = 0; i < 12; ++i) {
            for (int j = 0; j < commits[i].length; ++j) {
                for (int k = 0; k < 24; ++k) {
                    int n = j;
                    days[n] = days[n] + commits[i][j][k];
                }
            }
        }
        return days;
    }

    public int[] getHours() {
        return this.getHours(new int[24]);
    }

    public int[] getHours(int[] hours) {
        int[][][] commits = this.commits;
        for (int i = 0; i < 12; ++i) {
            for (int j = 0; j < commits[i].length; ++j) {
                for (int k = 0; k < 24; ++k) {
                    int n = k;
                    hours[n] = hours[n] + commits[i][j][k];
                }
            }
        }
        return hours;
    }

    public int getMonthCount(Month month) {
        return this.getMonthCount(month.number);
    }

    public int getMonthCount(int month) {
        int total = 0;
        int[][] monthly = this.commits[month];
        for (int i = 0; i < monthly.length; ++i) {
            for (int j = 0; j < 24; ++j) {
                total += monthly[i][j];
            }
        }
        return total;
    }

    public int getHourCount(int hour) {
        int[][][] commits = this.commits;
        int total = 0;
        for (int i = 0; i < 12; ++i) {
            for (int j = 0; j < commits[i].length; ++j) {
                total += commits[i][j][hour];
            }
        }
        return total;
    }

    public int getDayCount(int dayOfMonth) {
        int[][][] commits = this.commits;
        int total = 0;
        for (int i = 0; i < 12; ++i) {
            int days = commits[i].length;
            if (dayOfMonth >= days) continue;
            int[] hours = commits[i][dayOfMonth];
            for (int j = 0; j < 24; ++j) {
                total += hours[j];
            }
        }
        return total;
    }

    public int getYear() {
        return this.year;
    }

    public int getCount() {
        return this.total;
    }
}

