/*
 * Decompiled with CFR 0.152.
 */
package de.renew.gui;

import java.awt.Graphics;
import java.awt.Rectangle;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.ImageIcon;
import org.apache.log4j.Logger;

public class BreakpointDecoration {
    private static final Logger logger = Logger.getLogger(BreakpointDecoration.class);
    private static ImageIcon icon = null;
    private static boolean failed = false;
    private static int iconWidth = 0;

    private BreakpointDecoration() {
    }

    private static ImageIcon getIcon() {
        if (icon == null && !failed) {
            String name = "/de/renew/gui/images/BP_TAG.gif";
            URL url = BreakpointDecoration.class.getResource(name);
            if (url == null) {
                logger.warn((Object)("Could not retrieve icon via class loader, trying file system: " + name));
                File file = new File(name);
                if (!file.isFile()) {
                    logger.warn((Object)("Icon file is not a regular file: " + String.valueOf(file)));
                } else {
                    try {
                        url = file.toURI().toURL();
                    }
                    catch (MalformedURLException e) {
                        logger.warn((Object)("Icon file is not valid as URL: " + String.valueOf(file)), (Throwable)e);
                    }
                }
            }
            if (url == null) {
                failed = true;
            } else {
                icon = new ImageIcon(url);
                iconWidth = icon.getImage().getWidth(null);
            }
        }
        return icon;
    }

    public static void draw(Graphics g, Rectangle box) {
        ImageIcon imageIcon = BreakpointDecoration.getIcon();
        if (imageIcon != null) {
            imageIcon.paintIcon(null, g, box.x + box.width - iconWidth, box.y);
        }
    }
}

