/*
 * Decompiled with CFR 0.152.
 */
package de.renew.gui;

import CH.ifa.draw.figures.LineConnection;
import CH.ifa.draw.framework.ConnectionFigure;
import CH.ifa.draw.framework.Figure;
import CH.ifa.draw.framework.FigureChangeAdapter;
import CH.ifa.draw.framework.FigureChangeEvent;
import CH.ifa.draw.framework.FigureChangeListener;
import CH.ifa.draw.framework.FigureEnumeration;
import CH.ifa.draw.framework.FilterContainer;
import CH.ifa.draw.io.SimpleFileFilter;
import CH.ifa.draw.standard.AbstractFigure;
import CH.ifa.draw.standard.CompositeFigure;
import CH.ifa.draw.standard.StandardDrawing;
import CH.ifa.draw.util.Storable;
import CH.ifa.draw.util.StorableInput;
import CH.ifa.draw.util.StorableOutput;
import de.renew.gui.CPNFigureEvent;
import de.renew.gui.CPNFigureListener;
import de.renew.gui.CPNTextFigure;
import de.renew.gui.DeclarationFigure;
import de.renew.gui.FigureWithHighlight;
import de.renew.gui.GraphLayout;
import de.renew.gui.LayoutableDrawing;
import de.renew.gui.NodeFigure;
import de.renew.gui.ShadowHolder;
import de.renew.io.RNWFileFilter;
import de.renew.shadow.ShadowNet;
import de.renew.shadow.ShadowNetElement;
import de.renew.shadow.ShadowNetSystem;
import java.awt.Dimension;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.NoSuchElementException;
import java.util.Vector;
import org.apache.log4j.Logger;

public class CPNDrawing
extends StandardDrawing
implements LayoutableDrawing {
    private static final Logger logger = Logger.getLogger(CPNDrawing.class);
    protected transient ShadowNet shadowNet = null;
    private AbstractFigure iconFigure = null;
    private transient Hashtable<Figure, Figure> hilightMap = new Hashtable();
    private final transient Vector<CPNFigureListener> _figureListeners = new Vector();

    public void release() {
        super.release();
        this.discardShadow();
    }

    public ShadowNet getShadow() {
        return this.shadowNet;
    }

    static CPNDrawing findDrawing(Object errorObject) {
        if (errorObject instanceof ShadowNetElement) {
            return (CPNDrawing)((ShadowNetElement)errorObject).getNet().context;
        }
        return null;
    }

    public void discardShadow() {
        if (this.shadowNet != null) {
            this.shadowNet.discard();
            this.shadowNet = null;
        }
    }

    private void buildShadow(Class<?> clazz) {
        FigureEnumeration k = this.figures();
        while (k.hasMoreElements()) {
            Figure fig = k.nextFigure();
            if (!(fig instanceof ShadowHolder) || !clazz.isInstance(fig)) continue;
            ((ShadowHolder)fig).buildShadow(this.shadowNet);
        }
    }

    public ShadowNet buildShadow(ShadowNetSystem netSystem) {
        this.discardShadow();
        this.shadowNet = new ShadowNet(this.getName(), netSystem);
        this.shadowNet.context = this;
        this.buildShadow(DeclarationFigure.class);
        this.buildShadow(NodeFigure.class);
        this.buildShadow(LineConnection.class);
        this.buildShadow(CPNTextFigure.class);
        return this.shadowNet;
    }

    public void setIconFigure(AbstractFigure iconFigure) {
        this.iconFigure = iconFigure;
    }

    public Figure getIconFigure() {
        return this.iconFigure;
    }

    public Figure remove(Figure figure) {
        Figure hilight;
        if (figure == this.iconFigure) {
            this.iconFigure = null;
        }
        if (figure instanceof FigureWithHighlight && (hilight = ((FigureWithHighlight)figure).getHighlightFigure()) != null) {
            this.hilightMap.remove(hilight);
        }
        Figure result = super.remove(figure);
        if (figure instanceof CompositeFigure) {
            this.recomputeHilightMap();
        }
        this.notifyListeners(figure, false);
        return result;
    }

    public void write(StorableOutput dw) {
        super.write(dw);
        dw.writeStorable((Storable)this.iconFigure);
    }

    public void read(StorableInput dr) throws IOException {
        super.read(dr);
        if (dr.getVersion() >= 2) {
            try {
                this.iconFigure = (AbstractFigure)dr.readStorable();
            }
            catch (IOException e) {
                logger.error((Object)"Icon expected.");
                logger.debug((Object)"Icon expected.", (Throwable)e);
            }
            if (dr.getVersion() >= 3) {
                this.recomputeHilightMap();
            }
        }
    }

    @Override
    public synchronized void fillInGraph(GraphLayout layout) {
        FigureEnumeration k = this.figures();
        while (k.hasMoreElements()) {
            Figure f = k.nextFigure();
            if (f instanceof NodeFigure) {
                layout.addNode(f);
                continue;
            }
            if (!(f instanceof ConnectionFigure)) continue;
            ConnectionFigure connectionFigure = (ConnectionFigure)f;
            layout.addEdge(connectionFigure, 20);
        }
    }

    void setHighlightFigure(final FigureWithHighlight node, final Figure fig) {
        Figure oldHighlight = node.getHighlightFigure();
        if (oldHighlight != null) {
            this.hilightMap.remove(oldHighlight);
        }
        node.setHighlightFigure(fig);
        if (fig != null) {
            this.hilightMap.put(fig, (Figure)node);
            fig.addFigureChangeListener((FigureChangeListener)new FigureChangeAdapter(){

                public void figureRemoved(FigureChangeEvent e) {
                    CPNDrawing.this.setHighlightFigure(node, null);
                }
            });
            node.addFigureChangeListener((FigureChangeListener)new FigureChangeAdapter(){

                public void figureRemoved(FigureChangeEvent e) {
                    CPNDrawing.this.hilightMap.remove(fig);
                }
            });
        }
    }

    FigureWithHighlight getFigureForHighlight(Figure hilightFig) {
        try {
            return (FigureWithHighlight)this.hilightMap.get(hilightFig);
        }
        catch (NoSuchElementException e) {
            return null;
        }
    }

    public Dimension defaultSize() {
        return new Dimension(535, 788);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.hilightMap = new Hashtable();
        this.recomputeHilightMap();
    }

    private void recomputeHilightMap() {
        this.hilightMap.clear();
        this.addToHilightMap((CompositeFigure)this);
    }

    private void addToHilightMap(CompositeFigure container) {
        FigureEnumeration figenumeration = container.figures();
        while (figenumeration.hasMoreElements()) {
            Figure hilight;
            Figure fig = figenumeration.nextFigure();
            if (fig instanceof FigureWithHighlight && (hilight = ((FigureWithHighlight)fig).getHighlightFigure()) != null) {
                this.hilightMap.put(hilight, fig);
            }
            if (!(fig instanceof CompositeFigure)) continue;
            CompositeFigure compositeFigure = (CompositeFigure)fig;
            this.addToHilightMap(compositeFigure);
        }
    }

    public String getWindowCategory() {
        return "Nets";
    }

    public Figure add(Figure figure) {
        Figure hilight;
        Figure result = super.add(figure);
        if (figure instanceof FigureWithHighlight && (hilight = ((FigureWithHighlight)figure).getHighlightFigure()) != null) {
            this.hilightMap.put(hilight, figure);
        }
        if (figure instanceof CompositeFigure) {
            this.recomputeHilightMap();
        }
        this.notifyListeners(figure, true);
        return result;
    }

    public static FilterContainer getFilterContainer() {
        return new FilterContainer((SimpleFileFilter)new RNWFileFilter());
    }

    public SimpleFileFilter getDefaultFileFilter() {
        return CPNDrawing.getFilterContainer().getDefaultFileFilter();
    }

    public HashSet<SimpleFileFilter> getImportFileFilters() {
        return CPNDrawing.getFilterContainer().getImportFileFilters();
    }

    public HashSet<SimpleFileFilter> getExportFileFilters() {
        return CPNDrawing.getFilterContainer().getExportFileFilters();
    }

    public String getDefaultExtension() {
        return this.getDefaultFileFilter().getExtension();
    }

    public void addFigureListener(CPNFigureListener listener) {
        this._figureListeners.add(listener);
    }

    public void removeFigureListener(CPNFigureListener listener) {
        this._figureListeners.remove(listener);
    }

    private void notifyListeners(Figure figure, boolean add) {
        for (int i = 0; i < this._figureListeners.size(); ++i) {
            if (add) {
                this._figureListeners.elementAt(i).cpnFigureAdded(new CPNFigureEvent(this, figure));
                continue;
            }
            this._figureListeners.elementAt(i).cpnFigureRemoved(new CPNFigureEvent(this, figure));
        }
    }
}

