/*
 * Decompiled with CFR 0.152.
 */
package de.renew.gui;

import CH.ifa.draw.figures.TextFigure;
import CH.ifa.draw.framework.Figure;
import de.renew.gui.ArcConnection;
import de.renew.gui.CPNTextFigure;
import de.renew.gui.FigureCreator;
import de.renew.gui.FigureCreatorHolder;
import de.renew.gui.InscribableFigure;
import de.renew.gui.PlaceFigure;
import de.renew.gui.TextFigureCreator;
import de.renew.gui.TransitionFigure;
import de.renew.remote.ObjectAccessor;
import de.renew.util.TextToken;
import java.rmi.RemoteException;
import java.util.Vector;
import org.apache.log4j.Logger;

public class FigureCreatorComposition
implements FigureCreator,
TextFigureCreator,
FigureCreatorHolder {
    private static final Logger logger = Logger.getLogger(FigureCreatorComposition.class);
    private final Vector<FigureCreator> _figureCreators = new Vector();
    private final Vector<TextFigureCreator> _textFigureCreators = new Vector();

    @Override
    public void registerCreator(FigureCreator creator) {
        this._figureCreators.add(creator);
    }

    @Override
    public void registerCreator(TextFigureCreator creator) {
        this._textFigureCreators.add(creator);
    }

    @Override
    public void unregisterCreator(FigureCreator creator) {
        this._figureCreators.remove(creator);
    }

    @Override
    public void unregisterCreator(TextFigureCreator creator) {
        this._textFigureCreators.remove(creator);
    }

    @Override
    public boolean canCreateFigure(ObjectAccessor o, boolean expanded) throws RemoteException {
        for (FigureCreator fc : this._figureCreators) {
            if (!fc.canCreateFigure(o, expanded)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean canCreateFigure(InscribableFigure f) {
        for (FigureCreator figureCreator : this._figureCreators) {
            TextFigureCreator fc = (TextFigureCreator)((Object)figureCreator);
            if (!fc.canCreateFigure(f)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean canCreateDefaultInscription(InscribableFigure f) {
        for (FigureCreator figureCreator : this._figureCreators) {
            TextFigureCreator fc = (TextFigureCreator)((Object)figureCreator);
            if (!fc.canCreateDefaultInscription(f)) continue;
            return true;
        }
        return false;
    }

    @Override
    public TextFigure createTextFigure(InscribableFigure figure) {
        TextFigure result = null;
        for (TextFigureCreator creator : this._textFigureCreators) {
            if (!creator.canCreateFigure(figure)) continue;
            logger.debug((Object)("FigureCreation: " + String.valueOf(creator) + " creates a text figure for " + String.valueOf(figure)));
            result = creator.createTextFigure(figure);
            break;
        }
        if (result == null) {
            logger.debug((Object)("FigureCreation: creating default text figure for " + String.valueOf(figure)));
            return new CPNTextFigure();
        }
        return result;
    }

    @Override
    public String getDefaultInscription(InscribableFigure figure) {
        String result = null;
        for (TextFigureCreator creator : this._textFigureCreators) {
            if (!creator.canCreateDefaultInscription(figure)) continue;
            logger.debug((Object)("FigureCreation: " + String.valueOf(creator) + " creates an inscription for " + String.valueOf(figure)));
            result = creator.getDefaultInscription(figure);
            break;
        }
        if (result == null) {
            logger.debug((Object)("FigureCreation: creating default inscription for " + String.valueOf(figure)));
            if (figure instanceof ArcConnection) {
                return "x";
            }
            if (figure instanceof PlaceFigure) {
                return "[]";
            }
            if (figure instanceof TransitionFigure) {
                return ":s()";
            }
            return "";
        }
        return result;
    }

    @Override
    public Figure getTokenFigure(ObjectAccessor token, boolean expanded) throws RemoteException {
        Figure result = null;
        for (FigureCreator creator : this._figureCreators) {
            if (!creator.canCreateFigure(token, expanded)) continue;
            logger.debug((Object)(String.valueOf(creator) + " creates a representation for this token."));
            result = creator.getTokenFigure(token, expanded);
            break;
        }
        if (result == null) {
            logger.debug((Object)"creating default representation for this token.");
            return new TextFigure(FigureCreatorComposition.objectToString(token), true);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("got token figure for token " + String.valueOf(token) + " --> result figure " + String.valueOf(result)));
        }
        return result;
    }

    public static String objectToString(ObjectAccessor token) throws RemoteException {
        StringBuilder output = new StringBuilder();
        if (token == null) {
            output.append("null");
        } else if (token.isInstanceOf(String.class)) {
            output.append('\"').append(token.asString()).append('\"');
        } else if (token.isInstanceOf(TextToken.class)) {
            output.append(token.asTextToken().toTokenText());
        } else {
            output.append(token.asString());
        }
        return output.toString();
    }
}

