/*
 * Decompiled with CFR 0.152.
 */
package de.renew.gui;

import CH.ifa.draw.DrawPlugin;
import CH.ifa.draw.IOHelper;
import CH.ifa.draw.application.DrawApplication;
import CH.ifa.draw.framework.Drawing;
import CH.ifa.draw.io.DrawingFileHelper;
import CH.ifa.draw.io.PositionedDrawing;
import CH.ifa.draw.io.StatusDisplayer;
import de.renew.gui.CPNDrawing;
import de.renew.gui.CPNDrawingLoader;
import de.renew.gui.ModeReplacement;
import de.renew.net.loading.Finder;
import de.renew.shadow.ShadowCompilerFactory;
import de.renew.shadow.ShadowNetSystem;
import de.renew.util.ClassSource;
import de.renew.util.StringUtil;
import java.awt.EventQueue;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Iterator;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;

public class GuiFinder
extends Finder {
    private static final Logger logger = Logger.getLogger(GuiFinder.class);
    final CPNDrawingLoader loader;

    public GuiFinder(CPNDrawingLoader loader) {
        this.loader = loader;
    }

    public ShadowNetSystem findNetFile(String name, String path) {
        ShadowNetSystem netSystem = null;
        CPNDrawing drawing = this.getDrawingFromLoader(name);
        if (drawing == null) {
            drawing = this.getDrawingFromFile(path);
        }
        if (drawing != null) {
            netSystem = this.compileDrawing(drawing);
        } else {
            logger.debug((Object)"GuiFinder: No drawing found.");
        }
        return netSystem;
    }

    public ShadowNetSystem findNetClasspathRel(String name, String path) {
        ShadowNetSystem netSystem = null;
        CPNDrawing drawing = this.getDrawingFromLoader(name);
        if (drawing == null) {
            drawing = this.getDrawingFromFileClasspathRel(path);
        }
        if (drawing != null) {
            netSystem = this.compileDrawing(drawing);
        } else {
            logger.debug((Object)"GuiFinder: No drawing found.");
        }
        return netSystem;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    CPNDrawing getDrawingFromLoader(String name) {
        CPNDrawingLoader cPNDrawingLoader = this.loader;
        synchronized (cPNDrawingLoader) {
            Iterator<CPNDrawing> it = this.loader.loadedDrawings();
            while (it.hasNext()) {
                CPNDrawing currentDrawing = it.next();
                String currentName = currentDrawing.getName();
                if (!name.equals(currentName)) continue;
                return currentDrawing;
            }
        }
        return null;
    }

    CPNDrawing getDrawingFromFile(String path) {
        boolean error;
        URL url = null;
        File file = null;
        String fullFileName = path + ".rnw";
        logger.debug((Object)("looking for: " + fullFileName));
        try {
            file = new File(fullFileName);
            boolean bl = error = !file.canRead();
            if (!error) {
                try {
                    url = file.toURI().toURL();
                }
                catch (MalformedURLException e) {
                    logger.error((Object)("Could not transform drawing filename to URL: " + e.getMessage()));
                    error = true;
                }
            }
            if (error) {
                file = null;
            }
        }
        catch (Exception e) {
            logger.error((Object)("GuiFinder: " + fullFileName + " caused " + String.valueOf(e)));
            error = true;
        }
        if (!error) {
            assert (url != null) : "error should be set if url==null.";
            StatusRememberer statusRememberer = new StatusRememberer();
            PositionedDrawing posDrawing = file != null ? DrawingFileHelper.loadPositionedDrawing((File)file, (StatusDisplayer)statusRememberer) : DrawingFileHelper.loadPositionedDrawing((URL)url, (StatusDisplayer)statusRememberer);
            Drawing newDrawing = null;
            if (posDrawing != null) {
                newDrawing = posDrawing.getDrawing();
            }
            if (newDrawing instanceof CPNDrawing) {
                CPNDrawing cpnDrawing = (CPNDrawing)newDrawing;
                DrawApplication gui = DrawPlugin.getGui();
                if (gui != null) {
                    if (SwingUtilities.isEventDispatchThread()) {
                        gui.openDrawing(posDrawing);
                    } else {
                        EventQueue.invokeLater(() -> gui.openDrawing(posDrawing));
                    }
                }
                return cpnDrawing;
            }
        }
        return null;
    }

    CPNDrawing getDrawingFromFileClasspathRel(String path) {
        StatusRememberer statusRememberer;
        Drawing newDrawing;
        boolean error;
        String fullFileName = path + ".rnw";
        logger.debug((Object)("looking for: " + fullFileName));
        URL url = ClassSource.getClassLoader().getResource(StringUtil.convertToSlashes((String)fullFileName));
        boolean bl = error = url == null;
        if (!error && (newDrawing = DrawingFileHelper.loadDrawing((URL)url, (StatusDisplayer)(statusRememberer = new StatusRememberer()))) instanceof CPNDrawing) {
            CPNDrawing cpnDrawing = (CPNDrawing)newDrawing;
            IOHelper ioHelper = DrawPlugin.getCurrent().getIOHelper();
            if (ioHelper != null) {
                URL toOpen = url;
                if (SwingUtilities.isEventDispatchThread()) {
                    ioHelper.loadAndOpenDrawings(toOpen);
                } else {
                    EventQueue.invokeLater(() -> ioHelper.loadAndOpenDrawings(toOpen));
                }
            }
            return cpnDrawing;
        }
        return null;
    }

    private ShadowNetSystem compileDrawing(CPNDrawing drawing) {
        ShadowNetSystem netSystem = null;
        logger.debug((Object)("GuiFinder: Trying to build shadow for drawing " + String.valueOf(drawing) + "."));
        try {
            ShadowCompilerFactory compilerFactory = ModeReplacement.getInstance().getDefaultCompilerFactory();
            netSystem = new ShadowNetSystem(compilerFactory);
            drawing.buildShadow(netSystem);
            logger.debug((Object)"GuiFinder: Successful.");
            return netSystem;
        }
        catch (Exception e) {
            logger.debug((Object)("GuiFinder: Problem " + String.valueOf(e) + "."));
            return netSystem;
        }
    }

    private static class StatusRememberer
    implements StatusDisplayer {
        private StatusRememberer() {
        }

        public void showStatus(String message) {
            logger.debug((Object)("GuiFinder: " + message));
        }
    }
}

