/*
 * Decompiled with CFR 0.152.
 */
package de.renew.gui;

import CH.ifa.draw.framework.Drawing;
import CH.ifa.draw.framework.Figure;
import CH.ifa.draw.framework.FigureEnumeration;
import CH.ifa.draw.framework.FigureWithID;
import CH.ifa.draw.standard.CompositeFigure;
import de.renew.gui.CPNDrawing;
import de.renew.gui.ModeReplacement;
import de.renew.gui.SimulableFigure;
import de.renew.net.NetElementID;
import de.renew.remote.NetAccessor;
import de.renew.remote.NetInstanceAccessor;
import de.renew.remote.ObjectAccessor;
import de.renew.remote.PlaceInstanceAccessor;
import de.renew.remote.TransitionInstanceAccessor;
import java.io.Serializable;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import org.apache.log4j.Logger;

public class NetInstanceElementLookup {
    private static final Logger logger = Logger.getLogger(NetInstanceElementLookup.class);
    private final Hashtable<Integer, List<Figure>> figureLookup = new Hashtable();
    private final Hashtable<Figure, Hashtable<Serializable, ObjectAccessor>> lookup = new Hashtable();

    public NetInstanceElementLookup(NetInstanceAccessor netInstance) throws RemoteException {
        NetAccessor net = netInstance.getNet();
        String netName = net.getName();
        CPNDrawing netDrawing = ModeReplacement.getInstance().getDrawingLoader().getDrawing(netName);
        if (netDrawing == null) {
            logger.error((Object)("No open drawing found matching the compiled net \"" + netName + "\""));
        } else {
            this.addToFigureLookup(netDrawing.figures(), this.figureLookup);
            this.buildAndCheckLookup(netDrawing, netInstance);
        }
    }

    public NetInstanceElementLookup(Drawing netDrawing, NetInstanceAccessor netInstance) throws RemoteException {
        if (netDrawing == null) {
            logger.error((Object)("No drawing provided for the compiled net \"" + netInstance.getNet().getName() + "\""));
        } else {
            this.addToFigureLookup(netDrawing.figures(), this.figureLookup);
            this.buildAndCheckLookup(netDrawing, netInstance);
        }
    }

    private void buildAndCheckLookup(Drawing netDrawing, NetInstanceAccessor netInstance) throws RemoteException {
        boolean missingFigure = this.buildLookup(netInstance);
        boolean missingNetElement = this.checkForMissingNetElements();
        String netName = netDrawing.getName();
        if (missingFigure) {
            logger.warn((Object)("The compiled net contains one or more net elements with no corresponding graphical element in the drawing \"" + netName + "\"."));
            logger.warn((Object)"These net elements will not be displayed.");
        }
        if (missingNetElement) {
            logger.warn((Object)("The drawing \"" + netName + "\" contains one or more graphical elements with no corresponding net element."));
            logger.warn((Object)"These graphical elements will not be functional.");
        }
    }

    public Enumeration<Figure> getFigures() {
        return this.lookup.keys();
    }

    public Hashtable<Serializable, ObjectAccessor> getNetElements(FigureWithID figure) {
        return this.lookup.get(figure);
    }

    private void put(FigureWithID figure, PlaceInstanceAccessor placeInstance) throws RemoteException {
        Hashtable<Serializable, Object> groupIdToNetElementMap = this.getNetElements(figure);
        if (groupIdToNetElementMap == null) {
            groupIdToNetElementMap = new Hashtable();
            this.lookup.put((Figure)figure, groupIdToNetElementMap);
        }
        groupIdToNetElementMap.put(placeInstance.getPlace().getID().getGroupID(), (ObjectAccessor)placeInstance);
    }

    private void put(FigureWithID figure, TransitionInstanceAccessor transitionInstance) throws RemoteException {
        Hashtable<Serializable, Object> groupIdToNetElementMap = this.getNetElements(figure);
        if (groupIdToNetElementMap == null) {
            groupIdToNetElementMap = new Hashtable();
            this.lookup.put((Figure)figure, groupIdToNetElementMap);
        }
        groupIdToNetElementMap.put(transitionInstance.getTransition().getID().getGroupID(), (ObjectAccessor)transitionInstance);
    }

    private boolean buildLookup(NetInstanceAccessor netInstance) throws RemoteException {
        NetElementID[] transitionIDs;
        NetElementID[] placeIDs;
        boolean missingFigure = false;
        for (NetElementID placeID : placeIDs = netInstance.getNet().getPlaceIDs()) {
            List<Figure> figures = this.figureLookup.get(this.mapNetElementIdToFigureId(placeID));
            if (figures == null) {
                logger.warn((Object)("The place with figure id " + placeID.getFigureID() + " has no corresponding graphical element."));
                missingFigure = true;
                continue;
            }
            for (Figure value : figures) {
                FigureWithID figure = (FigureWithID)value;
                this.put(figure, netInstance.getPlaceInstance(placeID));
            }
        }
        for (NetElementID transitionID : transitionIDs = netInstance.getNet().getTransitionIDs()) {
            List<Figure> figures = this.figureLookup.get(this.mapNetElementIdToFigureId(transitionID));
            if (figures == null) {
                logger.warn((Object)("The transition with figure id " + transitionID.getFigureID() + " has no corresponding graphical element."));
                missingFigure = true;
                continue;
            }
            for (Figure value : figures) {
                FigureWithID figure = (FigureWithID)value;
                this.put(figure, netInstance.getTransitionInstance(transitionID));
            }
        }
        return missingFigure;
    }

    protected int mapNetElementIdToFigureId(NetElementID netElementID) {
        return netElementID.getFigureID();
    }

    private boolean checkForMissingNetElements() {
        boolean missingNetElement = false;
        Enumeration<List<Figure>> figuresEnum = this.figureLookup.elements();
        while (figuresEnum.hasMoreElements()) {
            for (Figure value : figuresEnum.nextElement()) {
                FigureWithID figure = (FigureWithID)value;
                Hashtable<Serializable, ObjectAccessor> groupIdToNetElementMap = this.getNetElements(figure);
                if (groupIdToNetElementMap != null && !groupIdToNetElementMap.isEmpty()) continue;
                logger.warn((Object)(figure.getClass().getName() + " with id " + figure.getID() + " has no corresponding net element."));
                missingNetElement = true;
            }
        }
        return missingNetElement;
    }

    protected void addToFigureLookup(FigureEnumeration figuresEnum, Hashtable<Integer, List<Figure>> figureLookup) {
        while (figuresEnum.hasMoreElements()) {
            Figure figure = (Figure)figuresEnum.nextElement();
            if (figure instanceof CompositeFigure) {
                CompositeFigure compositeFigure = (CompositeFigure)figure;
                this.addToFigureLookup(compositeFigure.figures(), figureLookup);
                continue;
            }
            if (!(figure instanceof SimulableFigure)) continue;
            SimulableFigure simulableFigure = (SimulableFigure)figure;
            int id = simulableFigure.getSemanticFigure().getID();
            figureLookup.computeIfAbsent(id, ArrayList::new).add(figure);
        }
    }
}

