/*
 * Decompiled with CFR 0.152.
 */
package de.renew.gui;

import CH.ifa.draw.util.StorableInput;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;

public class PatchingStorableInput
extends StorableInput {
    private final boolean stringReadPatching = true;
    private static final Hashtable<String, String> patchPrefixes = new Hashtable();
    private static final Hashtable<String, String> patchMap;

    PatchingStorableInput(InputStream stream, boolean useUTF) {
        super(stream, useUTF);
    }

    PatchingStorableInput(File file, boolean useUTF) throws FileNotFoundException {
        super(file, useUTF);
    }

    public PatchingStorableInput(String stringStream) {
        super(stringStream);
    }

    public PatchingStorableInput(URL location, boolean useUTF) throws IOException {
        super(location, useUTF);
    }

    protected Object makeInstance(String className) throws IOException {
        return super.makeInstance(this.patchString(className));
    }

    public String readString() throws IOException {
        String s = super.readString();
        s = this.patchString(s);
        return s;
    }

    protected String patchString(String s) {
        boolean patched = false;
        Enumeration<String> e = patchPrefixes.keys();
        while (e.hasMoreElements() && !patched) {
            String patchPrefix = e.nextElement();
            if (!((String)s).startsWith(patchPrefix)) continue;
            s = patchPrefixes.get(patchPrefix) + ((String)s).substring(patchPrefix.length());
            patched = true;
        }
        String patch = patchMap.get(s);
        if (patch != null) {
            s = patch;
        }
        return s;
    }

    static {
        patchPrefixes.put("CH.ifa.draw.cpn.", "de.renew.gui.");
        patchMap = new Hashtable();
        ReplaceHelper toGui = new ReplaceHelper("de.renew.gui");
        toGui.registerAll("de.renew.gui.fs.AssocArrowTip", "de.renew.gui.fs.IsaArrowTip", "de.renew.diagram.AssocArrowTip", "de.renew.fa.figures.AssocArrowTip");
    }

    private record ReplaceHelper(String newPackage) {
        public void registerAll(String ... classNames) {
            for (String className : classNames) {
                patchMap.put(className, this.convert(className));
            }
        }

        public void registerAllInPackage(String packageName, String ... classNames) {
            if (packageName.endsWith(".")) {
                packageName = packageName.substring(0, packageName.length() - 1);
            }
            for (String className : classNames) {
                String fullClassName = packageName + "." + className;
                patchMap.put(fullClassName, this.convert(fullClassName));
            }
        }

        public String convert(String fullClassName) {
            if (this.newPackage == null || this.newPackage.isEmpty()) {
                throw new NullPointerException("newPackage is null or empty");
            }
            String className = fullClassName.substring(fullClassName.lastIndexOf(46) + 1);
            return this.newPackage + "." + className;
        }
    }
}

