/*
 * Decompiled with CFR 0.152.
 */
package de.renew.gui;

import CH.ifa.draw.framework.Drawing;
import CH.ifa.draw.framework.DrawingChangeEvent;
import CH.ifa.draw.framework.DrawingView;
import CH.ifa.draw.framework.Figure;
import CH.ifa.draw.framework.FigureChangeEvent;
import CH.ifa.draw.framework.FigureChangeListener;
import CH.ifa.draw.framework.FigureEnumeration;
import CH.ifa.draw.framework.Handle;
import CH.ifa.draw.standard.AbstractFigure;
import CH.ifa.draw.standard.NullHandle;
import CH.ifa.draw.standard.RelativeLocator;
import CH.ifa.draw.util.AWTSynchronizedUpdate;
import de.renew.gui.CPNDrawingEditor;
import de.renew.gui.CPNInstanceDrawing;
import de.renew.gui.InstanceDrawing;
import de.renew.gui.InstanceFigure;
import de.renew.gui.PlaceFigure;
import de.renew.gui.TokenBagDrawing;
import de.renew.gui.TokenBagFigure;
import de.renew.remote.EventListener;
import de.renew.remote.ObjectAccessor;
import de.renew.remote.PlaceInstanceAccessor;
import de.renew.remote.RemoteEventForwarder;
import de.renew.remote.RemoteEventListener;
import de.renew.remote.TokenCountsAccessor;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.IOException;
import java.io.NotSerializableException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.rmi.RemoteException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.apache.log4j.Logger;

public class PlaceInstanceFigure
extends AbstractFigure
implements InstanceFigure,
EventListener,
FigureChangeListener {
    private static final Logger logger = Logger.getLogger(PlaceInstanceFigure.class);
    protected final PlaceFigure placeFigure;
    protected PlaceInstanceAccessor placeInstance;
    protected RemoteEventForwarder forwarder;
    private boolean isMarked;
    protected int markingAppearance;
    protected InstanceDrawing drawing;
    private final AWTSynchronizedUpdate updateTask;

    public PlaceInstanceFigure(InstanceDrawing drawing, PlaceFigure pf, Hashtable<Serializable, ObjectAccessor> netElements) {
        this.drawing = drawing;
        this.placeFigure = pf;
        this.updateTask = new AWTSynchronizedUpdate((Runnable)new PlaceHighlightUpdateTask(this));
        this.initialize(netElements);
    }

    protected void initialize(Hashtable<Serializable, ObjectAccessor> netElements) {
        if (netElements.size() != 1) {
            logger.error((Object)("Error: There is not exactly one place instance for the figure " + String.valueOf(this)));
            return;
        }
        Enumeration<ObjectAccessor> elems = netElements.elements();
        elems.hasMoreElements();
        this.placeInstance = (PlaceInstanceAccessor)elems.nextElement();
        this.placeFigure.addFigureChangeListener(this);
        this.markingAppearance = this.placeFigure.getMarkingAppearance();
        this.update();
        if (this.markingAppearance != 0) {
            this.addTokenBagFigure();
        }
        try {
            this.forwarder = new RemoteEventForwarder((EventListener)this);
            this.placeInstance.addRemoteEventListener((RemoteEventListener)this.forwarder);
        }
        catch (RemoteException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    protected PlaceInstanceAccessor getInstance() {
        return this.placeInstance;
    }

    @Override
    public boolean isHighlighted() {
        return this.isMarked;
    }

    InstanceDrawing drawing() {
        return this.drawing;
    }

    public void update() {
        this.updateTask.scheduleUpdate();
    }

    protected void setHighlighted(boolean newIsMarked) {
        if (newIsMarked != this.isMarked) {
            this.isMarked = newIsMarked;
            this.invalidate();
            Figure hilight = this.placeFigure.getHighlightFigure();
            if (hilight != null) {
                Rectangle area = hilight.displayBox();
                area.grow(5, 5);
                DrawingChangeEvent dce = new DrawingChangeEvent((Drawing)this.drawing, area);
                this.drawing.drawingInvalidated(dce);
            }
            if (this.listener() != null) {
                this.listener().figureRequestUpdate(new FigureChangeEvent((Figure)this));
            }
        }
    }

    public void basicDisplayBox(Point origin, Point corner) {
    }

    public Vector<Handle> handles() {
        Vector<Handle> handles = new Vector<Handle>();
        handles.addElement((Handle)new NullHandle((Figure)this, RelativeLocator.northWest()));
        handles.addElement((Handle)new NullHandle((Figure)this, RelativeLocator.northEast()));
        handles.addElement((Handle)new NullHandle((Figure)this, RelativeLocator.southWest()));
        handles.addElement((Handle)new NullHandle((Figure)this, RelativeLocator.southEast()));
        return handles;
    }

    public Rectangle displayBox() {
        return this.placeFigure.displayBox();
    }

    protected void basicMoveBy(int x, int y) {
    }

    public void draw(Graphics g) {
    }

    protected TokenBagFigure addTokenBagFigure() {
        TokenBagFigure tbf = new TokenBagFigure(this.drawing(), this, this.placeInstance, this.markingAppearance);
        this.drawing.add((Figure)tbf);
        return tbf;
    }

    public boolean inspect(DrawingView view, boolean alternate) {
        if (alternate) {
            try {
                TokenBagDrawing tokenDraw = TokenBagDrawing.getTokenBagDrawing(this.placeInstance);
                InstanceDrawing instDraw = CPNInstanceDrawing.getInstanceDrawing(this.placeInstance.getNetInstance());
                ((CPNDrawingEditor)view.editor()).openTokenBagDrawing(tokenDraw, instDraw);
                return true;
            }
            catch (RemoteException e) {
                return false;
            }
        }
        if (this.getTokenBagFigure() == null) {
            view.clearSelection();
            view.addToSelection((Figure)this.addTokenBagFigure());
            return true;
        }
        return super.inspect(view, alternate);
    }

    public void setAttribute(String attribute, Object value) {
        if ("MarkingAppearance".equals(attribute)) {
            this.markingAppearance = (Integer)value;
            TokenBagFigure etbf = this.getTokenBagFigure();
            if (this.markingAppearance == 0) {
                if (etbf != null) {
                    this.drawing.remove((Figure)etbf);
                }
            } else if (etbf == null) {
                this.addTokenBagFigure();
            } else {
                etbf.setMarkingAppearance(this.markingAppearance);
            }
        } else {
            super.setAttribute(attribute, value);
        }
    }

    public void release() {
        InstanceDrawing theDrawing = this.drawing;
        if (theDrawing == null) {
            return;
        }
        if (this.drawing == null) {
            return;
        }
        if (this.placeInstance != null) {
            try {
                this.placeInstance.removeRemoteEventListener((RemoteEventListener)this.forwarder);
            }
            catch (RemoteException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
            this.placeInstance = null;
            this.drawing = null;
        }
        this.placeFigure.removeFigureChangeListener(this);
        super.release();
    }

    public TokenBagFigure getTokenBagFigure() {
        FigureEnumeration childenumeration = this.children();
        if (childenumeration.hasMoreElements()) {
            return (TokenBagFigure)((Object)childenumeration.nextElement());
        }
        return null;
    }

    public void figureInvalidated(FigureChangeEvent e) {
    }

    public void figureChanged(FigureChangeEvent e) {
        this.changed();
    }

    public void figureHandlesChanged(FigureChangeEvent e) {
    }

    public void figureRemoved(FigureChangeEvent e) {
    }

    public void figureRequestRemove(FigureChangeEvent e) {
    }

    public void figureRequestUpdate(FigureChangeEvent e) {
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        throw new NotSerializableException("PlaceInstanceFigure is not serializable!");
    }

    private static class PlaceHighlightUpdateTask
    implements Runnable {
        private final PlaceInstanceFigure figure;

        public PlaceHighlightUpdateTask(PlaceInstanceFigure figure) {
            this.figure = figure;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            InstanceDrawing theDrawing = this.figure.drawing();
            PlaceInstanceAccessor thePlaceInstance = this.figure.getInstance();
            if (theDrawing == null || thePlaceInstance == null) {
                return;
            }
            try {
                boolean newIsMarked;
                theDrawing.lock();
                if (this.figure.drawing() == null || this.figure.getInstance() == null) {
                    return;
                }
                try {
                    TokenCountsAccessor tokenCountsAccessor = thePlaceInstance.getTokenCounts();
                    newIsMarked = !tokenCountsAccessor.isEmpty();
                }
                catch (RemoteException e) {
                    logger.error((Object)e.getMessage(), (Throwable)e);
                    newIsMarked = false;
                }
                this.figure.setHighlighted(newIsMarked);
            }
            finally {
                theDrawing.unlock();
            }
        }
    }
}

