/*
 * Decompiled with CFR 0.152.
 */
package de.renew.gui.pnml.creator;

import CH.ifa.draw.figures.TextFigure;
import CH.ifa.draw.framework.ParentFigure;
import de.renew.gui.DeclarationFigure;
import de.renew.gui.pnml.converter.Converter;
import de.renew.gui.pnml.creator.ElementCreator;
import de.renew.gui.pnml.creator.GraphicCreator;
import de.renew.gui.pnml.creator.PNMLCreator;
import java.awt.Point;
import org.w3c.dom.Element;

public class AnnotationCreator
extends ElementCreator {
    private final boolean parentVirtual;

    public AnnotationCreator(String tagName, Converter converter) {
        this(tagName, false, converter);
    }

    public AnnotationCreator(String tagName, boolean parentVirtual, Converter converter) {
        super(tagName, converter);
        this.parentVirtual = parentVirtual;
    }

    protected TextFigure getTextFigure() {
        return (TextFigure)this.getObject();
    }

    @Override
    protected Element doCreateElement(PNMLCreator pnmlCreator) {
        Element element = super.doCreateElement(pnmlCreator);
        Element textEle = pnmlCreator.createTextElement(this.getTextFigure().getText());
        element.appendChild(this.createGraphic(pnmlCreator));
        element.appendChild(textEle);
        if (this.parentVirtual) {
            Element toolSpec = pnmlCreator.createToolspecific();
            Element vir = pnmlCreator.createElement("virtual");
            toolSpec.appendChild(vir);
            element.appendChild(toolSpec);
        }
        return element;
    }

    protected Element createGraphic(PNMLCreator pnmlCreator) {
        GraphicCreator graphicCreator = new GraphicCreator(pnmlCreator);
        Point center = this.getTextFigure().center();
        ParentFigure parent = this.getTextFigure().parent();
        if (parent == null) {
            if (!(this.getTextFigure() instanceof DeclarationFigure)) {
                graphicCreator.addOffset(center.x, center.y);
            } else {
                Point origin = this.getTextFigure().getOrigin();
                graphicCreator.addOffset(origin.x, origin.y);
            }
        } else {
            Point centerParent = parent.center();
            graphicCreator.addOffset(center.x - centerParent.x, center.y - centerParent.y);
        }
        return graphicCreator.getElement();
    }
}

