/*
 * Decompiled with CFR 0.152.
 */
package de.renew.gui.pnml.creator;

import de.renew.gui.pnml.converter.GraphicConverter;
import de.renew.gui.pnml.creator.PNMLCreator;
import java.awt.Color;
import org.w3c.dom.Element;

public class GraphicCreator {
    private final PNMLCreator _pnmlCreator;
    private final Element _element;
    private Element line;

    public GraphicCreator(PNMLCreator pnmlCreator) {
        this._element = pnmlCreator.createElement("graphics");
        this._pnmlCreator = pnmlCreator;
    }

    protected Element getElement() {
        return this._element;
    }

    public void addPosition(int x, int y) {
        Element position = this._pnmlCreator.createElement("position");
        position.setAttribute("x", String.valueOf(x));
        position.setAttribute("y", String.valueOf(y));
        this._element.appendChild(position);
    }

    public void addOffset(int x, int y) {
        Element offset = this._pnmlCreator.createElement("offset");
        offset.setAttribute("x", String.valueOf(x));
        offset.setAttribute("y", String.valueOf(y));
        this._element.appendChild(offset);
    }

    public void addDimension(int x, int y) {
        Element dimension = this._pnmlCreator.createElement("dimension");
        dimension.setAttribute("x", String.valueOf(x));
        dimension.setAttribute("y", String.valueOf(y));
        this._element.appendChild(dimension);
    }

    public void addFill(Color c) {
        Element fill = this._pnmlCreator.createElement("fill");
        fill.setAttribute("color", "rgb(" + c.getRed() + "," + c.getGreen() + "," + c.getBlue() + ")");
        this._element.appendChild(fill);
    }

    public void addLineColor(Color c) {
        this.getLineElement().setAttribute("color", "rgb(" + c.getRed() + "," + c.getGreen() + "," + c.getBlue() + ")");
    }

    public void addLineStyle(String style) {
        this.getLineElement().setAttribute("style", GraphicConverter.instance().parseRenewLineStyle(style));
    }

    public void addLine() {
        this._element.appendChild(this.getLineElement());
    }

    private Element getLineElement() {
        if (this.line == null) {
            this.line = this._pnmlCreator.createElement("line");
        }
        return this.line;
    }
}

