/*
 * Decompiled with CFR 0.152.
 */
package de.renew.netcomponents;

import CH.ifa.draw.figures.TextFigure;
import CH.ifa.draw.framework.ConnectionFigure;
import CH.ifa.draw.framework.Drawing;
import CH.ifa.draw.framework.DrawingView;
import CH.ifa.draw.framework.Figure;
import CH.ifa.draw.framework.FigureEnumeration;
import CH.ifa.draw.framework.UndoableCommand;
import CH.ifa.draw.standard.ReverseFigureEnumerator;
import CH.ifa.draw.util.ColorMap;
import de.renew.gui.GuiPlugin;
import de.renew.gui.PlaceFigure;
import de.renew.gui.TransitionFigure;
import de.renew.netcomponents.NetComponentFigure;
import java.util.HashSet;
import java.util.Vector;

public class GroupCommand
extends UndoableCommand {
    public GroupCommand() {
        super("group selection");
    }

    public boolean executeUndoable() {
        DrawingView view = GuiPlugin.getCurrent().getDrawingEditor().view();
        Vector selected = view.selectionZOrdered();
        HashSet<Figure> selection = new HashSet<Figure>();
        Drawing drawing = view.drawing();
        if (selected.size() > 0) {
            view.clearSelection();
            for (Figure figure : selected) {
                if (figure instanceof NetComponentFigure) continue;
                selection.add(figure);
            }
            HashSet<Figure> ncFiguresInvolvedInSelection = this.getInvolvedNCFigures(drawing, selected);
            for (NetComponentFigure netComponentFigure : ncFiguresInvolvedInSelection) {
                selection.addAll(netComponentFigure.getAttached());
                drawing.remove((Figure)netComponentFigure);
            }
            drawing.orphanAll(selected);
            drawing.orphanAll(new Vector(selection));
            Vector<Figure> vector = new Vector<Figure>();
            Vector<Figure> second = new Vector<Figure>();
            Vector<Figure> third = new Vector<Figure>();
            for (Figure figure : selection) {
                if (figure instanceof TextFigure || figure instanceof ConnectionFigure) {
                    third.add(figure);
                    continue;
                }
                if (figure instanceof TransitionFigure || figure instanceof PlaceFigure) {
                    second.add(figure);
                    continue;
                }
                vector.add(figure);
            }
            NetComponentFigure group = new NetComponentFigure();
            group.setFillColor(ColorMap.NONE);
            group.setFrameColor(ColorMap.NONE);
            group.setAttribute("LineStyle", "1 2");
            group.group(selection);
            Vector<Object> v = new Vector<Object>();
            v.addAll(vector);
            v.add((Object)group);
            v.addAll(second);
            v.addAll(third);
            drawing.addAll(v);
            ReverseFigureEnumerator k = new ReverseFigureEnumerator(v);
            while (k.hasMoreElements()) {
                view.drawing().sendToBack(k.nextFigure());
            }
            view.checkDamage();
            view.checkDamage();
            GuiPlugin.getCurrent().showStatus("Figures attached fo NetComponentFigure");
            return true;
        }
        return false;
    }

    private HashSet<Figure> getInvolvedNCFigures(Drawing drawing, Vector<Figure> selected) {
        HashSet<Figure> ncfs = new HashSet<Figure>();
        FigureEnumeration it = drawing.figures();
        while (it.hasMoreElements()) {
            Figure figure = it.nextFigure();
            if (!(figure instanceof NetComponentFigure)) continue;
            ncfs.add(figure);
        }
        HashSet<Figure> involvedNCFigures = new HashSet<Figure>();
        for (Figure figure : ncfs) {
            if (selected.contains(figure)) {
                involvedNCFigures.add(figure);
            }
            NetComponentFigure ncFigure = (NetComponentFigure)figure;
            for (Figure attachedFigure : ncFigure.getAttached()) {
                if (!selected.contains(attachedFigure)) continue;
                involvedNCFigures.add((Figure)ncFigure);
            }
        }
        return involvedNCFigures;
    }

    public boolean isExecutable() {
        if (!super.isExecutable()) {
            return false;
        }
        return GuiPlugin.getCurrent().getDrawingEditor().view().selectionCount() > 0;
    }
}

