/*
 * Decompiled with CFR 0.152.
 */
package de.renew.util;

import de.renew.util.DelayedField;
import de.renew.util.DelayedFieldOwner;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.StreamCorruptedException;
import java.util.EmptyStackException;
import java.util.Enumeration;
import java.util.Stack;
import java.util.Vector;
import org.apache.log4j.Logger;

public class RenewObjectOutputStream
extends ObjectOutputStream {
    public static Logger logger = Logger.getLogger(RenewObjectOutputStream.class);
    protected static final String SECTIONLABEL = "Delayed:";
    private Vector<DelayedField> delayedObjects;
    private Stack<Object> objectTrace = new Stack();

    public RenewObjectOutputStream(OutputStream out) throws IOException {
        super(out);
        this.delayedObjects = new Vector();
    }

    public void delayedWriteObject(Object obj, DelayedFieldOwner owner) {
        this.delayedObjects.addElement(new DelayedField(obj, owner));
    }

    public void writeDelayedObjects() throws IOException {
        this.beginDomain(SECTIONLABEL);
        super.writeObject(SECTIONLABEL);
        while (!this.delayedObjects.isEmpty()) {
            int objectCount = this.delayedObjects.size();
            Enumeration<DelayedField> objects = this.delayedObjects.elements();
            this.delayedObjects = new Vector();
            super.writeInt(objectCount);
            while (objects.hasMoreElements()) {
                DelayedField obj = objects.nextElement();
                super.writeObject(obj);
            }
        }
        super.writeInt(0);
        this.endDomain(SECTIONLABEL);
    }

    @Override
    public void close() throws IOException {
        try {
            this.writeDelayedObjects();
        }
        catch (IOException e) {
            throw new StreamCorruptedException("Exception occured while writing delayed objects on close: " + String.valueOf(e));
        }
        finally {
            super.close();
        }
    }

    public void beginDomain(Object owner) {
        this.objectTrace.push(owner);
    }

    public void endDomain(Object owner) {
        try {
            if (this.objectTrace.peek() == owner) {
                this.objectTrace.pop();
            } else {
                logger.error((Object)("End domain by wrong owner requested by " + String.valueOf(owner)));
                logger.error((Object)("Top of stack is " + String.valueOf(this.objectTrace.peek())));
                logger.error((Object)("Owner resides " + this.objectTrace.search(owner) + " from top of stack"));
            }
        }
        catch (EmptyStackException e) {
            logger.error((Object)("End domain on empty stack requested by " + String.valueOf(owner)));
        }
    }

    public Stack<Object> getDomainTrace() {
        return (Stack)this.objectTrace.clone();
    }
}

