/*
 * Decompiled with CFR 0.152.
 */
package de.renew.fa.figures;

import CH.ifa.draw.framework.Drawing;
import CH.ifa.draw.framework.Figure;
import CH.ifa.draw.framework.FigureChangeEvent;
import CH.ifa.draw.framework.FigureChangeListener;
import CH.ifa.draw.framework.FigureEnumeration;
import CH.ifa.draw.framework.Handle;
import CH.ifa.draw.standard.AbstractFigure;
import CH.ifa.draw.standard.NullHandle;
import CH.ifa.draw.standard.RelativeLocator;
import CH.ifa.draw.util.AWTSynchronizedUpdate;
import de.renew.fa.FADrawing;
import de.renew.fa.figures.FAStateFigure;
import de.renew.fa.figures.FAWordTextFigure;
import de.renew.faformalism.util.FAAutomatonModelEnum;
import de.renew.faformalism.util.FAAutomatonSimulationHelper;
import de.renew.faformalism.util.SimulationSettingsManager;
import de.renew.gui.CPNDrawing;
import de.renew.gui.InstanceDrawing;
import de.renew.gui.InstanceFigure;
import de.renew.gui.TokenBagFigure;
import de.renew.remote.EventListener;
import de.renew.remote.ObjectAccessor;
import de.renew.remote.PlaceInstanceAccessor;
import de.renew.remote.RemoteEventForwarder;
import de.renew.remote.RemoteEventListener;
import de.renew.remote.TokenCountsAccessor;
import java.awt.Color;
import java.awt.EventQueue;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.Serializable;
import java.rmi.RemoteException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import org.apache.log4j.Logger;

public class FAStateInstanceFigure
extends AbstractFigure
implements InstanceFigure,
EventListener,
FigureChangeListener {
    private static final Logger LOGGER = Logger.getLogger(FAStateInstanceFigure.class);
    private boolean _isActive;
    protected FAStateFigure _faStateFigure;
    protected PlaceInstanceAccessor _placeInstance;
    protected int _markingAppearance;
    protected InstanceDrawing _drawing;
    private AWTSynchronizedUpdate _updateTask;
    protected RemoteEventForwarder _forwarder;

    public FAStateInstanceFigure(InstanceDrawing drawing, FAStateFigure faf, Hashtable<Serializable, ObjectAccessor> netElements) {
        CPNDrawing cPNDrawing;
        this._faStateFigure = faf;
        this._drawing = drawing;
        this.initialize(netElements);
        FAWordTextFigure word = null;
        if (SimulationSettingsManager.getAutomatonModel() != FAAutomatonModelEnum.NET) {
            word = new FAWordTextFigure();
            word.setReadOnly(true);
            word.setVisible(false);
            drawing.add((Figure)word);
            word.moveBy(this.center().x - word.displayBox().width / 2 - word.displayBox().x, this.displayBox().y - word.displayBox().height - word.displayBox().y);
        }
        if (SimulationSettingsManager.getAutomatonModel() == FAAutomatonModelEnum.PDA && (cPNDrawing = drawing.getCpnDrawing()) instanceof FADrawing) {
            FADrawing faDrawing = (FADrawing)cPNDrawing;
            if (faDrawing.getDataStructureText() == null) {
                faDrawing.initializeDataStructureText();
                drawing.add((Figure)faDrawing.getDataStructureText());
            }
            FAWordTextFigure stackText = faDrawing.getDataStructureText();
            this._updateTask = new AWTSynchronizedUpdate((Runnable)new StateHighlightUpdateTask(this, word, stackText));
        } else {
            this._updateTask = new AWTSynchronizedUpdate((Runnable)new StateHighlightUpdateTask(this, word, null));
        }
    }

    protected void initialize(Hashtable<Serializable, ObjectAccessor> netElements) {
        Enumeration<ObjectAccessor> elems = netElements.elements();
        this._placeInstance = (PlaceInstanceAccessor)elems.nextElement();
        this._faStateFigure.addFigureChangeListener(this);
        this._markingAppearance = this._faStateFigure.getMarkingAppearance();
        EventQueue.invokeLater(this::update);
        if (this._markingAppearance != 0) {
            this.addTokenBagFigure();
        }
        try {
            this._forwarder = new RemoteEventForwarder((EventListener)this);
            this._placeInstance.addRemoteEventListener((RemoteEventListener)this._forwarder);
        }
        catch (RemoteException e) {
            LOGGER.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    public void update() {
        if (this._updateTask != null) {
            this._updateTask.scheduleUpdate();
        }
    }

    InstanceDrawing drawing() {
        return this._drawing;
    }

    public String toString() {
        return "FAStateInstanceFigure(" + this._faStateFigure.getID() + ")";
    }

    protected void setHighlighted(boolean newIsActive) {
        if (newIsActive != this._isActive) {
            this._isActive = newIsActive;
            this.invalidate();
            if (this.listener() != null) {
                this.listener().figureRequestUpdate(new FigureChangeEvent((Figure)this));
            }
        }
    }

    protected TokenBagFigure addTokenBagFigure() {
        TokenBagFigure tbf = new TokenBagFigure((Drawing)this.drawing(), (AbstractFigure)this, this._placeInstance, this._markingAppearance);
        this._drawing.add((Figure)tbf);
        return tbf;
    }

    public void setAttribute(String attribute, Object value) {
        LOGGER.debug((Object)("setAttribute(String, Object) called with " + attribute + " and " + String.valueOf(value)));
        if ("MarkingAppearance".equals(attribute)) {
            this._markingAppearance = (Integer)value;
            TokenBagFigure etbf = this.getTokenBagFigure();
            if (this._markingAppearance == 0) {
                if (etbf != null) {
                    this._drawing.remove((Figure)etbf);
                }
            } else if (etbf == null) {
                this.addTokenBagFigure();
            } else {
                etbf.setMarkingAppearance(this._markingAppearance);
            }
        } else {
            super.setAttribute(attribute, value);
        }
    }

    private TokenBagFigure getTokenBagFigure() {
        LOGGER.debug((Object)"getTokenBagFigure called");
        FigureEnumeration childenumeration = this.children();
        if (childenumeration.hasMoreElements()) {
            return (TokenBagFigure)childenumeration.nextElement();
        }
        return null;
    }

    public void draw(Graphics g) {
        if (SimulationSettingsManager.getAutomatonModel() != FAAutomatonModelEnum.NET && this._faStateFigure.isEndState()) {
            try {
                if (!this._placeInstance.getTokenCounts().isEmpty()) {
                    String[] tokens = this._placeInstance.getMarking().getAllTokenStrings();
                    if (tokens.length == 0) {
                        return;
                    }
                    if (tokens[0] != null) {
                        String word = tokens[0].substring(1).split(",")[0];
                        List t = FAAutomatonSimulationHelper.prepareTokenForConsumption((String)(word = word.replaceAll(" +", "")));
                        if (t.contains("")) {
                            Color fill = this._faStateFigure.getFillColor();
                            this._faStateFigure.setFillColor(new Color(100, 200, 100));
                            this._faStateFigure.internalDraw(g);
                            this._faStateFigure.setFillColor(fill);
                        }
                    }
                }
            }
            catch (RemoteException e) {
                throw new RuntimeException(e);
            }
        }
    }

    protected void basicMoveBy(int dx, int dy) {
    }

    public void basicDisplayBox(Point origin, Point corner) {
    }

    public boolean isHighlighted() {
        return this._isActive;
    }

    public Rectangle displayBox() {
        return this._faStateFigure.displayBox();
    }

    public Vector<Handle> handles() {
        Vector<Handle> handles = new Vector<Handle>();
        handles.addElement((Handle)new NullHandle((Figure)this, RelativeLocator.northWest()));
        handles.addElement((Handle)new NullHandle((Figure)this, RelativeLocator.northEast()));
        handles.addElement((Handle)new NullHandle((Figure)this, RelativeLocator.southWest()));
        handles.addElement((Handle)new NullHandle((Figure)this, RelativeLocator.southEast()));
        return handles;
    }

    public void figureInvalidated(FigureChangeEvent e) {
    }

    public void figureChanged(FigureChangeEvent e) {
        this.changed();
    }

    public void figureRemoved(FigureChangeEvent e) {
    }

    public void figureRequestRemove(FigureChangeEvent e) {
    }

    public void figureRequestUpdate(FigureChangeEvent e) {
    }

    public void figureHandlesChanged(FigureChangeEvent e) {
    }

    private static class StateHighlightUpdateTask
    implements Runnable {
        private FAStateInstanceFigure _figure;
        private FAWordTextFigure _word;
        private FAWordTextFigure _dataStructureText;

        public StateHighlightUpdateTask(FAStateInstanceFigure figure, FAWordTextFigure word, FAWordTextFigure dataStructureText) {
            this._figure = figure;
            this._word = word;
            this._dataStructureText = dataStructureText;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            InstanceDrawing theDrawing = this._figure.drawing();
            PlaceInstanceAccessor thePlaceInstance = this._figure._placeInstance;
            if (theDrawing == null || thePlaceInstance == null) {
                return;
            }
            try {
                boolean newIsActive;
                theDrawing.lock();
                if (this._figure.drawing() == null || this._figure._placeInstance == null) {
                    return;
                }
                try {
                    TokenCountsAccessor tokenCountsAccessor = thePlaceInstance.getTokenCounts();
                    newIsActive = !tokenCountsAccessor.isEmpty();
                    LOGGER.debug((Object)("PlaceInstance (" + String.valueOf(thePlaceInstance.getID()) + ") is now " + (newIsActive ? "active" : "inactive")));
                    if (this._word != null) {
                        String[] tokens = thePlaceInstance.getMarking().getAllTokenStrings();
                        if (tokens != null && tokens.length != 0) {
                            String newWord;
                            if (this._dataStructureText != null) {
                                this._dataStructureText.setText("Stack:" + tokens[0].substring(tokens[0].lastIndexOf(91), tokens[0].length() - 1));
                            }
                            if ((newWord = tokens[0].substring(1, tokens[0].indexOf(44))).isBlank()) {
                                newWord = "\u03b5";
                            }
                            this._word.setText(newWord);
                        } else {
                            this._word.setText(" ");
                        }
                        this._word.setVisible(newIsActive);
                        theDrawing.figureChanged(new FigureChangeEvent((Figure)this._word));
                    }
                }
                catch (RemoteException e) {
                    LOGGER.error((Object)e.getMessage(), (Throwable)e);
                    newIsActive = false;
                }
                this._figure.setHighlighted(newIsActive);
            }
            finally {
                theDrawing.unlock();
            }
        }
    }
}

