/*
 * Decompiled with CFR 0.152.
 */
package de.renew.fa.model;

import de.renew.fa.FADrawing;
import de.renew.fa.model.Arc;
import de.renew.fa.model.ArcImpl;
import de.renew.fa.model.FA;
import de.renew.fa.model.Letter;
import de.renew.fa.model.LetterImpl;
import de.renew.fa.model.State;
import de.renew.fa.model.StateImpl;
import de.renew.fa.model.Word;
import de.renew.fa.model.WordImpl;
import de.renew.fa.util.FAHelper;
import de.renew.fa.util.LetterNameComparator;
import de.renew.fa.util.StateNameComparator;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;

public class FAImpl
implements FA {
    private HashMap<String, Letter> _alphabet = new HashMap();
    private HashMap<String, Arc> _arcs = new HashMap();
    private String _name = "";
    private HashMap<String, State> _states = new HashMap();

    public FAImpl() {
    }

    public FAImpl(FADrawing drawing) {
    }

    @Override
    public Vector<State> endStates() {
        Iterator<State> it = this.getStates();
        Vector<State> endStates = new Vector<State>();
        while (it.hasNext()) {
            State state = it.next();
            if (!state.isEndState()) continue;
            endStates.add(state);
        }
        return endStates;
    }

    @Override
    public Iterator<Letter> getAlphabet() {
        Vector<Letter> values = new Vector<Letter>(this._alphabet.values());
        Collections.sort(values, new LetterNameComparator());
        return values.iterator();
    }

    @Override
    public Iterator<Arc> getArcs() {
        return this._arcs.values().iterator();
    }

    @Override
    public String getName() {
        return this._name;
    }

    @Override
    public State getStateByName(String name) {
        return this._states.get(name);
    }

    @Override
    public Iterator<State> getStates() {
        Vector<State> stateList = new Vector<State>(this._states.values());
        Collections.sort(stateList, new StateNameComparator());
        return stateList.iterator();
    }

    @Override
    public State[] getStatesAsArray() {
        return this._states.values().toArray(new State[this._states.size()]);
    }

    @Override
    public boolean hasArc(String state, String state2) {
        Iterator<Arc> it = this.getArcs();
        while (it.hasNext()) {
            Arc arc = it.next();
            if (!arc.getFrom().getName().equals(state) || !arc.getTo().getName().equals(state2)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isLiteral(Word word) {
        return this._alphabet.containsKey(word.getName());
    }

    @Override
    public Arc newArc(State from, Word inscription, State to) {
        if (from == null || inscription == null || to == null) {
            return null;
        }
        ArcImpl newArc = new ArcImpl(from, inscription, to);
        this._arcs.put(newArc.getName(), newArc);
        return newArc;
    }

    @Override
    public Letter newLetter(String letterName) {
        LetterImpl letter = new LetterImpl(letterName);
        if (!this._alphabet.containsKey(letterName)) {
            this._alphabet.put(letterName, letter);
            return letter;
        }
        return null;
    }

    @Override
    public State newState(String name) {
        if (this._states.containsKey(name)) {
            return null;
        }
        StateImpl state = new StateImpl(name);
        this._states.put(name, state);
        return state;
    }

    @Override
    public Word newWord(String name) {
        return new WordImpl(name);
    }

    public void setAlphabet(Iterator<Letter> sigma) {
        while (sigma.hasNext()) {
            Letter letter = sigma.next();
            this.newLetter(letter.getName());
        }
    }

    @Override
    public boolean setAsEndState(String name) {
        if (this._states.containsKey(name)) {
            this.getStateByName(name).setEndState(true);
            return true;
        }
        return false;
    }

    @Override
    public boolean setAsStartState(String name) {
        if (this._states.containsKey(name)) {
            this.getStateByName(name).setStartState(true);
            return true;
        }
        return false;
    }

    @Override
    public void setName(String name) {
        this._name = name;
    }

    public void setStates(Iterator<State> states) {
        while (states.hasNext()) {
            State state = states.next();
            this.newState(state.getName());
        }
    }

    @Override
    public Vector<State> startStates() {
        Iterator<State> it = this.getStates();
        Vector<State> startStates = new Vector<State>();
        while (it.hasNext()) {
            State state = it.next();
            if (!state.isStartState()) continue;
            startStates.add(state);
        }
        return startStates;
    }

    public String toString() {
        return FAHelper.toProperties(this).toString();
    }

    @Override
    public int numberOfStates() {
        return this._states.values().size();
    }

    @Override
    public int numberOfArcs() {
        return this._arcs.size();
    }

    @Override
    public int numberOfLetters() {
        return this._alphabet.size();
    }
}

