/*
 * Decompiled with CFR 0.152.
 */
package de.renew.call;

import de.renew.call.ParseException;
import de.renew.call.StubParser;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.StringTokenizer;

public class StubCompiler {
    private static final String AUTO_COMMENT = "// This file was automatically generated. Do not modify.";
    private File _toDir;

    public StubCompiler() {
        this(null);
    }

    public StubCompiler(File toDir) {
        this._toDir = toDir;
    }

    public File compileStub(File source) throws ParseException, IOException {
        FileReader sourceReader = null;
        sourceReader = new FileReader(source);
        StubParser parser = new StubParser(sourceReader);
        parser.StubFile();
        File target = this.getTarget(source, parser.getPackage());
        if (!this.canWrite(target)) {
            throw new ParseException("not allowed to edit file");
        }
        BufferedWriter w = new BufferedWriter(new FileWriter(target));
        w.write("// This file was automatically generated. Do not modify.\n");
        w.write(parser.getOutput());
        ((Writer)w).close();
        return target;
    }

    private boolean canWrite(File targetFile) throws IOException {
        if (!targetFile.isFile()) {
            return true;
        }
        BufferedReader targetReader = new BufferedReader(new FileReader(targetFile));
        String firstLine = targetReader.readLine();
        targetReader.close();
        return firstLine == null || firstLine.startsWith(AUTO_COMMENT);
    }

    private File getTarget(File source, String pckg) throws IOException {
        StringBuffer path = new StringBuffer();
        if (this._toDir == null) {
            String parent = source.getParent();
            if (parent != null) {
                path.append(parent + File.separator);
            } else {
                path.append("." + File.separator);
            }
        } else {
            path.append(String.valueOf(this._toDir) + File.separator);
            StringTokenizer st = new StringTokenizer(pckg, ".");
            while (st.hasMoreTokens()) {
                path.append(st.nextToken() + File.separator);
            }
        }
        String name = source.getName();
        String genName = name.substring(0, name.lastIndexOf(46)) + ".java";
        path.append(genName);
        File result = new File(path.toString());
        result.getParentFile().mkdirs();
        if (!result.createNewFile() && !result.canWrite()) {
            throw new IOException("Could not specify target File of source file '" + String.valueOf(source) + "'.\nEstimated '" + String.valueOf(result) + "' was errorneous.");
        }
        return result;
    }

    public static void main(String[] args) {
        if (args.length == 0) {
            StubCompiler.usage();
            System.exit(1);
        }
        File toDir = null;
        StubCompiler c = new StubCompiler(toDir);
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equals("-d")) {
                if (!(toDir = new File(args[++i])).isDirectory()) {
                    System.err.println("\n\nSpecified target directory '" + String.valueOf(toDir) + "' does not exist.\n\n");
                    System.exit(1);
                }
                c = new StubCompiler(toDir);
                continue;
            }
            File sourceFile = new File(args[i]);
            if (!sourceFile.isFile()) {
                System.err.println("Source file '" + String.valueOf(sourceFile) + "'could not be found.");
                System.exit(1);
            }
            if (!sourceFile.canRead()) {
                System.err.println("Cannot read source file '" + String.valueOf(sourceFile) + "'.Ignoring this argument.");
                continue;
            }
            try {
                File targetFile = c.compileStub(sourceFile);
                System.err.println("Target file " + String.valueOf(targetFile) + " generated.");
                continue;
            }
            catch (ParseException e) {
                System.err.println("An error occurred during parsing the stub file.");
                System.err.println(e.getMessage());
                continue;
            }
            catch (IOException e) {
                System.err.println("An error occurred while reading source file or writing the target file:");
                System.err.println(e.getMessage());
            }
        }
    }

    private static void usage() {
        System.err.println("Renew Stub Compiler\n\nGenerates .java files from .stub files\nAll .stub files provided as arguments to this command are\ncompiled to .java files. These can be used to unify with \nsynchronous channels out of java-Code.\n\nUsage:\njava de.renew.call.StubCompiler {-d <todir>} {stub-files}...\n\n-d <todir>\n        Directory in which java Files are generated.\n        Like java files, they are created into their package path.\n        If not specified, files will be generated in the same path.\n        \n{stub-files}...\n        some .stub Files that shall be compiled.\n        Existing Files will be overwritten unless the \n        \" do not modify \" warning has been removed.\n\n");
    }
}

