/*
 * Decompiled with CFR 0.152.
 */
package de.renew.call;

import de.renew.net.NetInstance;
import java.io.File;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.lang.reflect.Method;
import java.util.Hashtable;

class StubGenerator {
    private static String _usageMessage = "Required arguments: [-d PATH] CLASS NET {[+]INTERFACE}\n\nCLASS must be a fully qualified class name.\nNET must be a valid net identifier.\nIf an INTERFACE in the list is preceeded by '+',\nits void methods will be designated as 'break void'.\n\nThe resulting stub file will be placed in the directory\nthat corresponds to the package of CLASS, if any.\nIf the -d option if specified, PATH is taken as the root directory\nfor the target stub file, otherwise the current directory.\nNo directory will be created. No files will be overwritten.\n";

    StubGenerator() {
    }

    static String complexForPrimitive(Class<?> clazz) {
        if (clazz == Boolean.TYPE) {
            return "Boolean";
        }
        if (clazz == Byte.TYPE) {
            return "Byte";
        }
        if (clazz == Character.TYPE) {
            return "Character";
        }
        if (clazz == Short.TYPE) {
            return "Short";
        }
        if (clazz == Integer.TYPE) {
            return "Integer";
        }
        if (clazz == Long.TYPE) {
            return "Long";
        }
        if (clazz == Float.TYPE) {
            return "Float";
        }
        if (clazz == Double.TYPE) {
            return "Double";
        }
        return "";
    }

    static String getTypeName(Class<?> clazz) {
        int level = 0;
        while (clazz.isArray()) {
            ++level;
            clazz = clazz.getComponentType();
        }
        StringBuffer name = new StringBuffer(clazz.getName());
        while (level > 0) {
            name.append("[]");
            --level;
        }
        return name.toString();
    }

    static String makeSignature(Method method) {
        Class<?>[] params = method.getParameterTypes();
        StringBuffer signature = new StringBuffer();
        signature.append(StubGenerator.getTypeName(method.getReturnType()));
        signature.append(" ");
        signature.append(method.getName());
        signature.append("(");
        for (int k = 0; k < params.length; ++k) {
            if (k > 0) {
                signature.append(",");
            }
            signature.append(StubGenerator.getTypeName(params[k]));
        }
        signature.append(")");
        return signature.toString();
    }

    static void outputMethod(Method method, boolean breakWanted, PrintWriter writer) {
        int k;
        Class<?>[] params = method.getParameterTypes();
        StringBuffer head = new StringBuffer("  ");
        if (method.getReturnType() == Void.TYPE && breakWanted) {
            head.append("break ");
        }
        head.append(StubGenerator.getTypeName(method.getReturnType()));
        head.append(" ");
        head.append(method.getName());
        head.append("(");
        for (k = 0; k < params.length; ++k) {
            if (k > 0) {
                writer.println(head);
                head = new StringBuffer();
                head.append("    ");
            }
            String parString = StubGenerator.getTypeName(params[k]) + " arg" + k;
            head.append(parString);
            if (k >= params.length - 1) continue;
            head.append(",");
        }
        head.append(")");
        if (params.length > 1) {
            writer.println(head);
            head = new StringBuffer();
            head.append(" ");
        }
        head.append(" {");
        writer.println(head);
        head = new StringBuffer("    this:");
        head.append(method.getName());
        head.append("(instance");
        for (k = 0; k < params.length; ++k) {
            head.append(",arg" + k);
        }
        head.append(");");
        writer.println(head);
        if (method.getReturnType() == Void.TYPE) {
            writer.println("    this:result(instance);");
        } else {
            writer.println("    this:result(instance,return);");
        }
        writer.println("  }");
    }

    public static void main(String[] args) {
        String stubname;
        String fileName;
        File outputFile;
        if (args.length < 2 || "-d".equals(args[0]) && args.length < 4) {
            System.err.println(_usageMessage);
            System.exit(0);
        }
        int index = 0;
        Object path = "";
        if ("-d".equals(args[0])) {
            int n = ++index;
            ++index;
            path = args[n].substring(2).trim();
            if (!((String)path).endsWith(File.separator)) {
                path = (String)path + File.separator;
            }
        }
        if ((outputFile = new File(fileName = (String)path + (stubname = args[index++]).replace('.', File.separatorChar) + ".stub")).exists()) {
            System.err.println("Target file " + fileName + " already exists. Aborting.");
        }
        String netName = args[index++];
        PrintWriter writer = null;
        try {
            String className;
            writer = new PrintWriter(new FileWriter(outputFile));
            boolean[] breakWanted = new boolean[args.length - index];
            String[] name = new String[args.length - index];
            int i = 0;
            while (index < args.length) {
                breakWanted[i] = args[index].charAt(0) == '+';
                name[i] = breakWanted[i] ? args[index].substring(1) : args[index];
                ++index;
                ++i;
            }
            int dotPos = stubname.lastIndexOf(".");
            if (dotPos > 0) {
                writer.println("package " + stubname.substring(0, dotPos) + ";");
                className = stubname.substring(dotPos + 1);
            } else {
                className = stubname;
            }
            int interfaceCount = name.length;
            writer.println("class " + className + " for net " + netName);
            if (interfaceCount > 0) {
                writer.println("implements");
                for (int i2 = 0; i2 < interfaceCount; ++i2) {
                    if (i2 + 1 < interfaceCount) {
                        writer.println("  " + name[i2] + ",");
                        continue;
                    }
                    writer.println("  " + name[i2]);
                }
            }
            writer.println("{");
            Hashtable<String, Boolean> allMethods = new Hashtable<String, Boolean>();
            Method[] netInstanceMethods = NetInstance.class.getMethods();
            for (int j = 0; j < netInstanceMethods.length; ++j) {
                Method method = netInstanceMethods[j];
                String signatureString = StubGenerator.makeSignature(method);
                allMethods.put(signatureString, Boolean.FALSE);
            }
            for (int i3 = 0; i3 < interfaceCount; ++i3) {
                Class<?> clazz;
                try {
                    clazz = Class.forName(name[i3]);
                }
                catch (ClassNotFoundException e) {
                    throw new RuntimeException(e.toString());
                }
                if (!clazz.isInterface()) {
                    throw new RuntimeException("Not an interface: " + name[i3]);
                }
                Method[] methods = clazz.getMethods();
                for (int j = 0; j < methods.length; ++j) {
                    Method method = methods[j];
                    String signatureString = StubGenerator.makeSignature(method);
                    if (!allMethods.containsKey(signatureString)) {
                        allMethods.put(signatureString, breakWanted[i3]);
                        StubGenerator.outputMethod(method, breakWanted[i3], writer);
                        continue;
                    }
                    Boolean wasBreakWanted = (Boolean)allMethods.get(signatureString);
                    if (method.getReturnType() != Void.TYPE || !(wasBreakWanted ^ breakWanted[i3])) continue;
                    throw new RuntimeException("Method requested twice, but only once as break void. " + signatureString);
                }
            }
            writer.println("}");
            writer.close();
        }
        catch (Exception e) {
            System.err.println("An error occurred during the creation of the stub file.");
            System.err.println(e.getMessage());
            try {
                if (writer != null) {
                    writer.close();
                }
            }
            catch (Exception name) {
                // empty catch block
            }
            try {
                if (outputFile.exists()) {
                    outputFile.delete();
                }
            }
            catch (Exception ex) {
                System.err.println("Could not remove broken file " + fileName + ".");
            }
        }
    }
}

