/*
 * Decompiled with CFR 0.152.
 */
package CH.ifa.draw.figures;

import CH.ifa.draw.figures.PolyLineFigure;
import CH.ifa.draw.figures.SmoothPolyLineFigure;
import CH.ifa.draw.framework.DrawingEditor;
import CH.ifa.draw.standard.UndoableTool;
import java.awt.Point;
import java.awt.event.MouseEvent;

public class ScribbleTool
extends UndoableTool {
    private PolyLineFigure fScribble;
    private Point lastPoint;
    private boolean didDrag = false;
    private Point lastMouseDown;
    public boolean shouldUseSmoothCurves = false;
    public static double smoothness = 0.5;

    public ScribbleTool(DrawingEditor editor) {
        super(editor);
    }

    @Override
    public void activate() {
        super.activate();
        this.fScribble = null;
    }

    @Override
    public void deactivate() {
        if (this.fScribble != null && (this.fScribble.size().width < 4 || this.fScribble.size().height < 4)) {
            this.drawing().remove(this.fScribble);
            this.noChangesMade();
        }
        this.fScribble = null;
        super.deactivate();
    }

    private void point(int x, int y) {
        if (this.fScribble == null) {
            this.fScribble = this.shouldUseSmoothCurves ? new SmoothPolyLineFigure(x, y, smoothness) : new PolyLineFigure(x, y);
            this.view().add(this.fScribble);
            this.changesMade();
        } else if (this.lastPoint.x != x || this.lastPoint.y != y) {
            this.fScribble.addPoint(x, y);
        }
        this.lastPoint = new Point(x, y);
    }

    @Override
    public void mouseDown(MouseEvent e, int x, int y) {
        if (e.getClickCount() >= 2) {
            this.editor().toolDone();
        } else {
            this.point(x, y);
        }
        this.lastMouseDown = new Point(x, y);
    }

    @Override
    public void mouseDrag(MouseEvent e, int x, int y) {
        if (this.fScribble != null) {
            this.point(x, y);
        }
        Point currentPoint = new Point(x, y);
        if (this.lastMouseDown != null) {
            boolean farEnough;
            boolean bl = farEnough = currentPoint.distance(this.lastMouseDown) > 2.0;
            if (farEnough) {
                this.didDrag = true;
            }
        }
    }

    @Override
    public void mouseUp(MouseEvent e, int x, int y) {
        super.mouseUp(e, x, y);
        if (this.didDrag) {
            this.fScribble = null;
        }
        this.didDrag = false;
    }
}

