/*
 * Decompiled with CFR 0.152.
 */
package CH.ifa.draw.figures;

import CH.ifa.draw.figures.TextFigure;
import CH.ifa.draw.framework.DrawingEditor;
import CH.ifa.draw.framework.Figure;
import CH.ifa.draw.standard.CreationTool;
import CH.ifa.draw.standard.TextHolder;
import CH.ifa.draw.util.FloatingTextField;
import java.awt.Container;
import java.awt.Font;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;

public class TextTool
extends CreationTool {
    protected FloatingTextField fTextField;
    private TextHolder fTypingTarget;
    private AffineTransform fAffineTransform;

    public TextTool(DrawingEditor editor, TextFigure prototype) {
        super(editor, prototype);
    }

    @Override
    public void mouseDown(MouseEvent e, int x, int y) {
        TextHolder textHolder = null;
        Figure pressedFigure = this.drawing().findFigureInside(x, y);
        if (pressedFigure instanceof TextHolder && !(textHolder = (TextHolder)((Object)pressedFigure)).acceptsTyping()) {
            textHolder = null;
        }
        if (textHolder != null) {
            this.beginEdit(textHolder);
            return;
        }
        if (this.fTypingTarget != null) {
            this.endEdit();
            this.editor().toolDone();
        } else {
            super.mouseDown(e, x, y);
            textHolder = (TextHolder)((Object)this.createdFigure());
            this.beginEdit(textHolder);
        }
    }

    @Override
    public void mouseDrag(MouseEvent e, int x, int y) {
    }

    @Override
    public void mouseUp(MouseEvent e, int x, int y) {
    }

    @Override
    public void deactivate() {
        super.deactivate();
        this.endEdit();
    }

    @Override
    public void activate() {
        super.activate();
    }

    protected boolean isTypingActive() {
        return this.fTypingTarget != null;
    }

    public void beginEdit(TextHolder figure) {
        if (this.fTextField == null) {
            this.fTextField = new FloatingTextField();
            this.fTextField.addKeyListener(new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent keyEvent) {
                    if (keyEvent.isControlDown() && keyEvent.getKeyCode() == 10) {
                        TextTool.this.deactivate();
                        TextTool.this.editor().toolDone();
                    }
                }
            });
        }
        if (figure != this.fTypingTarget && this.fTypingTarget != null) {
            this.endEdit();
        }
        this.fTextField.setText(figure.getText());
        figure.setText("");
        Rectangle bounds = this.fieldBounds(figure);
        Font font = figure.getFont();
        this.fAffineTransform = this.view().getAffineTransform();
        if (this.fAffineTransform != null) {
            Point p = new Point(bounds.x, bounds.y);
            this.fAffineTransform.transform(p, p);
            bounds = new Rectangle(p.x, p.y, 0, 0);
            font = font.deriveFont(this.fAffineTransform);
        }
        this.fTextField.createOverlay((Container)((Object)this.view()), bounds, font);
        this.fTypingTarget = figure;
        this.view().checkDamage();
    }

    public void setCaretPosition(int line, int col) {
        this.fTextField.setCaretPosition(line, col);
    }

    public void select(int startLine, int startColumn, int endLine, int endColumn) {
        this.fTextField.select(startLine, startColumn, endLine, endColumn);
    }

    public void endEdit() {
        if (this.fTypingTarget != null) {
            String newText = this.fTextField.getText();
            String oldText = this.fTypingTarget.getText();
            this.fTypingTarget.setText(newText);
            if (newText.trim().length() == 0) {
                this.drawing().remove((Figure)((Object)this.fTypingTarget));
            }
            this.fTypingTarget = null;
            this.fTextField.endOverlay();
            this.view().checkDamage();
            if (!oldText.equals(newText)) {
                this.changesMade();
                this.intermediateUndoSnapshot();
            } else {
                this.noChangesMade();
            }
        }
    }

    private Rectangle fieldBounds(TextHolder figure) {
        Rectangle box = figure.textDisplayBox();
        return box;
    }
}

