/*
 * Decompiled with CFR 0.152.
 */
package CH.ifa.draw.framework;

import CH.ifa.draw.framework.Drawing;
import CH.ifa.draw.framework.DrawingTypeManagerListener;
import CH.ifa.draw.io.IFAFileFilter;
import CH.ifa.draw.io.SimpleFileFilter;
import de.renew.plugin.PluginManager;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Set;
import org.apache.log4j.Logger;

public class DrawingTypeManager {
    public static final Logger LOGGER = Logger.getLogger(DrawingTypeManager.class);
    private static DrawingTypeManager _dtm;
    private final Hashtable<String, SimpleFileFilter> _drawingTypes = new Hashtable();
    private SimpleFileFilter _defaultFileFilter;
    private final Set<DrawingTypeManagerListener> _listeners = new HashSet<DrawingTypeManagerListener>();

    private DrawingTypeManager() {
    }

    public static DrawingTypeManager getInstance() {
        if (_dtm == null) {
            _dtm = new DrawingTypeManager();
            IFAFileFilter ifa = new IFAFileFilter();
            _dtm.register("CH.ifa.draw.standard.StandardDrawing", ifa);
            _dtm.setDefaultFileFilter(ifa);
            return _dtm;
        }
        return _dtm;
    }

    public Object register(String drawingName, SimpleFileFilter ff) {
        LOGGER.debug((Object)("DrawingTypeManager: registering " + String.valueOf(ff) + " for drawing type " + drawingName));
        SimpleFileFilter previous = this._drawingTypes.put(drawingName, ff);
        for (DrawingTypeManagerListener drawingTypeManagerListener : this._listeners) {
            drawingTypeManagerListener.typeRegistered(drawingName, ff);
        }
        return previous;
    }

    public static Drawing getDrawingFromName(String name) {
        Drawing d = null;
        try {
            ClassLoader classLoader = PluginManager.getInstance().getBottomClassLoader();
            Constructor<?> constructor = Class.forName(name, true, classLoader).getConstructor(new Class[0]);
            d = (Drawing)constructor.newInstance(new Object[0]);
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
            LOGGER.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
        return d;
    }

    public static Drawing getDrawingForFilter(SimpleFileFilter ff) {
        Hashtable<String, SimpleFileFilter> hash = DrawingTypeManager.getInstance().getDrawingTypes();
        Enumeration<String> enumeration = hash.keys();
        while (enumeration.hasMoreElements()) {
            String key = enumeration.nextElement();
            SimpleFileFilter fileFilter = hash.get(key);
            if (!fileFilter.equals(ff)) continue;
            return DrawingTypeManager.getDrawingFromName(key);
        }
        return null;
    }

    public Hashtable<String, SimpleFileFilter> getDrawingTypes() {
        return this._drawingTypes;
    }

    public boolean contains(String name) {
        return this._drawingTypes.containsKey(name);
    }

    public SimpleFileFilter getFilter(String name) {
        return this._drawingTypes.get(name);
    }

    public SimpleFileFilter getDefaultFileFilter() {
        return this._defaultFileFilter;
    }

    public void setDefaultFileFilter(SimpleFileFilter filter) {
        if (!this._drawingTypes.contains(filter)) {
            throw new IllegalArgumentException("Cannot choose unknown drawing type as default: " + String.valueOf(filter));
        }
        LOGGER.debug((Object)("DrawingTypeManager: choosing " + String.valueOf(filter) + " as default drawing type."));
        this._defaultFileFilter = filter;
        for (DrawingTypeManagerListener drawingTypeManagerListener : this._listeners) {
            drawingTypeManagerListener.defaultTypeChanged(filter);
        }
    }

    public void addListener(DrawingTypeManagerListener listener) {
        this._listeners.add(listener);
    }

    public void removeListener(DrawingTypeManagerListener listener) {
        this._listeners.remove(listener);
    }

    public void unregister(String drawingName) {
        LOGGER.debug((Object)("DrawingTypeManager: unregistering  for drawing type " + drawingName));
        this._drawingTypes.remove(drawingName);
        if (drawingName.equals(this._defaultFileFilter.getDescription())) {
            Enumeration<String> enu = this._drawingTypes.keys();
            if (enu.hasMoreElements()) {
                SimpleFileFilter ff = this._drawingTypes.get(enu.nextElement());
                this.setDefaultFileFilter(ff);
            } else {
                this._defaultFileFilter = null;
            }
        }
        for (DrawingTypeManagerListener drawingTypeManagerListener : this._listeners) {
            drawingTypeManagerListener.defaultTypeChanged(this._defaultFileFilter);
        }
    }
}

