/*
 * Decompiled with CFR 0.152.
 */
package CH.ifa.draw.gui.settingswindow;

import CH.ifa.draw.gui.reactivecomponents.Component;
import CH.ifa.draw.gui.reactivecomponents.State;
import CH.ifa.draw.gui.settingswindow.PageComponent;
import CH.ifa.draw.gui.settingswindow.SideNavComponent;
import de.renew.plugin.propertymanagement.ConfigurableProperty;
import java.awt.Dimension;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JPanel;

public class ContentComponent
extends Component {
    private final Map<String, List<ConfigurableProperty>> _propertiesByPlugins;

    public ContentComponent(Map<String, ConfigurableProperty> properties) {
        this._propertiesByPlugins = properties.values().stream().collect(Collectors.groupingBy(ConfigurableProperty::getPluginName));
    }

    @Override
    protected JComponent render() {
        JPanel content = new JPanel();
        this.setLayoutFor(content);
        State<String> activePlugin = this.useState();
        this.renderSideNavIn(content, activePlugin);
        this.renderPageIn(content, activePlugin);
        return content;
    }

    private void setLayoutFor(JComponent content) {
        content.setMaximumSize(new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE));
        content.setLayout(new BoxLayout(content, 0));
    }

    private void renderSideNavIn(JComponent parentContainer, State<String> activePlugin) {
        Map<String, Runnable> pluginEntries = this._propertiesByPlugins.keySet().stream().collect(Collectors.toMap(Function.identity(), element -> () -> activePlugin.setValue((String)element)));
        SideNavComponent sideNav = new SideNavComponent(pluginEntries);
        parentContainer.add(sideNav.get());
    }

    private void renderPageIn(JComponent content, State<String> activePlugin) {
        List<ConfigurableProperty> pluginProperties = this._propertiesByPlugins.get(activePlugin.getValue());
        PageComponent page = new PageComponent(pluginProperties);
        content.add(page.get());
    }
}

