/*
 * Decompiled with CFR 0.152.
 */
package CH.ifa.draw.io;

import CH.ifa.draw.DrawPlugin;
import CH.ifa.draw.application.DrawApplication;
import CH.ifa.draw.framework.Drawing;
import CH.ifa.draw.io.CombinationFileFilter;
import CH.ifa.draw.io.DrawingFileHelper;
import CH.ifa.draw.io.ExportHolder;
import CH.ifa.draw.io.NoFileFilter;
import CH.ifa.draw.io.SimpleFileFilter;
import CH.ifa.draw.io.StatusDisplayer;
import CH.ifa.draw.io.exportFormats.ExportFormat;
import CH.ifa.draw.io.exportFormats.ExportFormatCommand;
import CH.ifa.draw.io.exportFormats.ExportFormatMulti;
import CH.ifa.draw.standard.NullDrawing;
import CH.ifa.draw.util.Command;
import CH.ifa.draw.util.CommandMenu;
import de.renew.util.StringUtil;
import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileFilter;
import org.apache.log4j.Logger;

public class ExportHolderImpl
implements ExportHolder {
    public static Logger logger = Logger.getLogger(ExportHolderImpl.class);
    private CommandMenu exportMenu = new CommandMenu("Export");
    private List<ExportFormat> _exportFormats;
    private CommandMenu _exportMenu11;
    private CommandMenu _exportMenuNN;
    private CommandMenu _exportMenuN1;
    private static final String APPENDIX_11 = " current drawing ...";
    private static final String APPENDIX_N1 = " all drawings (N to 1) ...";
    private static final String APPENDIX_NN = " all drawings (N to N)";

    public ExportHolderImpl() {
        this.exportMenu.putClientProperty("ch.ifa.draw.menu.id", "ch.ifa.draw.io.export");
        this.initExportFormatHolder();
    }

    private StatusDisplayer displayer() {
        return DrawPlugin.getGui();
    }

    private DrawApplication application() {
        return DrawPlugin.getGui();
    }

    public JMenu getExportMenu() {
        assert (this.exportMenu != null) : "Failure in GuiPlugin: exportMenu == null";
        return this.exportMenu;
    }

    private void initExportFormatHolder() {
        this.setExportFormats(new ArrayList<ExportFormat>());
        this.setExportMenu11(new CommandMenu("Export current drawing"));
        this.setExportMenuNN(new CommandMenu("Export all drawings (single file each)"));
        this.setExportMenuN1(new CommandMenu("Export all drawings (merged file)"));
        this.buildExportAll();
        this.exportMenu.add(this.exportMenu11());
        this.exportMenu.add(this.exportMenuNN());
        this.exportMenu.add(this.exportMenuN1());
    }

    private List<ExportFormat> exportFormats() {
        assert (this._exportFormats != null) : "Failure in GuiPlugin: _exportFormats == null";
        return this._exportFormats;
    }

    private void setExportFormats(List<ExportFormat> exportFormats) {
        this._exportFormats = exportFormats;
        assert (this.exportFormats() != null) : "Failure in GuiPlugin: exportFormats == null";
        assert (this.exportFormats().equals(exportFormats)) : "Failure in GuiPlugin: exportFormats != exportFormats()";
    }

    private CommandMenu exportMenu11() {
        assert (this._exportMenu11 != null) : "Failure in GuiPlugin: _exportMenu11 == null";
        return this._exportMenu11;
    }

    private void setExportMenu11(CommandMenu exportMenu11) {
        this._exportMenu11 = exportMenu11;
        assert (this.exportMenu11() != null) : "Failure in GuiPlugin: exportMenu == null";
        assert (this.exportMenu11().equals(exportMenu11)) : "Failure in GuiPlugin: exportMenu != exportMenu";
    }

    private CommandMenu exportMenuNN() {
        assert (this._exportMenuNN != null) : "Failure in GuiPlugin: _exportMenuNN == null";
        return this._exportMenuNN;
    }

    private void setExportMenuNN(CommandMenu exportMenuNN) {
        this._exportMenuNN = exportMenuNN;
        assert (this.exportMenuNN() != null) : "Failure in GuiPlugin: exportMenu == null";
        assert (this.exportMenuNN().equals(exportMenuNN)) : "Failure in GuiPlugin: exportMenu != exportMenu";
    }

    private CommandMenu exportMenuN1() {
        assert (this._exportMenuN1 != null) : "Failure in GuiPlugin: _exportMenuN1 == null";
        return this._exportMenuN1;
    }

    private void setExportMenuN1(CommandMenu exportMenuN1) {
        this._exportMenuN1 = exportMenuN1;
        assert (this.exportMenuN1() != null) : "Failure in GuiPlugin: exportMenu == null";
        assert (this.exportMenuN1().equals(exportMenuN1)) : "Failure in GuiPlugin: exportMenu != exportMenu";
    }

    private SimpleFileFilter[] fileFilterExport(Drawing drawing) {
        ArrayList<FileFilter[]> fileFilters = new ArrayList<FileFilter[]>();
        ExportFormat[] formats = this.allExportFormats();
        for (int pos = 0; pos < formats.length; ++pos) {
            if (!formats[pos].canExportDrawing(drawing)) continue;
            FileFilter[] filters = this.buildFileFilter(formats[pos]);
            fileFilters.add(filters);
        }
        ArrayList<SimpleFileFilter> allFileFilters = new ArrayList<SimpleFileFilter>();
        allFileFilters.add(new NoFileFilter());
        for (FileFilter[] element : fileFilters) {
            for (int pos = 0; pos < element.length; ++pos) {
                SimpleFileFilter current = (SimpleFileFilter)element[pos];
                boolean exists = false;
                for (int pos2 = 0; pos2 <= pos; ++pos2) {
                    if (!current.equals(allFileFilters.get(pos2))) continue;
                    exists = true;
                    break;
                }
                if (exists) continue;
                allFileFilters.add(current);
            }
        }
        return allFileFilters.toArray(new SimpleFileFilter[0]);
    }

    private FileFilter[] buildFileFilter(ExportFormat exportFormat) {
        FileFilter filter = exportFormat.fileFilter();
        ArrayList<FileFilter> list = new ArrayList<FileFilter>();
        if (filter instanceof CombinationFileFilter) {
            CombinationFileFilter comFilter = (CombinationFileFilter)filter;
            Iterator<SimpleFileFilter> filters = comFilter.getFileFilters().iterator();
            while (filters.hasNext()) {
                list.add(filters.next());
            }
        } else {
            list.add(filter);
        }
        return list.toArray(new FileFilter[0]);
    }

    private void buildExportAll() {
        Command command = new Command("Export current drawing (any type)..."){

            @Override
            public void execute() {
                if (!(ExportHolderImpl.this.application().drawing() instanceof NullDrawing)) {
                    File path = DrawPlugin.getCurrent().getIOHelper().getSaveFile(null, ExportHolderImpl.this.fileFilterExport(ExportHolderImpl.this.application().drawing()), ExportHolderImpl.this.application().drawing());
                    if (path != null) {
                        Object choice;
                        ArrayList<ExportFormat[]> list = new ArrayList<ExportFormat[]>();
                        for (int pos = 0; pos < ExportHolderImpl.this.allExportFormats().length; ++pos) {
                            ExportFormat[] formats = ExportHolderImpl.this.allExportFormats()[pos].canExport(path);
                            if (formats.length <= 0) continue;
                            list.add(formats);
                        }
                        Iterator formatsIter = list.iterator();
                        ArrayList<ExportFormat> allFormats = new ArrayList<ExportFormat>();
                        while (formatsIter.hasNext()) {
                            ExportFormat[] formatArray = (ExportFormat[])formatsIter.next();
                            for (int pos = 0; pos < formatArray.length; ++pos) {
                                if (!formatArray[pos].canExportDrawing(ExportHolderImpl.this.application().drawing())) continue;
                                if (new NoFileFilter().equals(formatArray[pos].fileFilter())) {
                                    if (!StringUtil.getExtension((String)path.getPath()).equals("")) continue;
                                    allFormats.add(formatArray[pos]);
                                    continue;
                                }
                                allFormats.add(formatArray[pos]);
                            }
                        }
                        ExportFormat format = null;
                        if (allFormats.size() == 1) {
                            format = (ExportFormat)allFormats.get(0);
                        } else if (allFormats.size() > 1 && (choice = JOptionPane.showInputDialog(null, "Choose", "ExportFormats", 2, null, allFormats.toArray(), allFormats.get(0))) != null) {
                            format = (ExportFormat)choice;
                        }
                        if (format != null) {
                            ExportHolderImpl.this.saveDrawing(ExportHolderImpl.this.application().drawing(), format, path);
                        } else {
                            ExportHolderImpl.this.displayer().showStatus("no ExportFormat");
                        }
                    }
                } else {
                    ExportHolderImpl.this.displayer().showStatus("no drawing");
                }
            }

            @Override
            public boolean isExecutable() {
                return super.isExecutable() && ExportHolderImpl.this.application() != null && !(ExportHolderImpl.this.application().drawing() instanceof NullDrawing);
            }
        };
        this.exportMenu.add(command);
    }

    public void saveDrawings(Enumeration<Drawing> drawings, ExportFormat format, File path, StatusDisplayer displ) {
        block2: {
            try {
                ArrayList<Drawing> list2 = Collections.list(drawings);
                Drawing[] array = list2.toArray(new Drawing[0]);
                format.export(array, path);
                displ.showStatus("Exported " + path.getPath() + ".");
            }
            catch (Exception e) {
                logger.error((Object)e.getMessage());
                displ.showStatus(e.toString());
                if (!logger.isDebugEnabled()) break block2;
                logger.debug((Object)(ExportHolderImpl.class.getSimpleName() + ": "), (Throwable)e);
            }
        }
    }

    private void saveDrawings(Enumeration<Drawing> drawings, ExportFormat format) {
        try {
            ArrayList<Drawing> drawingList = new ArrayList<Drawing>();
            while (drawings.hasMoreElements()) {
                Drawing drawing = drawings.nextElement();
                if (drawing.getFilename() == null) {
                    this.application().saveDrawingAs(drawing);
                    continue;
                }
                drawingList.add(drawing);
            }
            Drawing[] drawingArray = drawingList.toArray(new Drawing[0]);
            File[] paths = new File[drawingArray.length];
            for (int pos = 0; pos < drawingArray.length; ++pos) {
                String name = drawingArray[pos].getName();
                File path = drawingArray[pos].getFilename().getCanonicalFile();
                String pathString = path.getParent() + File.separator + name;
                paths[pos] = DrawingFileHelper.checkAndAddExtension(new File(pathString), (SimpleFileFilter)format.fileFilter());
            }
            if (drawingArray.length > 0) {
                format.exportAll(drawingArray, paths);
                this.displayer().showStatus("Exported.");
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            this.displayer().showStatus(e.toString());
        }
    }

    public void saveDrawing(Drawing drawing, ExportFormat format, File path, StatusDisplayer sd) {
        try {
            File pathResult = format.export(drawing, path);
            sd.showStatus("Exported " + pathResult.getPath() + ".");
        }
        catch (Exception e) {
            sd.showStatus(e.getMessage());
            e.printStackTrace();
        }
    }

    private void saveDrawing(Drawing drawing, ExportFormat format, File path) {
        try {
            File pathResult = format.export(drawing, path);
            this.displayer().showStatus("Exported " + pathResult.getPath() + ".");
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            this.displayer().showStatus(e.toString());
        }
    }

    private void buildExportFormat(ExportFormat exportFormat, CommandMenu parent11, CommandMenu parentNN, CommandMenu parentN1) {
        if (exportFormat instanceof ExportFormatMulti) {
            ExportFormatMulti multi = (ExportFormatMulti)exportFormat;
            ExportFormat[] formats = multi.allExportFormats();
            String name = multi.formatName();
            CommandMenu menu11 = new CommandMenu(name);
            CommandMenu menuNN = new CommandMenu(name);
            CommandMenu menuN1 = new CommandMenu(name);
            for (ExportFormat f : formats) {
                this.buildExportFormat(f, menu11, menuNN, menuN1);
            }
            parent11.add(menu11);
            parent11.addSeparator();
            parentNN.add(menuNN);
            parentNN.addSeparator();
            parentN1.add(menuN1);
            parentN1.addSeparator();
        } else {
            this.generateCommands(exportFormat, parent11, parentNN, parentN1);
        }
    }

    private void generateCommands(ExportFormat format, CommandMenu menu11, CommandMenu menuNN, CommandMenu menuN1) {
        ExportFormatCommand command11 = this.generateExportCommand1to1(format);
        if (format.getShortCut() == -1) {
            menu11.add(command11);
        } else if (format.getModifier() == -1) {
            menu11.add(command11, format.getShortCut());
        } else {
            menu11.add(command11, format.getShortCut(), format.getModifier());
        }
        ExportFormatCommand commandNN = this.generateExportCommandNtoN(format);
        menuNN.add(commandNN);
        if (format.canExportNto1()) {
            ExportFormatCommand commandN1 = this.generateExportCommandNto1(format);
            menuN1.add(commandN1);
        }
    }

    private ExportFormatCommand generateExportCommand1to1(ExportFormat format) {
        ExportFormatCommand result = null;
        if (format != null) {
            result = new ExportFormatCommand(format, APPENDIX_11){

                @Override
                public void execute() {
                    Drawing drawing = ExportHolderImpl.this.application().drawing();
                    if (drawing != null) {
                        if (!(drawing instanceof NullDrawing)) {
                            if (this.format().forceGivenName()) {
                                if (drawing.getFilename() != null) {
                                    try {
                                        String fileNameText = drawing.getFilename().getCanonicalPath() + drawing.getName();
                                        fileNameText = StringUtil.getPath((String)fileNameText) + File.separator + drawing.getName();
                                        File file = new File(fileNameText);
                                        ExportHolderImpl.this.saveDrawing(drawing, this.format(), file);
                                    }
                                    catch (IOException e) {
                                        logger.error((Object)"Could not create export file: ");
                                        logger.debug((Object)"Could not create export file: ", (Throwable)e);
                                    }
                                }
                            } else {
                                File path = DrawPlugin.getCurrent().getIOHelper().getSaveFile(null, new SimpleFileFilter[]{(SimpleFileFilter)this.format().fileFilter()}, drawing);
                                if (path != null) {
                                    ExportHolderImpl.this.displayer().showStatus("Exporting " + String.valueOf(path) + " ...");
                                    ExportHolderImpl.this.saveDrawing(drawing, this.format(), path);
                                }
                            }
                        } else {
                            ExportHolderImpl.this.displayer().showStatus("no drawing");
                        }
                    } else {
                        ExportHolderImpl.this.displayer().showStatus("no drawing");
                    }
                    ExportHolderImpl.this.application().toolDone();
                }

                @Override
                public boolean isExecutable() {
                    return ExportHolderImpl.this.application() != null && !(ExportHolderImpl.this.application().drawing() instanceof NullDrawing) && this.format().canExportDrawing(ExportHolderImpl.this.application().drawing());
                }
            };
        }
        assert (result != null) : "Failure in GuiPlugin: result == null";
        return result;
    }

    private ExportFormatCommand generateExportCommandNto1(ExportFormat format) {
        ExportFormatCommand result = null;
        if (format != null) {
            result = new ExportFormatCommand(format, APPENDIX_N1){

                @Override
                public void execute() {
                    Enumeration<Drawing> drawings = ExportHolderImpl.this.application().drawings();
                    if (drawings != null) {
                        if (drawings.hasMoreElements()) {
                            File path = DrawPlugin.getCurrent().getIOHelper().getSaveFile(null, new SimpleFileFilter[]{(SimpleFileFilter)this.format().fileFilter()}, drawings.nextElement());
                            if (path != null) {
                                ExportHolderImpl.this.displayer().showStatus("Exporting " + String.valueOf(path) + " ...");
                                ExportHolderImpl.this.saveDrawings(ExportHolderImpl.this.application().drawings(), this.format(), path, ExportHolderImpl.this.displayer());
                            }
                        } else {
                            ExportHolderImpl.this.displayer().showStatus("no drawing");
                        }
                    }
                    ExportHolderImpl.this.application().toolDone();
                    ExportHolderImpl.this.displayer().showStatus("export");
                }

                @Override
                public boolean isExecutable() {
                    if (ExportHolderImpl.this.application() == null || ExportHolderImpl.this.application().drawing() instanceof NullDrawing) {
                        return false;
                    }
                    Enumeration<Drawing> drawings = ExportHolderImpl.this.application().drawings();
                    while (drawings.hasMoreElements()) {
                        Drawing drawing = drawings.nextElement();
                        if (this.format().canExportDrawing(drawing)) continue;
                        return false;
                    }
                    return true;
                }
            };
        }
        assert (result != null) : "Failure in GuiPlugin: result == null";
        return result;
    }

    private ExportFormatCommand generateExportCommandNtoN(ExportFormat format) {
        ExportFormatCommand result = null;
        if (format != null) {
            result = new ExportFormatCommand(format, APPENDIX_NN){

                @Override
                public void execute() {
                    ExportHolderImpl.this.displayer().showStatus("Exporting...");
                    Enumeration<Drawing> drawings = ExportHolderImpl.this.application().drawings();
                    if (drawings != null) {
                        if (drawings.hasMoreElements()) {
                            ExportHolderImpl.this.saveDrawings(drawings, this.format());
                        } else {
                            ExportHolderImpl.this.displayer().showStatus("no drawing");
                        }
                    }
                    ExportHolderImpl.this.application().toolDone();
                    ExportHolderImpl.this.displayer().showStatus("export");
                }

                @Override
                public boolean isExecutable() {
                    if (ExportHolderImpl.this.application() == null || ExportHolderImpl.this.application().drawing() instanceof NullDrawing) {
                        return false;
                    }
                    Enumeration<Drawing> drawings = ExportHolderImpl.this.application().drawings();
                    while (drawings.hasMoreElements()) {
                        Drawing drawing = drawings.nextElement();
                        if (this.format().canExportDrawing(drawing)) continue;
                        return false;
                    }
                    return true;
                }
            };
        }
        assert (result != null) : "Failure in GuiPlugin: result == null";
        return result;
    }

    @Override
    public void addExportFormat(ExportFormat exportFormat) {
        logger.debug((Object)(String.valueOf(this.getClass()) + ": adding export format " + String.valueOf(exportFormat)));
        this.exportFormats().add(exportFormat);
        this.buildExportFormat(exportFormat, this.exportMenu11(), this.exportMenuNN(), this.exportMenuN1());
    }

    @Override
    public ExportFormat[] allExportFormats() {
        return this.exportFormats().toArray(new ExportFormat[0]);
    }

    @Override
    public void removeExportFormat(ExportFormat format) {
        Component[] ele;
        for (Component component : ele = this.exportMenu.getMenuComponents()) {
            JMenuItem item;
            if (!(component instanceof JMenuItem) || !(item = (JMenuItem)component).getText().equals(format.formatName())) continue;
            this.exportMenu.remove(item);
        }
        this.removeExportFormatFromMenu(format, this._exportMenu11, APPENDIX_11);
        this.removeExportFormatFromMenu(format, this._exportMenuN1, APPENDIX_N1);
        this.removeExportFormatFromMenu(format, this._exportMenuNN, APPENDIX_NN);
        this.exportFormats().remove(format);
    }

    private void removeExportFormatFromMenu(ExportFormat format, CommandMenu menu, String appendix) {
        Component[] ele;
        for (Component component : ele = menu.getMenuComponents()) {
            JMenuItem item;
            if (!(component instanceof JMenuItem) || !(item = (JMenuItem)component).getText().equals(format.formatName() + appendix)) continue;
            menu.remove(item);
        }
    }
}

