/*
 * Decompiled with CFR 0.152.
 */
package CH.ifa.draw.standard;

import CH.ifa.draw.figures.ScribbleTool;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSlider;

public class ScribbleOptionPanel
extends JPanel {
    private final ScribbleTool scribbleTool;
    private final JRadioButton rawRadioButton;
    private final JRadioButton smoothRadioButton;
    private final JSlider slider;

    public ScribbleOptionPanel(ScribbleTool scribbleTool) {
        super(new GridBagLayout());
        this.scribbleTool = scribbleTool;
        this.rawRadioButton = this.createRadioButton("Raw", !scribbleTool.shouldUseSmoothCurves);
        this.smoothRadioButton = this.createRadioButton("Smooth", scribbleTool.shouldUseSmoothCurves);
        this.slider = this.createSlider();
        this.setupUI();
    }

    private void setupUI() {
        this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.configureRadioButtonActionListeners();
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.rawRadioButton);
        buttonGroup.add(this.smoothRadioButton);
        JLabel sliderTitle = new JLabel("Smoothness:");
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 17;
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.insets = new Insets(5, 5, 5, 5);
        this.add((Component)this.rawRadioButton, gbc);
        gbc.gridy = 1;
        this.add((Component)this.smoothRadioButton, gbc);
        gbc.gridy = 2;
        gbc.gridx = 0;
        this.add((Component)sliderTitle, gbc);
        gbc.gridx = 1;
        gbc.fill = 2;
        gbc.weightx = 1.0;
        this.add((Component)this.slider, gbc);
    }

    private JRadioButton createRadioButton(String text, boolean selected) {
        JRadioButton radioButton = new JRadioButton(text);
        radioButton.setSelected(selected);
        return radioButton;
    }

    private JSlider createSlider() {
        JSlider slider = new JSlider();
        slider.setPreferredSize(new Dimension(100, slider.getPreferredSize().height));
        slider.addChangeListener(e -> {
            int value = slider.getValue();
            ScribbleTool.smoothness = (double)value / 100.0;
        });
        slider.setEnabled(false);
        return slider;
    }

    private void configureRadioButtonActionListeners() {
        this.rawRadioButton.addActionListener(e -> this.updateScribbleToolOptions(false));
        this.smoothRadioButton.addActionListener(e -> this.updateScribbleToolOptions(true));
    }

    private void updateScribbleToolOptions(boolean useSmoothCurves) {
        this.scribbleTool.shouldUseSmoothCurves = useSmoothCurves;
        this.slider.setEnabled(this.smoothRadioButton.isSelected());
        int value = this.slider.getValue();
        ScribbleTool.smoothness = (double)value / 100.0;
    }
}

