/*
 * Decompiled with CFR 0.152.
 */
package CH.ifa.draw.standard;

import CH.ifa.draw.DrawPlugin;
import CH.ifa.draw.framework.ChildFigure;
import CH.ifa.draw.framework.DrawingEditor;
import CH.ifa.draw.framework.DrawingView;
import CH.ifa.draw.framework.Figure;
import CH.ifa.draw.framework.Handle;
import CH.ifa.draw.framework.PartialSelectableFigure;
import CH.ifa.draw.framework.Tool;
import CH.ifa.draw.standard.AbstractTool;
import CH.ifa.draw.standard.ChildDragTracker;
import CH.ifa.draw.standard.DragTracker;
import CH.ifa.draw.standard.HandleTracker;
import CH.ifa.draw.standard.SelectAreaTracker;
import de.renew.util.StringUtil;
import java.awt.Desktop;
import java.awt.Graphics;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import org.apache.log4j.Logger;

public class SelectionTool
extends AbstractTool {
    public static Logger logger = Logger.getLogger(SelectionTool.class);
    private Tool fChild = null;
    private Tool fLastChild = null;
    private DrawingView fFreezedView = null;

    public SelectionTool(DrawingEditor editor) {
        super(editor);
    }

    @Override
    public void mouseDown(MouseEvent e, int x, int y) {
        if (this.fChild != null) {
            return;
        }
        try {
            boolean rightclick;
            boolean bl = rightclick = (e.getModifiersEx() & 0x1800) != 0;
            if (this.fLastChild != null && e.getClickCount() == 2 && !rightclick) {
                this.fChild = this.fLastChild;
                this.fLastChild = null;
            } else {
                if (this.fFreezedView == null) {
                    this.fFreezedView = this.view();
                    this.fFreezedView.freezeView();
                }
                Handle handle = null;
                if (!rightclick && this.view().selectionCount() == 1) {
                    handle = this.view().findHandle(x, y);
                }
                if (handle != null) {
                    this.fLastChild = this.fChild = this.createHandleTracker(this.fEditor, handle);
                } else {
                    this.fLastChild = null;
                    Figure figure = this.drawing().findFigure(x, y);
                    if (figure == null && (handle = this.view().findHandle(x, y)) != null) {
                        figure = handle.owner();
                    }
                    boolean selectableFigureFound = false;
                    if (figure != null) {
                        selectableFigureFound = true;
                        if (figure instanceof PartialSelectableFigure && !this.view().selection().contains(figure)) {
                            selectableFigureFound = false;
                            PartialSelectableFigure partialSelectableFigure = (PartialSelectableFigure)((Object)figure);
                            if (partialSelectableFigure.isModifierSelectable() && e.isAltDown()) {
                                selectableFigureFound = true;
                            } else if (partialSelectableFigure.isSelectableInRegion(x, y)) {
                                selectableFigureFound = true;
                            }
                        }
                    }
                    if (selectableFigureFound) {
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)("Click-on-figure: " + String.valueOf(figure)));
                        }
                        if (e.isControlDown()) {
                            if (!rightclick) {
                                this.openTargetLocation(figure);
                            }
                        } else {
                            if (e.getClickCount() >= 2 && !rightclick) {
                                figure.inspect(this.view(), false);
                                return;
                            }
                            if (rightclick && this.alternateInspectFigure(figure)) {
                                return;
                            }
                            this.fChild = this.createDragTracker(this.fEditor, figure);
                        }
                    } else {
                        if (!e.isShiftDown()) {
                            this.view().clearSelection();
                        }
                        this.fChild = this.createAreaTracker(this.fEditor);
                    }
                }
            }
            if (this.fChild != null) {
                if (this.fChild instanceof DragTracker || this.fChild instanceof ChildDragTracker || this.fChild instanceof SelectAreaTracker) {
                    this.fChild.mouseDown(e, x, y);
                } else {
                    this.fChild.mouseDown(e, e.getX(), e.getY());
                }
            }
        }
        catch (RuntimeException ex) {
            if (this.fFreezedView != null) {
                this.fFreezedView.unfreezeView();
                this.fFreezedView = null;
            }
            throw ex;
        }
        catch (Error ex) {
            if (this.fFreezedView != null) {
                this.fFreezedView.unfreezeView();
                this.fFreezedView = null;
            }
            throw ex;
        }
    }

    private void openTargetLocation(Figure figure) {
        block11: {
            Object target = figure.getAttribute("targetLocation");
            if (target != null) {
                try {
                    URI targetURI = new URI((String)target);
                    try {
                        String scheme = targetURI.getScheme();
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)(SelectionTool.class.getSimpleName() + ": Trying to open: Scheme | Host | Path = " + scheme + " | " + targetURI.getHost() + " | " + targetURI.getPath()));
                        }
                        if (scheme == null && !DrawPlugin.getGui().canOpen(targetURI)) {
                            scheme = "file";
                            targetURI = new URI(scheme, targetURI.getHost(), targetURI.getPath(), targetURI.getFragment());
                        }
                        if (scheme == null) {
                            URI drawingURI = new File(this.drawing().getFilename().getCanonicalPath()).toURI();
                            URI uri = drawingURI.resolve(targetURI);
                            DrawPlugin.getGui().openOrLoadDrawing(new File(uri.getPath()));
                            break block11;
                        }
                        if ("sim".equals(scheme)) {
                            this.simAccess(targetURI);
                            break block11;
                        }
                        Desktop.getDesktop().browse(targetURI);
                    }
                    catch (URISyntaxException urise) {
                        URI drawingURI = new File(this.drawing().getFilename().getCanonicalPath()).toURI();
                        String path = StringUtil.getPath((String)drawingURI.getPath());
                        Desktop.getDesktop().open(new File(path, (String)target));
                    }
                    catch (IOException e2) {
                        logger.error((Object)("Could not find file: " + targetURI.getPath() + " " + e2.getMessage()));
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)(SelectionTool.class.getSimpleName() + ": "), (Throwable)e2);
                        }
                    }
                }
                catch (Exception e3) {
                    logger.error((Object)("An error occured during file access (malformed URL?): " + e3.getMessage()));
                    if (!logger.isDebugEnabled()) break block11;
                    logger.debug((Object)(SelectionTool.class.getSimpleName() + ": "), (Throwable)e3);
                }
            }
        }
    }

    @Override
    public void mouseDrag(MouseEvent e, int x, int y) {
        if (this.fChild != null) {
            this.fChild.mouseDrag(e, x, y);
            this.fLastChild = null;
        }
    }

    @Override
    public void mouseUp(MouseEvent e, int x, int y) {
        if (this.fFreezedView != null) {
            this.fFreezedView.unfreezeView();
            this.fFreezedView = null;
        }
        if (this.fChild != null) {
            this.fChild.mouseUp(e, x, y);
        }
        this.fChild = null;
    }

    protected Tool createHandleTracker(DrawingEditor editor, Handle handle) {
        return new HandleTracker(editor, handle);
    }

    protected Tool createDragTracker(DrawingEditor editor, Figure f) {
        if (f instanceof ChildFigure) {
            return new ChildDragTracker(editor, (ChildFigure)f);
        }
        return new DragTracker(editor, f);
    }

    protected Tool createAreaTracker(DrawingEditor editor) {
        return new SelectAreaTracker(editor);
    }

    protected boolean alternateInspectFigure(Figure f) {
        return f.inspect(this.view(), true);
    }

    @Override
    public void draw(Graphics g) {
        if (this.fChild != null) {
            this.fChild.draw(g);
        }
    }

    @Override
    public void deactivate() {
        if (this.fFreezedView != null) {
            this.fFreezedView.unfreezeView();
            this.fFreezedView = null;
        }
        super.deactivate();
    }
}

