/*
 * Decompiled with CFR 0.152.
 */
package CH.ifa.draw.standard;

import CH.ifa.draw.framework.ConnectionFigure;
import CH.ifa.draw.framework.DrawingView;
import CH.ifa.draw.framework.Figure;
import CH.ifa.draw.framework.FigureEnumeration;
import CH.ifa.draw.framework.FigureFilter;
import CH.ifa.draw.framework.UndoableCommand;
import CH.ifa.draw.standard.FilteredFigureEnumerator;
import CH.ifa.draw.util.Geom;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;

public class SpreadCommand
extends UndoableCommand {
    public static final int LEFTS = 0;
    public static final int CENTERS = 1;
    public static final int RIGHTS = 2;
    public static final int TOPS = 3;
    public static final int MIDDLES = 4;
    public static final int BOTTOMS = 5;
    public static final int HORIZONTAL_DISTANCE = 6;
    public static final int VERTICAL_DISTANCE = 7;
    public static final int DIAGONAL_CENTERS = 8;
    private static final int DIAGONAL_DISTANCE = 9;
    private int fOp;

    public SpreadCommand(String name, int op) {
        super(name);
        this.fOp = op;
    }

    @Override
    public boolean isExecutable() {
        if (!super.isExecutable()) {
            return false;
        }
        return this.getEditor().view().selectionCount() > 2;
    }

    @Override
    public boolean executeUndoable() {
        if (this.isExecutable()) {
            Iterator sortedIter;
            if (!super.isExecutable()) {
                return false;
            }
            DrawingView view = this.getEditor().view();
            FigureEnumeration selection = view.selectionElements();
            selection = new FilteredFigureEnumerator(selection, new ConnectionFilter());
            LinkedList<SortPair> sortedList = new LinkedList<SortPair>();
            Rectangle bBox = null;
            while (selection.hasMoreElements()) {
                SortPair currentFigurePair = new SortPair(this.fOp, selection.nextFigure());
                if (bBox == null) {
                    bBox = new Rectangle(currentFigurePair.hotspot);
                } else {
                    bBox.add(currentFigurePair.hotspot);
                }
                sortedList.add(0, currentFigurePair);
            }
            if (sortedList.size() < 3) {
                return false;
            }
            if (this.fOp != 8 && this.fOp != 9) {
                Collections.sort(sortedList, new HotspotComparator(this.fOp));
            } else {
                SortPair firstPair;
                Point bBoxCenter = Geom.center(bBox);
                Collections.sort(sortedList, new DistanceComparator(bBoxCenter));
                sortedIter = sortedList.iterator();
                SortPair secondPair = firstPair = (SortPair)sortedIter.next();
                SortPair currentPair = firstPair;
                if (bBox != null) {
                    int minDistance = (bBox.width > bBox.height ? bBox.width : bBox.height) / 2;
                    long minDistance2 = minDistance * minDistance;
                    long foundDistance2 = 0L;
                    long currentDistance2 = 0L;
                    while (sortedIter.hasNext() && currentPair.distance2(bBoxCenter) >= minDistance2) {
                        currentPair = (SortPair)sortedIter.next();
                        currentDistance2 = currentPair.distance2(firstPair.hotspot);
                        if (foundDistance2 >= currentDistance2) continue;
                        foundDistance2 = currentDistance2;
                        secondPair = currentPair;
                    }
                    Collections.sort(sortedList, new ProjectionComparator(firstPair.hotspot, secondPair.hotspot));
                }
            }
            int wholeLengthX = 0;
            int wholeLengthY = 0;
            int firstIndex = 0;
            int lastIndex = sortedList.size() - 1;
            sortedIter = sortedList.iterator();
            switch (this.fOp) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 8: {
                    wholeLengthX = ((SortPair)sortedList.get((int)lastIndex)).hotspot.x - ((SortPair)sortedList.get((int)firstIndex)).hotspot.x;
                    wholeLengthY = ((SortPair)sortedList.get((int)lastIndex)).hotspot.y - ((SortPair)sortedList.get((int)firstIndex)).hotspot.y;
                    break;
                }
                case 6: 
                case 7: {
                    Rectangle currentBox;
                    Rectangle prevBox = ((SortPair)sortedIter.next()).figure.displayBox();
                    while (sortedIter.hasNext()) {
                        currentBox = ((SortPair)sortedIter.next()).figure.displayBox();
                        wholeLengthX += currentBox.x - prevBox.x - prevBox.width;
                        wholeLengthY += currentBox.y - prevBox.y - prevBox.height;
                        prevBox = currentBox;
                    }
                    break;
                }
                case 9: {
                    Rectangle currentBox;
                    wholeLengthX = ((SortPair)sortedList.get((int)lastIndex)).hotspot.x - ((SortPair)sortedList.get((int)firstIndex)).hotspot.x;
                    wholeLengthY = ((SortPair)sortedList.get((int)lastIndex)).hotspot.y - ((SortPair)sortedList.get((int)firstIndex)).hotspot.y;
                    Rectangle prevBox = ((SortPair)sortedIter.next()).figure.displayBox();
                    while (sortedIter.hasNext()) {
                        currentBox = ((SortPair)sortedIter.next()).figure.displayBox();
                        wholeLengthX -= prevBox.width;
                        wholeLengthY -= prevBox.height;
                        prevBox = currentBox;
                    }
                    break;
                }
            }
            Point shouldSpot = null;
            Point firstSpot = ((SortPair)sortedList.get((int)0)).hotspot;
            int nodeCount = 0;
            int intervals = sortedList.size() - 1;
            SortPair prevFigurePair = null;
            for (SortPair currentFigurePair : sortedList) {
                switch (this.fOp) {
                    case 0: 
                    case 1: 
                    case 2: {
                        shouldSpot = new Point(firstSpot.x + wholeLengthX * nodeCount / intervals, currentFigurePair.hotspot.y);
                        break;
                    }
                    case 3: 
                    case 4: 
                    case 5: {
                        shouldSpot = new Point(currentFigurePair.hotspot.x, firstSpot.y + wholeLengthY * nodeCount / intervals);
                        break;
                    }
                    case 8: {
                        shouldSpot = new Point(firstSpot.x + wholeLengthX * nodeCount / intervals, firstSpot.y + wholeLengthY * nodeCount / intervals);
                        break;
                    }
                    case 6: 
                    case 7: 
                    case 9: {
                        if (prevFigurePair != null) {
                            int distanceToAddX = wholeLengthX * nodeCount / intervals - wholeLengthX * (nodeCount - 1) / intervals;
                            int distanceToAddY = wholeLengthY * nodeCount / intervals - wholeLengthY * (nodeCount - 1) / intervals;
                            switch (this.fOp) {
                                case 6: {
                                    shouldSpot = new Point(prevFigurePair.hotspot.x + prevFigurePair.figure.displayBox().width + distanceToAddX, currentFigurePair.hotspot.y);
                                    break;
                                }
                                case 7: {
                                    shouldSpot = new Point(currentFigurePair.hotspot.x, prevFigurePair.hotspot.y + prevFigurePair.figure.displayBox().height + distanceToAddY);
                                    break;
                                }
                                case 9: {
                                    shouldSpot = new Point(prevFigurePair.hotspot.x + (wholeLengthX >= 0 ? prevFigurePair.figure.displayBox().width : currentFigurePair.figure.displayBox().width) + distanceToAddX, prevFigurePair.hotspot.y + (wholeLengthY >= 0 ? prevFigurePair.figure.displayBox().height : currentFigurePair.figure.displayBox().height) + distanceToAddY);
                                }
                            }
                            break;
                        }
                        shouldSpot = currentFigurePair.hotspot;
                    }
                }
                if (shouldSpot != null) {
                    currentFigurePair.figure.moveBy(shouldSpot.x - currentFigurePair.hotspot.x, shouldSpot.y - currentFigurePair.hotspot.y);
                    prevFigurePair = new SortPair(this.fOp, currentFigurePair.figure);
                }
                ++nodeCount;
            }
            view.checkDamage();
            return true;
        }
        return false;
    }

    private class ConnectionFilter
    implements FigureFilter {
        private ConnectionFilter() {
        }

        @Override
        public boolean isUsed(Figure figure) {
            return !(figure instanceof ConnectionFigure);
        }
    }

    private class SortPair {
        public final Figure figure;
        public final Point hotspot;

        public SortPair(int op, Figure figure) {
            Point newHotspot = null;
            switch (op) {
                case 0: 
                case 3: 
                case 6: 
                case 7: {
                    newHotspot = figure.displayBox().getLocation();
                    break;
                }
                case 2: 
                case 5: {
                    newHotspot = new Point(figure.displayBox().x + figure.displayBox().width, figure.displayBox().y + figure.displayBox().height);
                    break;
                }
                case 1: 
                case 4: 
                case 8: {
                    newHotspot = Geom.center(figure.displayBox());
                }
            }
            this.figure = figure;
            this.hotspot = newHotspot;
        }

        public long distance2(Point origin) {
            return Geom.length2(origin.x, origin.y, this.hotspot.x, this.hotspot.y);
        }
    }

    private class HotspotComparator
    implements Comparator<SortPair> {
        private int fOp;

        public HotspotComparator(int op) {
            this.fOp = op;
        }

        @Override
        public int compare(SortPair fst, SortPair snd) {
            SortPair fstPair = fst;
            SortPair sndPair = snd;
            switch (this.fOp) {
                case 0: 
                case 1: 
                case 2: 
                case 6: {
                    return fstPair.hotspot.x - sndPair.hotspot.x;
                }
                case 3: 
                case 4: 
                case 5: 
                case 7: {
                    return fstPair.hotspot.y - sndPair.hotspot.y;
                }
            }
            throw new RuntimeException("SpreadCommand: Comparator: Illegal operation mode " + this.fOp + "!");
        }
    }

    private class DistanceComparator
    implements Comparator<SortPair> {
        private Point origin;

        public DistanceComparator(Point origin) {
            this.origin = origin;
        }

        @Override
        public int compare(SortPair fst, SortPair snd) {
            SortPair fstPair = fst;
            SortPair sndPair = snd;
            long difference = sndPair.distance2(this.origin) - fstPair.distance2(this.origin);
            if (difference < 0L) {
                return -1;
            }
            if (difference > 0L) {
                return 1;
            }
            return 0;
        }
    }

    private class ProjectionComparator
    implements Comparator<SortPair> {
        private float xl;
        private float yl;
        private float denominator;

        public ProjectionComparator(Point origin, Point second) throws ArithmeticException {
            float distance = (float)Math.sqrt(Geom.length2(origin.x, origin.y, second.x, second.y));
            if (distance == 0.0f) {
                throw new ArithmeticException("Projection line end points are too near!");
            }
            this.xl = (float)(second.x - origin.x) / distance;
            this.yl = (float)(second.y - origin.y) / distance;
            this.denominator = this.xl * this.xl + this.yl * this.yl;
        }

        @Override
        public int compare(SortPair fst, SortPair snd) {
            SortPair fstPair = fst;
            SortPair sndPair = snd;
            float i1 = (float)fstPair.hotspot.x * this.xl + (float)fstPair.hotspot.y * this.yl / this.denominator;
            float i2 = (float)sndPair.hotspot.x * this.xl + (float)sndPair.hotspot.y * this.yl / this.denominator;
            if (i1 > i2) {
                return 1;
            }
            if (i1 < i2) {
                return -1;
            }
            return 0;
        }
    }
}

