/*
 * Decompiled with CFR 0.152.
 */
package CH.ifa.draw.standard;

import CH.ifa.draw.framework.Drawing;
import CH.ifa.draw.framework.DrawingChangeEvent;
import CH.ifa.draw.framework.DrawingChangeListener;
import CH.ifa.draw.framework.Figure;
import CH.ifa.draw.framework.FigureChangeEvent;
import CH.ifa.draw.framework.FigureEnumeration;
import CH.ifa.draw.framework.FigureWithID;
import CH.ifa.draw.framework.FilterContainer;
import CH.ifa.draw.framework.Handle;
import CH.ifa.draw.io.IFAFileFilter;
import CH.ifa.draw.io.SimpleFileFilter;
import CH.ifa.draw.standard.CompositeFigure;
import CH.ifa.draw.standard.NullHandle;
import CH.ifa.draw.standard.RelativeLocator;
import CH.ifa.draw.util.StorableInput;
import CH.ifa.draw.util.StorableOutput;
import bibliothek.gui.dock.common.MultipleCDockableLayout;
import bibliothek.util.xml.XElement;
import de.renew.util.Lock;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Vector;
import org.apache.log4j.Logger;

public class StandardDrawing
extends CompositeFigure
implements Drawing,
MultipleCDockableLayout {
    public static Logger logger = Logger.getLogger(StandardDrawing.class);
    private static FilterContainer filterContainer;
    static String fgUntitled;
    private static final long serialVersionUID = -2602151437447962046L;
    private transient Vector<DrawingChangeListener> fListeners;
    private transient Lock fLock;
    private String fDrawingName = fgUntitled;
    private transient File fDrawingFilename = null;
    private transient boolean modified = false;
    private transient boolean fBackupStatus = false;
    private int drawingSerializedDataVersion = 1;
    protected transient int maxUsedID = 0;
    protected transient Hashtable<Integer, Figure> usedIDs = new Hashtable();

    public StandardDrawing() {
        this.fListeners = new Vector(2);
        this.fLock = new Lock();
    }

    @Override
    public String getName() {
        return this.fDrawingName;
    }

    @Override
    public void setName(String name) {
        this.fDrawingName = name;
    }

    public Dimension getSize() {
        return new Dimension(this.getBounds().width, this.getBounds().height);
    }

    @Override
    public File getFilename() {
        return this.fDrawingFilename;
    }

    @Override
    public void setFilename(File filename) {
        this.fDrawingFilename = filename;
    }

    @Override
    public boolean getBackupStatus() {
        return this.fBackupStatus;
    }

    @Override
    public void setBackupStatus(boolean status) {
        this.fBackupStatus = status;
    }

    @Override
    public void addDrawingChangeListener(DrawingChangeListener listener) {
        this.fListeners.addElement(listener);
    }

    @Override
    public void removeDrawingChangeListener(DrawingChangeListener listener) {
        this.fListeners.removeElement(listener);
    }

    @Override
    public Enumeration<DrawingChangeListener> drawingChangeListeners() {
        return this.fListeners.elements();
    }

    @Override
    public Figure remove(Figure figure) {
        if (figure instanceof FigureWithID) {
            this.freeID((FigureWithID)figure);
        }
        Figure result = null;
        if (figure.listener() != null) {
            figure.listener().figureRequestRemove(new FigureChangeEvent(figure, null));
            result = figure;
        }
        if (figure instanceof CompositeFigure) {
            this.recomputeIDCache();
        }
        return result;
    }

    @Override
    public void figureRequestRemove(FigureChangeEvent e) {
        Figure figure = e.getFigure();
        if (this.fFigures.contains(figure)) {
            this.modified = true;
            this.fFigures.removeElement(figure);
            figure.removeFromContainer(this);
            figure.release();
        } else {
            logger.error((Object)"Attempt to remove non-existing figure");
        }
    }

    @Override
    public void figureInvalidated(FigureChangeEvent e) {
        this.modified = true;
        if (this.fListeners != null) {
            for (int i = 0; i < this.fListeners.size(); ++i) {
                DrawingChangeListener l = this.fListeners.elementAt(i);
                l.drawingInvalidated(new DrawingChangeEvent(this, e.getInvalidatedRectangle()));
            }
        }
    }

    @Override
    public void figureRequestUpdate(FigureChangeEvent e) {
        if (this.fListeners != null) {
            for (int i = 0; i < this.fListeners.size(); ++i) {
                DrawingChangeListener l = this.fListeners.elementAt(i);
                l.drawingRequestUpdate(new DrawingChangeEvent(this, null));
            }
        }
    }

    @Override
    public synchronized void checkDamage() {
        final StandardDrawing object = this;
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                Enumeration<DrawingChangeListener> each = StandardDrawing.this.fListeners.elements();
                while (each.hasMoreElements()) {
                    DrawingChangeListener l = each.nextElement();
                    l.drawingRequestUpdate(new DrawingChangeEvent(object, null));
                }
            }
        });
    }

    @Override
    public Vector<Handle> handles() {
        Vector<Handle> handles = new Vector<Handle>();
        handles.addElement(new NullHandle(this, RelativeLocator.northWest()));
        handles.addElement(new NullHandle(this, RelativeLocator.northEast()));
        handles.addElement(new NullHandle(this, RelativeLocator.southWest()));
        handles.addElement(new NullHandle(this, RelativeLocator.southEast()));
        return handles;
    }

    @Override
    public Rectangle displayBox() {
        Rectangle box = null;
        FigureEnumeration k = this.figures();
        while (k.hasMoreElements()) {
            Figure f = k.nextFigure();
            if (!f.isVisible()) continue;
            Rectangle r = f.displayBox();
            if (box == null) {
                box = r;
                continue;
            }
            box.add(r);
        }
        if (box == null) {
            return new Rectangle(0, 0, 100, 100);
        }
        return new Rectangle(box.x - 10, box.y - 10, box.width + 20, box.height + 20);
    }

    @Override
    public void basicDisplayBox(Point p1, Point p2) {
    }

    @Override
    public void lock() {
        this.fLock.lock();
    }

    @Override
    public void unlock() {
        this.fLock.unlock();
    }

    private void readObject(ObjectInputStream s) throws ClassNotFoundException, IOException {
        s.defaultReadObject();
        this.fListeners = new Vector(2);
        this.fLock = new Lock();
        this.maxUsedID = 0;
        this.usedIDs = new Hashtable();
        this.recomputeIDCache();
    }

    @Override
    public boolean isModified() {
        return this.modified;
    }

    @Override
    public void clearModified() {
        this.modified = false;
    }

    @Override
    public Rectangle getBounds() {
        return this.displayBox();
    }

    @Override
    public Dimension defaultSize() {
        return new Dimension(430, 406);
    }

    @Override
    public void write(StorableOutput dw) {
        super.write(dw);
    }

    @Override
    public void read(StorableInput dr) throws IOException {
        super.read(dr);
        this.modified = false;
        this.recomputeIDCache();
    }

    @Override
    public String getWindowCategory() {
        return "JHotDrawings";
    }

    public static FilterContainer getFilterContainer() {
        if (filterContainer == null) {
            return new FilterContainer(new IFAFileFilter());
        }
        return filterContainer;
    }

    @Override
    public SimpleFileFilter getDefaultFileFilter() {
        return StandardDrawing.getFilterContainer().getDefaultFileFilter();
    }

    @Override
    public HashSet<SimpleFileFilter> getImportFileFilters() {
        return StandardDrawing.getFilterContainer().getImportFileFilters();
    }

    @Override
    public HashSet<SimpleFileFilter> getExportFileFilters() {
        return StandardDrawing.getFilterContainer().getExportFileFilters();
    }

    @Override
    public String getDefaultExtension() {
        return this.getDefaultFileFilter().getExtension();
    }

    @Override
    public void init() {
    }

    @Override
    public Drawing add(Drawing drawing) {
        FigureEnumeration figures = drawing.figures();
        while (figures.hasMoreElements()) {
            Figure figure = (Figure)figures.nextElement();
            this.add(figure);
        }
        return drawing;
    }

    @Override
    public Drawing add(Drawing drawing, int x, int y) {
        FigureEnumeration figures = drawing.figures();
        while (figures.hasMoreElements()) {
            Figure figure = (Figure)figures.nextElement();
            this.add(figure);
            figure.moveBy(x, y);
        }
        return drawing;
    }

    @Override
    public boolean isStorable() {
        return true;
    }

    public void writeStream(DataOutputStream dataOutputStream) throws IOException {
    }

    public void readStream(DataInputStream dataInputStream) throws IOException {
    }

    public void writeXML(XElement xElement) {
    }

    public void readXML(XElement xElement) {
    }

    @Override
    public Figure add(Figure figure) {
        if (figure instanceof FigureWithID) {
            if (this.maxUsedID == 0) {
                this.recomputeIDCache();
            }
            this.checkAndAssignID((FigureWithID)figure);
        }
        Figure result = super.add(figure);
        if (figure instanceof CompositeFigure) {
            this.recomputeIDCache();
        }
        return result;
    }

    private void checkAndAssignID(FigureWithID figure) {
        int oldID;
        int newID = oldID = figure.getID();
        FigureWithID inCache = (FigureWithID)this.usedIDs.get(oldID);
        if (inCache != null && inCache != figure) {
            newID = 0;
        }
        if (newID == 0) {
            newID = this.newUniqueID();
            figure.setID(newID);
        }
        this.usedIDs.put(newID, figure);
    }

    private int newUniqueID() {
        ++this.maxUsedID;
        if (this.usedIDs.containsKey(this.maxUsedID)) {
            boolean resetOnce = false;
            while (this.usedIDs.containsKey(this.maxUsedID)) {
                ++this.maxUsedID;
                if (this.maxUsedID != Integer.MIN_VALUE) continue;
                this.maxUsedID = 1;
                if (resetOnce) {
                    throw new RuntimeException("Maximum numnber of figures exeeded.");
                }
                resetOnce = true;
            }
        }
        return this.maxUsedID;
    }

    protected void recomputeIDCache() {
        Vector<Figure> offendingFigures = new Vector<Figure>();
        this.usedIDs.clear();
        this.addToIDCache(this, offendingFigures);
        Enumeration<Figure> figureList = offendingFigures.elements();
        while (figureList.hasMoreElements()) {
            this.checkAndAssignID((FigureWithID)figureList.nextElement());
        }
    }

    private void addToIDCache(CompositeFigure container, Vector<Figure> offendingFigures) {
        FigureEnumeration knownFigures = container.figures();
        while (knownFigures.hasMoreElements()) {
            Figure figure = knownFigures.nextFigure();
            if (figure instanceof FigureWithID) {
                int usedID = ((FigureWithID)figure).getID();
                if (usedID == 0) {
                    offendingFigures.addElement(figure);
                    continue;
                }
                FigureWithID inCache = (FigureWithID)this.usedIDs.get(usedID);
                if (inCache == null || inCache == figure) {
                    this.usedIDs.put(usedID, figure);
                    if (usedID <= this.maxUsedID) continue;
                    this.maxUsedID = usedID;
                    continue;
                }
                offendingFigures.addElement(figure);
                continue;
            }
            if (!(figure instanceof CompositeFigure)) continue;
            this.addToIDCache((CompositeFigure)figure, offendingFigures);
        }
    }

    public void assignID(FigureWithID figure, int id) {
        FigureWithID inCache = (FigureWithID)this.usedIDs.get(id);
        if (inCache != null && inCache != figure) {
            throw new IllegalArgumentException("The id is already in use!");
        }
        this.usedIDs.remove(figure.getID());
        figure.setID(id);
        this.usedIDs.put(id, figure);
    }

    private void freeID(FigureWithID figure) {
        Integer usedID = figure.getID();
        if (this.usedIDs.get(usedID) == figure) {
            this.usedIDs.remove(usedID);
        }
    }

    public FigureWithID getFigureWithID(int id) {
        return (FigureWithID)this.usedIDs.get(id);
    }

    static {
        fgUntitled = "untitled";
    }
}

