/*
 * Decompiled with CFR 0.152.
 */
package CH.ifa.draw.standard;

import CH.ifa.draw.standard.StringMatcher;

public class SubstringMatcher
implements StringMatcher {
    private String replaceString;
    private String searchString;
    private int lastposition;

    public int getLastposition() {
        return this.lastposition;
    }

    public void setLastposition(int lastposition) {
        this.lastposition = lastposition;
    }

    public SubstringMatcher(String searchString, String replaceString) {
        this.searchString = searchString;
        this.replaceString = replaceString;
    }

    @Override
    public boolean matches(String compareString, boolean ignoreCase) {
        boolean found = false;
        for (int i = 0; i < compareString.length() && !found; ++i) {
            found = compareString.regionMatches(ignoreCase, i, this.searchString, 0, this.searchString.length());
            this.setLastposition(i);
        }
        return found;
    }

    public boolean matches(String compareString, int fromIndex, boolean ignoreCase) {
        boolean found = false;
        for (int i = fromIndex; i < compareString.length() && !found; ++i) {
            found = compareString.regionMatches(ignoreCase, i, this.searchString, 0, this.searchString.length());
        }
        return found;
    }

    @Override
    public String replacement(String compareString) {
        String s1 = null;
        String s2 = null;
        boolean found = false;
        boolean ignoreCase = true;
        for (int i = 0; i < compareString.length() && !found; ++i) {
            found = compareString.regionMatches(true, i, this.searchString, 0, this.searchString.length());
            if (!found) continue;
            s1 = compareString.substring(0, i);
            s2 = compareString.substring(i + this.searchString.length(), compareString.length());
        }
        if (found) {
            return s1 + this.replaceString + s2;
        }
        return compareString;
    }

    public String replacement(String compareString, int fromIndex) {
        String s1 = null;
        String s2 = null;
        boolean found = false;
        boolean ignoreCase = true;
        for (int i = fromIndex; i < compareString.length() && !found; ++i) {
            found = compareString.regionMatches(true, i, this.searchString, 0, this.searchString.length());
            if (!found) continue;
            s1 = compareString.substring(0, i);
            s2 = compareString.substring(i + this.searchString.length(), compareString.length());
        }
        if (found) {
            return s1 + this.replaceString + s2;
        }
        return compareString;
    }

    public int indexOf(String compareString, int fromIndex) {
        boolean ignoreCase = true;
        for (int i = fromIndex; i < compareString.length(); ++i) {
            if (!compareString.regionMatches(true, i, this.searchString, 0, this.searchString.length())) continue;
            return i;
        }
        return -1;
    }

    public String getSearchString() {
        return this.searchString;
    }

    public String getReplaceString() {
        return this.replaceString;
    }
}

