/*
 * Decompiled with CFR 0.152.
 */
package de.renew.formalism.efsnet;

import collections.CollectionEnumeration;
import collections.HashedSet;
import collections.UpdatableSet;
import de.renew.expression.Function;
import de.renew.formalism.efsnet.EFSNetConstants;
import de.renew.formalism.efsnet.SingleEFSNetCompiler;
import de.renew.formalism.efsnet.ValueMarkingFunction;
import de.renew.unify.Impossible;
import de.uni_hamburg.fs.FSNode;
import de.uni_hamburg.fs.FeatureStructure;
import de.uni_hamburg.fs.Name;
import de.uni_hamburg.fs.Node;
import de.uni_hamburg.fs.UnificationFailure;
import org.apache.log4j.Logger;

public class ProcessRuleFunction
implements Function,
EFSNetConstants {
    public static final Logger LOGGER = Logger.getLogger(ProcessRuleFunction.class);
    private boolean _valueSem;
    private FeatureStructure _processRule;

    public ProcessRuleFunction(boolean valueSem, FeatureStructure processRule) {
        this._valueSem = valueSem;
        this._processRule = processRule;
    }

    public Object function(Object param) throws Impossible {
        if (param instanceof FeatureStructure) {
            ProcessRuleFunction.scut((FeatureStructure)param);
            return ProcessRuleFunction.applyRule(this._valueSem, (FeatureStructure)param, this._processRule);
        }
        throw new Impossible("Argument of ProcessRuleFunction was not a Feature Structure!");
    }

    public static FeatureStructure applyRule(boolean valueSem, FeatureStructure proc, FeatureStructure rule) throws Impossible {
        FeatureStructure nextProc = null;
        try {
            nextProc = ProcessRuleFunction.scut(proc).unify(rule);
        }
        catch (UnificationFailure uff) {
            throw new Impossible();
        }
        try {
            nextProc = valueSem ? nextProc.unify(ValueMarkingFunction.valmark(nextProc.at(PATH_POST)), PATH_POSTC) : nextProc.equate(PATH_POST, PATH_POSTC);
            return nextProc.at(PATH_PROC);
        }
        catch (UnificationFailure uff) {
            LOGGER.error((Object)"Unexpected unification failure in ProcessRuleFunction.applyRule().");
            return null;
        }
    }

    public static FeatureStructure scut(FeatureStructure p) {
        String netSpace = SingleEFSNetCompiler.getNamespace(p.getType());
        FSNode scut = null;
        try {
            scut = new FSNode(netSpace + "PEff");
            scut.setFeature(FEAT_PRE, new FSNode(netSpace + "M"));
        }
        catch (UnificationFailure uff) {
            LOGGER.error((Object)("Type " + netSpace + "PEff or M not found!"));
            return null;
        }
        scut.setFeature(FEAT_PROC, p.getRoot());
        ProcessRuleFunction.findTokens(p.getRoot(), scut, (UpdatableSet)new HashedSet());
        return new FeatureStructure(scut);
    }

    private static void findTokens(Node proc, Node scut, UpdatableSet visited) {
        if (visited.includes((Object)proc)) {
            return;
        }
        visited.include((Object)proc);
        Node procM = proc.delta(FEAT_M);
        Node scutPre = scut.delta(FEAT_PRE);
        CollectionEnumeration prodTokens = procM.featureNames();
        while (prodTokens.hasMoreElements()) {
            Name prodToken = (Name)prodTokens.nextElement();
            if (proc.hasFeature(prodToken)) continue;
            if (scut.hasFeature(prodToken)) {
                throw new RuntimeException("More than one token on place " + String.valueOf(prodToken) + "!");
            }
            scut.setFeature(prodToken, proc);
            scutPre.setFeature(prodToken, procM.delta(prodToken));
        }
        CollectionEnumeration consTokens = proc.featureNames();
        while (consTokens.hasMoreElements()) {
            Name consToken = (Name)consTokens.nextElement();
            if (consToken.equals(FEAT_M)) continue;
            ProcessRuleFunction.findTokens(proc.delta(consToken), scut, visited);
        }
    }
}

