/*
 * Decompiled with CFR 0.152.
 */
package de.renew.formalism.efsnet;

import collections.CollectionEnumeration;
import collections.HashedSet;
import collections.UpdatableSet;
import de.renew.expression.Function;
import de.renew.formalism.efsnet.EFSNetConstants;
import de.renew.formalism.efsnet.SingleEFSNetCompiler;
import de.renew.unify.Impossible;
import de.uni_hamburg.fs.EquivRelation;
import de.uni_hamburg.fs.FSNode;
import de.uni_hamburg.fs.FeatureStructure;
import de.uni_hamburg.fs.Name;
import de.uni_hamburg.fs.Node;
import de.uni_hamburg.fs.UnificationFailure;
import org.apache.log4j.Logger;

public class SCutFunction
implements Function,
EFSNetConstants {
    public static final Logger LOGGER = Logger.getLogger(SCutFunction.class);
    public static final SCutFunction VALUE_SEMANTICS = new SCutFunction(true);
    public static final SCutFunction REFERENCE_SEMANTICS = new SCutFunction(false);
    private boolean _valueSem;

    private SCutFunction(boolean valueSem) {
        this._valueSem = valueSem;
    }

    public static SCutFunction instance(boolean valueSem) {
        return valueSem ? VALUE_SEMANTICS : REFERENCE_SEMANTICS;
    }

    public Object function(Object param) throws Impossible {
        if (param instanceof FeatureStructure) {
            return SCutFunction.scut((FeatureStructure)param, this._valueSem);
        }
        throw new Impossible("Argument of SCutFunction was not a Feature Structure!");
    }

    public static FeatureStructure scut(FeatureStructure p, boolean valueSem) {
        String netSpace = SingleEFSNetCompiler.getNamespace(p.getType());
        FSNode scut = null;
        try {
            scut = new FSNode(netSpace + "PEff");
            scut.setFeature(FEAT_PRE, new FSNode(netSpace + "M"));
        }
        catch (UnificationFailure uff) {
            LOGGER.error((Object)("Type " + netSpace + "PEff or M not found!"));
            return null;
        }
        scut.setFeature(FEAT_PROC, p.getRoot());
        SCutFunction.findTokens(p.getRoot(), scut, valueSem, (UpdatableSet)new HashedSet());
        return new FeatureStructure(scut);
    }

    private static void findTokens(Node proc, Node scut, boolean valueSem, UpdatableSet visited) {
        if (visited.includes((Object)proc)) {
            return;
        }
        visited.include((Object)proc);
        Node procM = proc.delta(FEAT_M);
        Node scutPre = scut.delta(FEAT_PRE);
        CollectionEnumeration prodTokens = procM.featureNames();
        while (prodTokens.hasMoreElements()) {
            Name prodToken = (Name)prodTokens.nextElement();
            if (proc.hasFeature(prodToken)) continue;
            if (scut.hasFeature(prodToken)) {
                throw new RuntimeException("More than one token on place " + String.valueOf(prodToken) + "!");
            }
            scut.setFeature(prodToken, proc);
            Node token = procM.delta(prodToken);
            if (valueSem) {
                token = EquivRelation.deepCopy(token);
            }
            scutPre.setFeature(prodToken, token);
        }
        CollectionEnumeration consTokens = proc.featureNames();
        while (consTokens.hasMoreElements()) {
            Name consToken = (Name)consTokens.nextElement();
            if (consToken.equals(FEAT_M)) continue;
            SCutFunction.findTokens(proc.delta(consToken), scut, valueSem, visited);
        }
    }
}

