/*
 * Decompiled with CFR 0.152.
 */
package de.renew.formalism.fs;

import collections.CollectionEnumeration;
import de.renew.application.SimulatorPlugin;
import de.renew.formalism.fs.ObjectNetInstance;
import de.renew.net.NetNotFoundException;
import de.renew.unify.Impossible;
import de.renew.unify.Tuple;
import de.uni_hamburg.fs.ConjunctiveType;
import de.uni_hamburg.fs.FSNode;
import de.uni_hamburg.fs.FeatureStructure;
import de.uni_hamburg.fs.Name;
import de.uni_hamburg.fs.Node;
import de.uni_hamburg.fs.Type;
import de.uni_hamburg.fs.TypeException;
import de.uni_hamburg.fs.TypeSystem;
import de.uni_hamburg.fs.UnificationFailure;
import java.util.Hashtable;
import java.util.Vector;
import org.apache.log4j.Logger;

public class MarkingNetInstance
extends ObjectNetInstance {
    public static final Logger LOGGER = Logger.getLogger(MarkingNetInstance.class);

    public MarkingNetInstance(FeatureStructure fs, boolean confirm) throws Impossible, NetNotFoundException {
        super((String)fs.at("net").getJavaObject(), MarkingNetInstance.extractMarking(fs));
        if (confirm) {
            this.confirm();
        }
    }

    public MarkingNetInstance(FeatureStructure fs) throws Impossible, NetNotFoundException {
        this(fs, true);
    }

    public MarkingNetInstance confirm() {
        this.createConfirmation(SimulatorPlugin.getCurrent().getCurrentEnvironment().getSimulator().currentStepIdentifier());
        return this;
    }

    private static Vector<Object> vector(Object o) {
        Vector<Object> v = new Vector<Object>();
        v.addElement(o);
        return v;
    }

    public FeatureStructure equateAndFire(FeatureStructure proc, FeatureStructure transition, String[] paths) throws UnificationFailure {
        String path0 = "proc" + paths[0];
        proc = proc.unify(transition, path0);
        for (int i = 1; i < paths.length; ++i) {
            proc = proc.equate(path0, "proc" + paths[i]);
        }
        return proc;
    }

    public FeatureStructure fire(FeatureStructure proc, FeatureStructure transition, Object paths) throws UnificationFailure {
        if (paths instanceof Tuple) {
            return this.equateAndFire(proc, transition, (String[])((Tuple)paths).asArray(String.class));
        }
        return proc.unify(transition, "proc" + String.valueOf(paths));
    }

    private static Hashtable<String, Vector<Object>> extractMarking(FeatureStructure fs) {
        Hashtable<String, Vector<Object>> placeMap = new Hashtable<String, Vector<Object>>();
        FSNode proc = (FSNode)fs.getRoot().delta(new Name("proc"));
        MarkingNetInstance.extractMarking(placeMap, new Vector<Node>(), "", proc);
        placeMap.put("Process", MarkingNetInstance.vector(fs));
        return placeMap;
    }

    private static void extractMarking(Hashtable<String, Vector<Object>> placeMap, Vector<Node> visited, String path, Node curr) {
        if (visited.contains(curr)) {
            return;
        }
        visited.addElement(curr);
        CollectionEnumeration featenumeration = curr.featureNames();
        while (featenumeration.hasMoreElements()) {
            Name featureName = (Name)featenumeration.nextElement();
            String feature = featureName.toString();
            String newpath = path + ":" + feature;
            Node next = curr.delta(featureName);
            if (next.featureNames().hasMoreElements()) {
                MarkingNetInstance.extractMarking(placeMap, visited, newpath, next);
                continue;
            }
            if (placeMap.containsKey(feature)) {
                placeMap.get(feature).addElement(newpath);
                continue;
            }
            placeMap.put(feature, MarkingNetInstance.vector(newpath));
        }
    }

    public static FeatureStructure processMarking(FeatureStructure fs) {
        Type leafType = null;
        Type nodeType = null;
        Type emptyType = null;
        TypeSystem ts = TypeSystem.instance();
        if (!ts.hasConcept("E") || !ts.hasConcept("T")) {
            LOGGER.error((Object)"Type E or T not found!");
            return null;
        }
        FSNode vals = null;
        try {
            emptyType = ConjunctiveType.getType("E");
            nodeType = ConjunctiveType.getType("T");
            if (!ts.hasConcept("Token")) {
                LOGGER.error((Object)"Type Token not found - using type T.");
                leafType = nodeType;
            } else {
                leafType = ConjunctiveType.getType("Token");
                vals = new FSNode("Marking");
            }
        }
        catch (UnificationFailure uff) {
            LOGGER.error((Object)uff.getMessage(), (Throwable)uff);
        }
        try {
            FSNode proc = (FSNode)fs.getRoot();
            FSNode state = new FSNode("State");
            state.setFeature(new Name("proc"), proc);
            FSNode mark = new FSNode("Consumers");
            state.setFeature(new Name("mark"), mark);
            if (vals != null) {
                state.setFeature(new Name("values"), vals);
            }
            MarkingNetInstance.processMarking(new Vector<Node>(), proc, mark, vals, leafType, nodeType);
            CollectionEnumeration featenumeration = mark.getType().appropFeatureNames();
            while (featenumeration.hasMoreElements()) {
                Name feat = (Name)featenumeration.nextElement();
                if (mark.hasFeature(feat)) continue;
                mark.setFeature(feat, new FSNode(emptyType));
            }
            return new FeatureStructure(state);
        }
        catch (TypeException tee) {
            LOGGER.error((Object)"TypeException while processing marking!");
            return null;
        }
        catch (UnificationFailure uff) {
            return null;
        }
    }

    private static void processMarking(Vector<Node> visited, Node curr, FSNode mark, FSNode vals, Type leafType, Type nodeType) throws TypeException {
        if (visited.contains(curr)) {
            return;
        }
        visited.addElement(curr);
        CollectionEnumeration featenumeration = curr.featureNames();
        while (featenumeration.hasMoreElements()) {
            Name featureName = (Name)featenumeration.nextElement();
            if (curr.getType().equals(leafType) && featureName.toString().equals("val")) continue;
            Node next = curr.delta(featureName);
            Type nextType = next.getType();
            if (nextType.equals(leafType)) {
                Name valName = new Name("val");
                if (next.hasFeature(valName)) {
                    Node free;
                    Name consName = new Name("cons");
                    if (!next.hasFeature(consName)) {
                        ((FSNode)next).setFeature(consName, new FSNode(nodeType));
                    }
                    if ((free = next.delta(consName)).getType().equals(nodeType)) {
                        mark.setFeature(featureName, free);
                        vals.setFeature(featureName, next.delta(valName));
                    }
                } else {
                    mark.setFeature(featureName, next);
                }
            }
            if (!leafType.subsumes(nextType) && !nodeType.subsumes(nextType)) continue;
            MarkingNetInstance.processMarking(visited, next, mark, vals, leafType, nodeType);
        }
    }
}

