/*
 * Decompiled with CFR 0.152.
 */
package de.renew.gui.fs;

import CH.ifa.draw.framework.Figure;
import CH.ifa.draw.framework.Handle;
import CH.ifa.draw.standard.RelativeLocator;
import CH.ifa.draw.util.ColorMap;
import CH.ifa.draw.util.Fontkit;
import CH.ifa.draw.util.StorableInput;
import CH.ifa.draw.util.StorableOutput;
import collections.CollectionEnumeration;
import collections.HashedMap;
import collections.HashedSet;
import collections.LinkedList;
import collections.Map;
import collections.UpdatableMap;
import collections.UpdatableSeq;
import collections.UpdatableSet;
import de.renew.formalism.fs.FSNetCompiler;
import de.renew.formalism.fs.FSNetParser;
import de.renew.formalism.fs.FSNetPreprocessor;
import de.renew.formalism.fs.SingleFSNetCompiler;
import de.renew.formalism.java.ParseException;
import de.renew.gui.CPNTextFigure;
import de.renew.gui.NetInstanceHandle;
import de.renew.gui.SemanticUpdateFigure;
import de.renew.gui.fs.BracketSubFigure;
import de.renew.gui.fs.Drawable;
import de.renew.gui.fs.FSPlugin;
import de.renew.gui.fs.FeatureConnectionHandle;
import de.renew.gui.fs.FilledRectSubFigure;
import de.renew.gui.fs.LineSubFigure;
import de.renew.gui.fs.RectSubFigure;
import de.renew.gui.fs.ShutterHandle;
import de.renew.gui.fs.TagHandle;
import de.renew.gui.fs.TextSubFigure;
import de.renew.net.NetInstance;
import de.renew.remote.NetInstanceAccessor;
import de.renew.remote.RemotePlugin;
import de.renew.shadow.ShadowNet;
import de.renew.shadow.SyntaxException;
import de.uni_hamburg.fs.BasicType;
import de.uni_hamburg.fs.EquivRelation;
import de.uni_hamburg.fs.FSNode;
import de.uni_hamburg.fs.FeatureStructure;
import de.uni_hamburg.fs.JavaObject;
import de.uni_hamburg.fs.ListType;
import de.uni_hamburg.fs.Name;
import de.uni_hamburg.fs.Node;
import de.uni_hamburg.fs.NullObject;
import de.uni_hamburg.fs.Path;
import de.uni_hamburg.fs.TagMap;
import de.uni_hamburg.fs.Type;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.StringReader;
import java.util.Enumeration;
import java.util.Vector;
import org.apache.log4j.Logger;

public class FSFigure
extends CPNTextFigure
implements SemanticUpdateFigure {
    public static final Logger LOGGER = Logger.getLogger(FSFigure.class);
    public static final int SHUTTERSIZE = 7;
    public static final String ELLIPSE = "...";
    private transient FSPlugin _fsPlugin = null;
    private transient boolean _alwaysUML = false;
    private transient boolean _automatic = false;
    private transient FeatureStructure _fs;
    private transient TagMap _tagmap;
    private transient FontMetrics _metrics;
    private transient FontMetrics _boldMetrics;
    private transient int _lineh;
    private transient int _d;
    private transient int _ascent;
    private transient Dimension _fExtent = null;
    private transient UpdatableSeq _subfigs = null;
    private transient UpdatableSeq _boldfigs = null;
    private transient UpdatableSet _openNodes = new HashedSet();
    private transient Node _selectedNode = null;
    private transient UpdatableSeq _handles = null;
    private transient int _updateHandleIndex = -1;

    public FSFigure(Object token) {
        this(new FeatureStructure(JavaObject.getJavaType(token)), false);
        this._alwaysUML = true;
    }

    public FSFigure(FeatureStructure fs) {
        this(fs, false);
    }

    public FSFigure(FeatureStructure fs, boolean expanded) {
        super(1);
        this.setFrameColor(Color.black);
        this._fs = fs;
        this._automatic = true;
        this._tagmap = new TagMap(fs.getRoot());
        this.setReadOnly(true);
        super.setText(" ");
        this.setAlignment(0);
        if (expanded) {
            this._openNodes.includeElements(fs.getNodes());
            this._openNodes.include((Object)fs.getRoot());
        }
    }

    public FSFigure() {
        super(1);
        this.setFrameColor(Color.black);
        this.setText("[]");
        this.setReadOnly(false);
    }

    protected void basicSetText(String newText) {
        super.basicSetText(newText);
        if (!this._automatic) {
            try {
                this.semanticUpdate(null);
            }
            catch (SyntaxException se) {
                this._fs = null;
                LOGGER.error((Object)("Syntax Exception in Feature Structure:\n" + String.valueOf((Object)se)));
            }
        }
    }

    FeatureStructure getFeatureStructure() {
        return this._fs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void semanticUpdate(ShadowNet shadowNet) throws SyntaxException {
        if (this._automatic) {
            return;
        }
        FSFigure fSFigure = this;
        synchronized (fSFigure) {
            this._updateHandleIndex = -1;
            SingleFSNetCompiler compiler = new SingleFSNetCompiler();
            FSNetParser fsParser = new FSNetParser(new StringReader(this.getText()));
            if (shadowNet != null) {
                fsParser.setDeclarationNode(compiler.makeDeclarationNode(shadowNet));
            } else {
                fsParser.setDeclarationNode(null);
            }
            HashedMap tags = new HashedMap();
            EquivRelation er = new EquivRelation();
            this._selectedNode = null;
            Node root = null;
            try {
                root = fsParser.parseFS((UpdatableMap)tags, er, Path.EPSILON, new Vector<Path>(), new Vector<Object>());
            }
            catch (ParseException ex) {
                SyntaxException e = FSNetCompiler.makeSyntaxException(ex);
                e.addObject((Object)this);
                this.changed();
                throw e;
            }
            try {
                er.extensionalize();
                root = er.rebuild(root);
            }
            catch (Exception uff) {
                SyntaxException e = new SyntaxException("FS not extensionalizable!", (Throwable)uff);
                e.addObject((Object)this);
                this.changed();
                throw e;
            }
            this._fs = new FeatureStructure(root, false);
            this._tagmap = new TagMap(root, er, (Map)tags);
            this._openNodes = new HashedSet();
            this._openNodes.includeElements(this._fs.getNodes());
            this._openNodes.include((Object)root);
            this.changed();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector<Handle> handles() {
        Vector allHandles = super.handles();
        if (!this._automatic && this._fs != null && this._fs.getFirstMissingAssociation() != null) {
            allHandles.addElement(new FeatureConnectionHandle((Figure)this, RelativeLocator.east()));
        }
        FSFigure fSFigure = this;
        synchronized (fSFigure) {
            if (this._handles != null) {
                CollectionEnumeration handleEnum = this._handles.elements();
                while (handleEnum.hasMoreElements()) {
                    allHandles.addElement((Handle)handleEnum.nextElement());
                }
            }
        }
        return allHandles;
    }

    public static Font getBoldFont(Font font) {
        return Fontkit.getFont((String)font.getName(), (int)(font.getStyle() | 1), (int)font.getSize());
    }

    private void initMetrics() {
        this._metrics = FSFigure.getDefaultFontMetrics((Font)this.getFont());
        this._boldMetrics = FSFigure.getDefaultFontMetrics((Font)FSFigure.getBoldFont(this.getFont()));
        this._lineh = this._metrics.getHeight();
        this._d = this._metrics.stringWidth(" ");
        this._ascent = this._metrics.getAscent() - 1;
    }

    private boolean renderAsUml() {
        if (this._alwaysUML) {
            return true;
        }
        if (this._fsPlugin == null) {
            this._fsPlugin = FSPlugin.getCurrent();
        }
        if (this._fsPlugin != null) {
            return this._fsPlugin.getUmlRenderMode();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setup() {
        boolean umlMode = this.renderAsUml();
        if (this._fExtent == null) {
            FSFigure fSFigure = this;
            synchronized (fSFigure) {
                this._tagmap.resetVisited();
                this.initMetrics();
                this._subfigs = new LinkedList();
                this._boldfigs = new LinkedList();
                if (this._updateHandleIndex < 0) {
                    this._handles = new LinkedList();
                }
                Node root = this._fs.getRoot();
                String tagstr = this._tagmap.getTag(root).toString();
                if (!umlMode && root.getType().equals(Type.TOP) && tagstr.length() > 0) {
                    if (!this._handles.isEmpty()) {
                        this._handles = new LinkedList();
                    }
                    int tagwidth = this._metrics.stringWidth(tagstr) + this._d;
                    this._subfigs.insertFirst((Object)new TextSubFigure(tagstr, (this._d + 1) / 2, this._ascent));
                    this._subfigs.insertFirst((Object)new FilledRectSubFigure(0, 0, tagwidth, this._lineh - 2));
                    this._fExtent = new Dimension(tagwidth, this._lineh - 2);
                    this._updateHandleIndex = -1;
                } else {
                    this._fExtent = this.setupFS(0, 0, root, Type.TOP, umlMode);
                    this._updateHandleIndex = 0;
                }
            }
        }
    }

    public Rectangle displayBox() {
        Rectangle box = super.displayBox();
        if (this._fs == null) {
            return box;
        }
        this.setup();
        return new Rectangle(box.x, box.y, this._fExtent.width, this._fExtent.height);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void internalDraw(Graphics g) {
        if (this._fs == null) {
            super.internalDraw(g);
        } else {
            FSFigure fSFigure = this;
            synchronized (fSFigure) {
                this.setup();
                Rectangle box = super.displayBox();
                Color fill = this.getFillColor();
                if (!ColorMap.isTransparent((Color)fill)) {
                    g.setColor(fill);
                    g.fillRect(box.x, box.y, this._fExtent.width, this._fExtent.height);
                }
                g.setColor((Color)this.getAttribute("TextColor"));
                g.setFont(this.getFont());
                g.translate(box.x, box.y);
                CollectionEnumeration subfigenumeration = this._subfigs.elements();
                while (subfigenumeration.hasMoreElements()) {
                    ((Drawable)subfigenumeration.nextElement()).draw(g);
                }
                g.setFont(FSFigure.getBoldFont(this.getFont()));
                subfigenumeration = this._boldfigs.elements();
                while (subfigenumeration.hasMoreElements()) {
                    ((Drawable)subfigenumeration.nextElement()).draw(g);
                }
                g.translate(-box.x, -box.y);
            }
        }
    }

    private boolean addShutter(Node fs, int x, int y) {
        boolean isClosed = !this._openNodes.includes((Object)fs);
        Rectangle shutterBox = new Rectangle(x - 3, y - 3, 7, 7);
        if (this._updateHandleIndex < 0) {
            this._handles.insertLast((Object)new ShutterHandle(this, shutterBox, fs, isClosed));
        } else {
            ShutterHandle sh = (ShutterHandle)((Object)this._handles.at(this._updateHandleIndex++));
            if (sh._node != fs) {
                LOGGER.error((Object)("test failed: ShutterHandle references " + String.valueOf(sh._node) + " instead of " + String.valueOf(fs)));
            }
            sh.setBox(shutterBox);
            sh._isClosed = isClosed;
        }
        return isClosed;
    }

    private Dimension setupList(int x, int y, int maxh, Node fs, boolean umlMode) {
        int w = 0;
        Type listtype = fs.getType();
        try {
            ListType list = (ListType)listtype;
            Type elemtype = list.getBaseType();
            if (list.getSubtype() == 1 && this._openNodes.includes((Object)fs)) {
                Node head = fs.hasFeature(ListType.HEAD) ? fs.delta(ListType.HEAD) : new FSNode(elemtype);
                Dimension headdim = this.setupFS(x, y, head, elemtype, umlMode);
                maxh = Math.max(maxh, headdim.height);
                w = headdim.width;
                Node tail = fs.hasFeature(ListType.TAIL) ? fs.delta(ListType.TAIL) : new FSNode(ListType.getList(elemtype));
                Dimension taildim = null;
                Name tag = this._tagmap.getTag(tail);
                listtype = tail.getType();
                if (listtype instanceof ListType) {
                    ListType tailtype = (ListType)listtype;
                    if (tailtype.getSubtype() == 1 && tag.equals(Name.EMPTY) && tailtype.getBaseType().equals(elemtype) || tailtype.getSubtype() == 2) {
                        taildim = this.setupList(x + w + 2 * this._d, y, maxh, tail, umlMode);
                        if (taildim.width > 0) {
                            w += 2 * this._d;
                        }
                    }
                    if (taildim == null) {
                        taildim = this.setupFS(x + w + 3 * this._d - 1, y, tail, ListType.getList(elemtype), umlMode);
                        this._subfigs.insertFirst((Object)new LineSubFigure(x + w + 3 * this._d / 2, y, 0, maxh - 1));
                        w += 3 * this._d;
                    }
                    w += taildim.width;
                    maxh = Math.max(maxh, taildim.height);
                }
            }
        }
        catch (ClassCastException cce) {
            LOGGER.error((Object)("!!!corrupted list! Unexpected type: " + String.valueOf(listtype)));
        }
        return new Dimension(w, maxh);
    }

    private Dimension setupFS(int x, int y, Node fs, Type type, boolean umlMode) {
        int subtype;
        if (fs == null) {
            return new Dimension(0, 0);
        }
        int maxh = this._lineh;
        int maxw = 0;
        Type nodetype = fs.getType();
        int left = x;
        int upper = y;
        boolean isNode = (!(nodetype instanceof BasicType) || !((BasicType)nodetype).isObject()) && !(nodetype instanceof NullObject);
        boolean isList = false;
        if (nodetype instanceof ListType && ((subtype = ((ListType)nodetype).getSubtype()) == 2 || subtype == 1) && !this._tagmap.isVisited(fs)) {
            isList = true;
        }
        if (isNode) {
            left += this._d;
            if (isList) {
                left += this._d;
                maxh += 2;
                if (type instanceof ListType) {
                    type = ((ListType)type).getBaseType();
                }
                nodetype = ((ListType)nodetype).getBaseType();
            } else {
                upper += 2;
            }
        }
        boolean noFirstLine = true;
        Rectangle tagbox = null;
        Name tag = this._tagmap.getTag(fs);
        if (!tag.equals(Name.EMPTY)) {
            int tagwidth;
            String tagstr = tag._name;
            if (nodetype instanceof JavaObject && ((JavaObject)nodetype).getJavaObject() instanceof NetInstance) {
                tagstr = ((JavaObject)nodetype).getJavaObject().toString();
            }
            if (umlMode) {
                tagwidth = this._boldMetrics.stringWidth(tagstr);
                if (nodetype.isInstanceType()) {
                    ++maxh;
                    LineSubFigure tagUL = new LineSubFigure(left, upper + this._ascent + 1, tagwidth, 0);
                    this._subfigs.insertFirst((Object)tagUL);
                }
                this._boldfigs.insertFirst((Object)new TextSubFigure(tagstr, left, upper + this._ascent));
            } else {
                tagwidth = this._metrics.stringWidth(tagstr) + this._d;
                this._subfigs.insertFirst((Object)new TextSubFigure(tagstr, left + (this._d + 1) / 2, upper + this._ascent));
                FilledRectSubFigure tagBX = new FilledRectSubFigure(left, upper, tagwidth, this._lineh - 2);
                this._subfigs.insertFirst((Object)tagBX);
            }
            tagbox = new Rectangle(left, upper, tagwidth, this._lineh - 2);
            maxw = tagwidth;
            noFirstLine = false;
        }
        if (!isNode || !this._tagmap.visit(fs)) {
            CollectionEnumeration features;
            boolean hasFeatures;
            if (!isList && nodetype.getName().equals("Link")) {
                int lx = 0;
                if (fs.hasFeature(FSNetPreprocessor.RCV)) {
                    Dimension rcvdim = this.setupFS(x, y, fs.delta(FSNetPreprocessor.RCV), nodetype.appropType(FSNetPreprocessor.RCV), umlMode);
                    maxh = rcvdim.height;
                    lx = rcvdim.width + this._d;
                }
                Dimension subdim = this.setupFS(x + lx + 2 * this._d, y, fs.delta(FSNetPreprocessor.PARAM), nodetype.appropType(FSNetPreprocessor.PARAM), umlMode);
                maxh = Math.max(maxh, subdim.height);
                maxw = lx + subdim.width + 2 * this._d;
                this._subfigs.insertFirst((Object)new TextSubFigure(":", x + lx, y + this._ascent));
                return new Dimension(maxw, maxh);
            }
            Object typestr = "";
            if (!nodetype.equals(type)) {
                typestr = nodetype.getName();
            }
            if (((String)typestr).length() > 0) {
                if (umlMode && isNode) {
                    typestr = ":" + (String)typestr;
                }
                if (!umlMode && !tag.equals(Name.EMPTY)) {
                    maxw += this._d;
                }
                Rectangle typeRect = new Rectangle(left + maxw, upper, this._boldMetrics.stringWidth((String)typestr), this._lineh);
                this._boldfigs.insertFirst((Object)new TextSubFigure((String)typestr, typeRect.x, upper + this._ascent));
                if (isNode && nodetype.isInstanceType()) {
                    this._subfigs.insertFirst((Object)new LineSubFigure(left + maxw, upper + this._ascent + 1, typeRect.width, 0));
                    if (!umlMode) {
                        ++maxh;
                    }
                }
                maxw += typeRect.width;
                noFirstLine = false;
            }
            if (hasFeatures = (features = fs.featureNames()).hasMoreElements()) {
                if (!this._openNodes.includes((Object)fs)) {
                    this._subfigs.insertFirst((Object)new TextSubFigure(ELLIPSE, left + maxw, upper + this._ascent));
                    maxw += this._metrics.stringWidth(ELLIPSE);
                } else {
                    if (noFirstLine) {
                        maxh = 0;
                    } else if (umlMode && !noFirstLine) {
                        ++maxh;
                    }
                    if (isList) {
                        int listdx = 1;
                        int listdy = maxh;
                        if (((String)typestr).length() == 0 && maxw > 0) {
                            listdx = maxw + this._d;
                            listdy = 0;
                        }
                        Dimension listdim = this.setupList(left + listdx, upper + listdy, 0, fs, umlMode);
                        maxw = Math.max(maxw, listdx + listdim.width);
                        maxh = Math.max(maxh, listdy + listdim.height);
                    } else {
                        do {
                            Name featureName = (Name)features.nextElement();
                            String feature = featureName.toString() + (umlMode ? "=" : ": ");
                            int indent = this._metrics.stringWidth(feature);
                            Dimension subdim = this.setupFS(left + indent, upper + maxh, fs.delta(featureName), nodetype.appropType(featureName), umlMode);
                            this._subfigs.insertFirst((Object)new TextSubFigure(feature, left, upper + maxh + (subdim.height - this._lineh) / 2 + this._ascent));
                            maxw = Math.max(maxw, indent + subdim.width);
                            maxh += subdim.height + 1;
                        } while (features.hasMoreElements());
                        ++maxh;
                        if (umlMode && !noFirstLine) {
                            this._subfigs.insertFirst((Object)new LineSubFigure(x, y + this._lineh + 1, maxw + 2 * this._d - 1, 0));
                        }
                    }
                }
            }
            if (hasFeatures) {
                if (isList) {
                    this.addShutter(fs, x, y + maxh / 2);
                } else {
                    this.addShutter(fs, x, y + this._lineh / 2);
                }
            }
        }
        if (maxw == 0) {
            maxw = this._d;
        }
        if (isNode) {
            Drawable tagsubfigure;
            maxw += 2 * this._d;
            if (isList) {
                maxw += 2 * this._d;
            } else {
                maxh += 2;
            }
            if (umlMode && !isList) {
                this._subfigs.insertFirst((Object)new FilledRectSubFigure(x, y, maxw, maxh));
                tagsubfigure = new RectSubFigure(x, y, maxw, maxh);
            } else {
                tagsubfigure = new BracketSubFigure(x, y, maxw, maxh, isList ? 2 * this._d - 1 : this._d - 1, isList);
                this._subfigs.insertFirst((Object)tagsubfigure);
            }
            if (tagbox != null) {
                boolean successfulNetInstanceHandle = false;
                if (nodetype instanceof JavaObject && ((JavaObject)nodetype).getJavaObject() instanceof NetInstance) {
                    if (this._updateHandleIndex < 0) {
                        NetInstanceAccessor niacc = RemotePlugin.getInstance().wrapInstance((NetInstance)((JavaObject)nodetype).getJavaObject());
                        this._handles.insertLast((Object)new NetInstanceHandle((Figure)this, tagbox, niacc));
                    } else {
                        NetInstanceHandle nih = (NetInstanceHandle)this._handles.at(this._updateHandleIndex++);
                        nih.setBox(tagbox);
                    }
                    successfulNetInstanceHandle = true;
                }
                if (!successfulNetInstanceHandle) {
                    if (this._updateHandleIndex < 0) {
                        this._handles.insertLast((Object)new TagHandle(this, tagbox, tagsubfigure, fs, fs.equals(this._selectedNode)));
                    } else {
                        TagHandle th = (TagHandle)((Object)this._handles.at(this._updateHandleIndex++));
                        if (th._node != fs) {
                            LOGGER.error((Object)("test failed: TagHandle references " + String.valueOf(th._node) + " instead of " + String.valueOf(fs)));
                        }
                        th.setBox(tagbox);
                        th.setHighlight(tagsubfigure);
                        th._selected = fs.equals(this._selectedNode);
                    }
                }
            }
        }
        return new Dimension(maxw, maxh);
    }

    public void read(StorableInput dr) throws IOException {
        if (dr.getVersion() <= 5) {
            super.readWithoutType(dr);
        } else {
            super.read(dr);
            this.setFrameColor(Color.black);
            if (dr.getVersion() > 6) {
                this._openNodes = new HashedSet();
                int noPaths = dr.readInt();
                Node root = null;
                if (this._fs != null) {
                    root = this._fs.getRoot();
                }
                while (noPaths-- > 0) {
                    String pathStr = dr.readString();
                    if (root == null) continue;
                    Path path = new Path(pathStr);
                    this._openNodes.include((Object)root.delta(path));
                }
            }
        }
    }

    public void write(StorableOutput dw) {
        super.write(dw);
        if (this._fs == null || this._openNodes == null) {
            dw.writeInt(0);
        } else {
            dw.writeInt(this._openNodes.size());
            CollectionEnumeration nodes = this._openNodes.elements();
            while (nodes.hasMoreElements()) {
                dw.writeString(this._fs.onePathTo((Node)nodes.nextElement()).toString());
            }
        }
    }

    protected void markDirty() {
        this._fExtent = null;
        super.markDirty();
    }

    private Enumeration<Node> getListNodes(Node node) {
        Vector<Node> listNodes = new Vector<Node>();
        listNodes.addElement(node);
        Type listType = node.getType();
        if (listType instanceof ListType && ((ListType)listType).getSubtype() == 1) {
            while ((node = node.delta(ListType.TAIL)).getType().equals(listType) && !listNodes.contains(node)) {
                listNodes.addElement(node);
            }
        }
        return listNodes.elements();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setNodeShutState(Node node, boolean close, boolean deep) {
        FSFigure fSFigure = this;
        synchronized (fSFigure) {
            Enumeration<Node> nodes = deep ? new FeatureStructure(node, false).getNodes() : this.getListNodes(node);
            if (this.shutOrClose(nodes, close)) {
                this.handlesChanged();
                this.invalidate();
                this.markDirty();
                this._selectedNode = null;
                this._updateHandleIndex = -1;
                this.changed();
            }
        }
    }

    private boolean shutOrClose(Enumeration<Node> nodes, boolean close) {
        boolean changed = false;
        while (nodes.hasMoreElements()) {
            changed |= this.shutOrClose(nodes.nextElement(), close);
        }
        return changed;
    }

    private boolean shutOrClose(Node node, boolean shut) {
        boolean isClosed;
        boolean bl = isClosed = !this._openNodes.includes((Object)node);
        if (isClosed == shut) {
            return false;
        }
        if (shut) {
            this._openNodes.removeOneOf((Object)node);
        } else {
            this._openNodes.include((Object)node);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setSelectedTag(Node node) {
        FSFigure fSFigure = this;
        synchronized (fSFigure) {
            this._selectedNode = node.equals(this._selectedNode) ? null : node;
            this.invalidate();
            CollectionEnumeration tags = this._handles.elements();
            while (tags.hasMoreElements()) {
                Object handle = tags.nextElement();
                if (!(handle instanceof TagHandle)) continue;
                TagHandle th = (TagHandle)((Object)handle);
                th._selected = th._node.equals(this._selectedNode);
            }
            if (this._selectedNode != null && this.shutOrClose(this._fs.backwardsReachableNodes(this._selectedNode), false)) {
                this.handlesChanged();
                this.markDirty();
                this._updateHandleIndex = -1;
            }
            this.changed();
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.basicSetText(this.getText());
    }
}

