/*
 * Decompiled with CFR 0.152.
 */
package de.uni_hamburg.fs;

import de.uni_hamburg.fs.JavaConcept;
import de.uni_hamburg.fs.JavaFeature;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.apache.log4j.Logger;

class BeanFeature
extends JavaFeature {
    public static final Logger LOGGER = Logger.getLogger(BeanFeature.class);
    private Method _get;
    private Method _set;

    BeanFeature(Method get, Method set) {
        this._get = get;
        this._set = set;
    }

    @Override
    Class<?> getJavaClass() {
        return this._get.getReturnType();
    }

    @Override
    Object getObjectValue(Object javaObject) {
        Throwable e = null;
        try {
            return this._get.invoke(javaObject, JavaConcept.NOPARAM);
        }
        catch (IllegalAccessException e1) {
            e = e1;
        }
        catch (IllegalArgumentException e2) {
            e = e2;
        }
        catch (InvocationTargetException e3) {
            e = e3.getTargetException();
        }
        return e;
    }

    @Override
    boolean canSet() {
        return this._set != null;
    }

    @Override
    void setObjectValue(Object javaObject, Object value) {
        if (this._set == null) {
            String msg = "Cannot set attribute of objects of " + javaObject.getClass().getName() + ": No set method for\n" + String.valueOf(this._get);
            LOGGER.error((Object)msg);
            throw new RuntimeException(msg);
        }
        try {
            this._set.invoke(javaObject, value);
            return;
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (InvocationTargetException invocationTargetException) {
            // empty catch block
        }
    }
}

