/*
 * Decompiled with CFR 0.152.
 */
package de.uni_hamburg.fs;

import collections.CollectionEnumeration;
import collections.HashedSet;
import collections.Set;
import collections.UpdatableSet;
import de.uni_hamburg.fs.Concept;
import de.uni_hamburg.fs.ConceptEnumeration;
import de.uni_hamburg.fs.UnificationFailure;
import java.io.Serializable;
import java.util.Enumeration;

public class ConceptSet
implements Serializable {
    public static final ConceptSet EMPTY = new ConceptSet();
    private UpdatableSet _concepts = new HashedSet();
    private int _hashCode = 0;

    public ConceptSet() {
    }

    public ConceptSet(Concept con) {
        this._concepts.include((Object)con);
        this._hashCode = con.hashCode();
    }

    public ConceptSet(ConceptSet cs) {
        this._concepts = (UpdatableSet)cs._concepts.duplicate();
        this._hashCode = cs._hashCode;
    }

    public ConceptSet(Enumeration<Concept> concepts) {
        while (concepts.hasMoreElements()) {
            this.addConcept(concepts.nextElement());
        }
    }

    public boolean isEmpty() {
        return this._concepts.isEmpty();
    }

    public int size() {
        return this._concepts.size();
    }

    public ConceptEnumeration elements() {
        return new ConceptEnumeration(this._concepts.elements());
    }

    public void addConcept(Concept newConcept) {
        if (!this._concepts.includes((Object)newConcept)) {
            this._concepts.include((Object)newConcept);
            this._hashCode += newConcept.hashCode();
        }
    }

    public void unite(ConceptSet that) {
        this._concepts.includeElements((Enumeration)((Object)that.elements()));
        this._hashCode = -1;
    }

    public void joinConcept(Concept newConcept) throws UnificationFailure {
        HashedSet newConcepts = new HashedSet();
        ConceptEnumeration conceptEnum = this.elements();
        while (conceptEnum.hasMoreElements()) {
            Concept concept = conceptEnum.nextConcept();
            if (concept.isa(newConcept)) {
                return;
            }
            if (newConcept.isa(concept)) continue;
            if (concept.isNotA(newConcept)) {
                throw new UnificationFailure();
            }
            newConcepts.include((Object)concept);
        }
        newConcepts.include((Object)newConcept);
        this._concepts = newConcepts;
        this._hashCode = -1;
    }

    public void join() throws UnificationFailure {
        ConceptSet newConcepts = new ConceptSet();
        newConcepts.joinConcepts(this.elements());
        this._concepts = newConcepts._concepts;
    }

    public void joinConcepts(ConceptEnumeration conceptEnum) throws UnificationFailure {
        while (conceptEnum.hasMoreElements()) {
            this.joinConcept(conceptEnum.nextConcept());
        }
    }

    public void meetConcept(Concept newConcept) {
        HashedSet newConcepts = new HashedSet();
        ConceptEnumeration conceptEnum = this.elements();
        while (conceptEnum.hasMoreElements()) {
            Concept concept = conceptEnum.nextConcept();
            if (newConcept.isa(concept)) {
                return;
            }
            if (concept.isa(newConcept)) continue;
            newConcepts.include((Object)concept);
        }
        newConcepts.include((Object)newConcept);
        this._concepts = newConcepts;
        this._hashCode = -1;
    }

    public void meet() {
        ConceptSet newConcepts = new ConceptSet();
        ConceptEnumeration conceptEnum = this.elements();
        while (conceptEnum.hasMoreElements()) {
            Concept concept = conceptEnum.nextConcept();
            newConcepts.meetConcept(concept);
        }
        this._concepts = newConcepts._concepts;
    }

    public boolean equals(Object that) {
        if (that instanceof ConceptSet) {
            return ConceptSet.equalSet((Set)((ConceptSet)that)._concepts, (Set)this._concepts);
        }
        return false;
    }

    private static boolean equalSet(Set a, Set b) {
        if (a.size() != b.size()) {
            return false;
        }
        CollectionEnumeration aEnum = a.elements();
        for (int i = a.size(); i > 0; --i) {
            if (b.includes(aEnum.nextElement())) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        if (this._hashCode == -1) {
            this._hashCode = 0;
            ConceptEnumeration concenumeration = this.elements();
            while (concenumeration.hasMoreElements()) {
                this._hashCode += concenumeration.nextConcept().hashCode();
            }
        }
        return this._hashCode;
    }

    public String toString() {
        StringBuffer output = new StringBuffer("{");
        ConceptEnumeration conceptEnum = new ConceptEnumeration(this._concepts.elements());
        int i = 1;
        while (conceptEnum.hasMoreElements()) {
            if (i > 1) {
                output.append(',');
            }
            Concept concept = conceptEnum.nextConcept();
            output.append(concept.getName());
            ++i;
        }
        output.append('}');
        return output.toString();
    }
}

