/*
 * Decompiled with CFR 0.152.
 */
package de.uni_hamburg.fs;

import de.uni_hamburg.fs.JavaConcept;
import de.uni_hamburg.fs.JavaFeature;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.apache.log4j.Logger;

class IndexFeature
extends JavaFeature {
    public static final Logger LOGGER = Logger.getLogger(IndexFeature.class);
    private Method _getCount;
    private Method _get;
    private Method _add;
    private Class<?> _returnType;

    IndexFeature(Method getCount, Method get, Method add) {
        this._getCount = getCount;
        this._get = get;
        this._add = add;
        this._returnType = Array.newInstance(get.getReturnType(), 0).getClass();
    }

    @Override
    Class<?> getJavaClass() {
        return this._returnType;
    }

    @Override
    Object getObjectValue(Object javaObject) {
        Throwable e = null;
        try {
            int count = (Integer)this._getCount.invoke(javaObject, JavaConcept.NOPARAM);
            Object[] result = (Object[])Array.newInstance(this._get.getReturnType(), count);
            for (int i = 0; i < count; ++i) {
                result[i] = this._get.invoke(javaObject, i);
            }
            return result;
        }
        catch (IllegalAccessException e1) {
            e = e1;
        }
        catch (IllegalArgumentException e2) {
            e = e2;
        }
        catch (InvocationTargetException e3) {
            e = e3.getTargetException();
        }
        LOGGER.error((Object)("Could not get index values of Object " + String.valueOf(javaObject) + ":"));
        LOGGER.error((Object)e.getMessage(), e);
        return null;
    }

    @Override
    boolean canSet() {
        return this._add != null;
    }

    @Override
    void setObjectValue(Object javaObject, Object value) {
        if (this._add == null) {
            String msg = "Cannot set attribute of objects of " + javaObject.getClass().getName() + ": No add method for\n" + String.valueOf(this._get);
            LOGGER.error((Object)msg);
            throw new RuntimeException(msg);
        }
        Throwable e = null;
        try {
            Object[] valarray = (Object[])value;
            for (int i = 0; i < valarray.length; ++i) {
                this._add.invoke(javaObject, valarray[i]);
            }
            return;
        }
        catch (IllegalAccessException e1) {
            e = e1;
        }
        catch (IllegalArgumentException e2) {
            e = e2;
        }
        catch (InvocationTargetException e3) {
            e = e3.getTargetException();
        }
        catch (Throwable t) {
            e = t;
        }
        LOGGER.error((Object)e.getMessage(), e);
        throw new RuntimeException("Exception during feature setting:");
    }
}

