/*
 * Decompiled with CFR 0.152.
 */
package de.uni_hamburg.fs;

import collections.CollectionEnumeration;
import collections.HashedMap;
import collections.UpdatableMap;
import de.renew.util.Value;
import de.uni_hamburg.fs.BasicType;
import de.uni_hamburg.fs.JavaArrayType;
import de.uni_hamburg.fs.JavaClassType;
import de.uni_hamburg.fs.JavaConcept;
import de.uni_hamburg.fs.JavaFeature;
import de.uni_hamburg.fs.JavaType;
import de.uni_hamburg.fs.Name;
import de.uni_hamburg.fs.NoSuchFeatureException;
import de.uni_hamburg.fs.Node;
import de.uni_hamburg.fs.NullObject;
import de.uni_hamburg.fs.Path;
import de.uni_hamburg.fs.Type;
import de.uni_hamburg.fs.TypeSystem;
import de.uni_hamburg.fs.UnificationFailure;
import java.awt.Dimension;
import java.util.Enumeration;
import java.util.Iterator;

public class JavaObject
extends JavaClassType
implements Node {
    Object _javaObject;
    JavaConcept _concept;
    UpdatableMap _featureCache = new HashedMap();

    JavaObject(Object javaObject) {
        if (javaObject == null || javaObject instanceof String || javaObject instanceof Value || javaObject.getClass().isArray() || javaObject instanceof Enumeration || javaObject instanceof Iterator) {
            throw new RuntimeException("Someone tried to build a JavaObject for " + String.valueOf(javaObject) + (String)(javaObject == null ? "" : "(" + javaObject.getClass().getName() + ")"));
        }
        this._javaObject = javaObject;
        Class<?> clazz = javaObject.getClass();
        this._concept = TypeSystem.instance().getJavaConcept(clazz);
        this.setJavaClass(clazz);
    }

    public static JavaType getJavaType(Object javaObject) {
        if (javaObject == null) {
            return NullObject.INSTANCE;
        }
        if (javaObject instanceof String || javaObject instanceof Value) {
            return new BasicType(javaObject);
        }
        if (javaObject.getClass().isArray()) {
            return new JavaArrayType(javaObject);
        }
        if (javaObject instanceof Enumeration) {
            return new JavaArrayType((Enumeration)javaObject);
        }
        if (javaObject instanceof Iterator) {
            return new JavaArrayType((Iterator)javaObject);
        }
        return new JavaObject(javaObject);
    }

    @Override
    public boolean isInstanceType() {
        return true;
    }

    @Override
    public Type getInstanceType() {
        return this;
    }

    @Override
    public Object getJavaObject() {
        return this._javaObject;
    }

    @Override
    public int hashCode() {
        if (this._javaObject instanceof Dimension) {
            Dimension dim = (Dimension)this._javaObject;
            return dim.width * 3 + dim.height;
        }
        return this._javaObject.hashCode();
    }

    @Override
    public boolean equals(Object that) {
        if (that instanceof JavaObject) {
            JavaObject thatJO = (JavaObject)that;
            return this._javaObject.equals(thatJO._javaObject);
        }
        return false;
    }

    @Override
    public String getName() {
        return this._concept.getName();
    }

    @Override
    public String getFullName() {
        return this._concept.getFullName();
    }

    @Override
    public String toString() {
        return BasicType.objToString(this._javaObject);
    }

    @Override
    public boolean isApprop(Name featureName) {
        return this._concept.isApprop(featureName);
    }

    @Override
    public CollectionEnumeration appropFeatureNames() {
        return this._concept.appropFeatureNames();
    }

    @Override
    public Type appropType(Name featureName) {
        return this._concept.appropType(featureName);
    }

    @Override
    public boolean isExtensional() {
        return this._concept.isExtensional();
    }

    @Override
    public boolean subsumes(Type that) {
        if (that instanceof JavaObject) {
            JavaObject thatJO = (JavaObject)that;
            return this._javaObject.equals(thatJO._javaObject);
        }
        return false;
    }

    @Override
    public Type unify(Type that) throws UnificationFailure {
        if (that instanceof JavaType) {
            JavaType thatJT = (JavaType)that;
            if (this._javaObject.equals(thatJT.getJavaObject())) {
                return this;
            }
            throw new UnificationFailure();
        }
        return that.unify(this);
    }

    @Override
    public boolean canUnify(Type that) {
        try {
            this.unify(that);
            return true;
        }
        catch (UnificationFailure uff) {
            return false;
        }
    }

    @Override
    public Type mostGeneralExtensionalSupertype(Type that) {
        return null;
    }

    @Override
    public Type getType() {
        return this;
    }

    @Override
    public Node newNode() {
        return this;
    }

    @Override
    public CollectionEnumeration featureNames() {
        return this.appropFeatureNames();
    }

    @Override
    public boolean hasFeature(Name featureName) {
        return this.isApprop(featureName);
    }

    @Override
    public Node delta(Name featureName) {
        if (this._featureCache.includesKey((Object)featureName)) {
            return (Node)this._featureCache.at((Object)featureName);
        }
        Object value = this._concept.getJavaFeature(featureName).getValue(this._javaObject);
        Node valueNode = value == this._javaObject ? this : JavaObject.getJavaType(value).newNode();
        this._featureCache.putAt((Object)featureName, (Object)valueNode);
        return valueNode;
    }

    @Override
    public Node delta(Path path) throws NoSuchFeatureException {
        Enumeration<?> featenumeration = path.features();
        Node curr = this;
        while (featenumeration.hasMoreElements()) {
            curr = curr.delta((Name)featenumeration.nextElement());
        }
        return curr;
    }

    @Override
    public void setFeature(Name featureName, Node value) {
        JavaFeature feature = this._concept.getJavaFeature(featureName);
        Object val = ((JavaType)value.getType()).getJavaObject();
        feature.setValue(this._javaObject, val);
    }

    public void setFeature(Name featureName, Object val) {
        JavaFeature feature = this._concept.getJavaFeature(featureName);
        feature.setValue(this._javaObject, val);
    }

    @Override
    public Node duplicate() {
        return this;
    }
}

