/*
 * Decompiled with CFR 0.152.
 */
package de.uni_hamburg.fs;

import collections.CollectionEnumeration;
import collections.LinkedList;
import de.uni_hamburg.fs.AbstractNode;
import de.uni_hamburg.fs.ListType;
import de.uni_hamburg.fs.Name;
import de.uni_hamburg.fs.NoSuchFeatureException;
import de.uni_hamburg.fs.Node;
import de.uni_hamburg.fs.Type;
import de.uni_hamburg.fs.TypeException;

public class ListNode
extends AbstractNode {
    private Node _hd = null;
    private Node _tl = null;

    public ListNode(ListType listtype) {
        super(listtype);
    }

    public ListNode(ListType listtype, Node hd, Node tl) throws TypeException {
        super(listtype);
        Type basetype = this.getBaseType();
        if (!hd.getType().canUnify(basetype) || !tl.getType().canUnify(new ListType(basetype))) {
            throw new TypeException();
        }
        this._hd = hd;
        this._tl = tl;
    }

    public Type getBaseType() {
        return ((ListType)this._nodetype).getBaseType();
    }

    @Override
    public CollectionEnumeration featureNames() {
        LinkedList feats = new LinkedList();
        if (this._hd != null) {
            feats.insertLast((Object)ListType.HEAD);
        }
        if (this._tl != null) {
            feats.insertLast((Object)ListType.TAIL);
        }
        return feats.elements();
    }

    private boolean isHead(Name featureName) {
        return ListType.HEAD.equals(featureName);
    }

    private boolean isTail(Name featureName) {
        return ListType.TAIL.equals(featureName);
    }

    @Override
    public boolean hasFeature(Name featureName) {
        return this.isHead(featureName) && this._hd != null || this.isTail(featureName) && this._tl != null;
    }

    public Node getHead() {
        if (this._hd == null) {
            return this.getBaseType().newNode();
        }
        return this._hd;
    }

    public Node getTail() {
        if (this._tl == null) {
            return new ListType(this.getBaseType()).newNode();
        }
        return this._tl;
    }

    @Override
    public Node delta(Name featureName) throws NoSuchFeatureException {
        if (this.isHead(featureName)) {
            return this.getHead();
        }
        if (this.isTail(featureName)) {
            return this.getTail();
        }
        throw new NoSuchFeatureException(featureName, this._nodetype);
    }

    @Override
    public void setFeature(Name featureName, Node value) {
        if (this.isHead(featureName)) {
            this._hd = value;
            return;
        }
        if (this.isTail(featureName)) {
            this._tl = value;
            return;
        }
        throw new NoSuchFeatureException(featureName, this._nodetype);
    }

    @Override
    public Node duplicate() {
        ListNode copy = new ListNode((ListType)this._nodetype);
        copy._hd = this._hd;
        copy._tl = this._tl;
        return copy;
    }
}

