/*
 * Decompiled with CFR 0.152.
 */
package de.uni_hamburg.fs;

import collections.ArrayEnumeration;
import de.uni_hamburg.fs.ListType;
import de.uni_hamburg.fs.Name;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;

public class Path
implements Serializable {
    public static final Path EPSILON = new Path(new Name[0]);
    private Name[] _feature;

    public Path(String path) {
        StringTokenizer featenumeration = new StringTokenizer(path, ":");
        this._feature = new Name[featenumeration.countTokens()];
        int i = 0;
        while (featenumeration.hasMoreTokens()) {
            this._feature[i] = new Name(featenumeration.nextToken());
            ++i;
        }
    }

    public Path(Name feature) {
        this._feature = new Name[]{feature};
    }

    public Path(Name[] feature) {
        this._feature = feature;
    }

    public static Path nth(int n) {
        Name[] feature = new Name[n + 1];
        for (int i = 0; i < n; ++i) {
            feature[i] = ListType.TAIL;
        }
        feature[n] = ListType.HEAD;
        return new Path(feature);
    }

    public Enumeration<?> features() {
        return new ArrayEnumeration((Object[])this._feature);
    }

    public int length() {
        return this._feature.length;
    }

    public boolean isEmpty() {
        return this._feature.length == 0;
    }

    public Name at(int i) {
        return this._feature[i];
    }

    public Path append(Name feat) {
        int size = this._feature.length;
        Name[] appfeature = new Name[size + 1];
        System.arraycopy(this._feature, 0, appfeature, 0, size);
        appfeature[size] = feat;
        return new Path(appfeature);
    }

    public Path append(String feat) {
        return this.append(new Name(feat));
    }

    public Path prepend(Name feat) {
        int size = this._feature.length;
        Name[] prefeature = new Name[size + 1];
        System.arraycopy(this._feature, 0, prefeature, 1, size);
        prefeature[0] = feat;
        return new Path(prefeature);
    }

    public Path prepend(String feat) {
        return this.prepend(new Name(feat));
    }

    private Path butOne(int shift) {
        int bosize = this._feature.length - 1;
        if (bosize < 0) {
            throw new NoSuchElementException();
        }
        Name[] bofeature = new Name[bosize];
        System.arraycopy(this._feature, shift, bofeature, 0, bosize);
        return new Path(bofeature);
    }

    public Path butLast() {
        return this.butOne(0);
    }

    public Name last() {
        return this.at(this._feature.length - 1);
    }

    public Path butFirst() {
        return this.butOne(1);
    }

    public Name first() {
        return this.at(0);
    }

    public String toString() {
        if (this.isEmpty()) {
            return "";
        }
        StringBuffer out = new StringBuffer(this._feature[0].toString());
        for (int i = 1; i < this._feature.length; ++i) {
            out.append(':').append(this._feature[i]);
        }
        return out.toString();
    }
}

