/*
 * Decompiled with CFR 0.152.
 */
package de.uni_hamburg.fs;

import collections.CollectionEnumeration;
import collections.HashedMap;
import collections.HashedSet;
import collections.Map;
import collections.UpdatableMap;
import collections.UpdatableSet;
import de.uni_hamburg.fs.EquivRelation;
import de.uni_hamburg.fs.JavaObject;
import de.uni_hamburg.fs.Name;
import de.uni_hamburg.fs.NoFeatureNode;
import de.uni_hamburg.fs.Node;

public class TagMap {
    private UpdatableMap _tagmap = new HashedMap();
    private UpdatableSet _visited = new HashedSet();
    private Node _root;
    private int _tagcounter = 0;

    public TagMap(Node node) {
        this._root = node;
        this.buildTagMap(this._root);
        this.resetVisited();
    }

    public TagMap(Node root, EquivRelation er, Map parsedTags) {
        this._root = root;
        CollectionEnumeration ptenumeration = parsedTags.keys();
        while (ptenumeration.hasMoreElements()) {
            Name tag = (Name)ptenumeration.nextElement();
            try {
                int tagInt = Integer.parseInt(tag._name);
                this._tagcounter = Math.max(this._tagcounter, tagInt);
            }
            catch (NumberFormatException tagInt) {
                // empty catch block
            }
            Node node = er.getUnificator((Node)parsedTags.at((Object)tag));
            this._tagmap.putAt((Object)node, (Object)tag);
        }
    }

    public Node getRoot() {
        return this._root;
    }

    public boolean visit(Node node) {
        if (this.isVisited(node)) {
            return true;
        }
        this.setVisited(node);
        return false;
    }

    private Name newTag() {
        return new Name(String.valueOf(++this._tagcounter));
    }

    private void buildTagMap(Node node) {
        if (node instanceof JavaObject || node instanceof NoFeatureNode && node.getType().isExtensional()) {
            return;
        }
        if (this.visit(node)) {
            if (!this._tagmap.includesKey((Object)node)) {
                Name tag = this.newTag();
                this._tagmap.putAt((Object)node, (Object)tag);
            }
        } else {
            CollectionEnumeration features = node.featureNames();
            while (features.hasMoreElements()) {
                Name featureName = (Name)features.nextElement();
                this.buildTagMap(node.delta(featureName));
            }
        }
    }

    public void resetVisited() {
        this._visited = new HashedSet();
    }

    public static final String indent(int depth) {
        StringBuffer space = new StringBuffer(depth + 1);
        for (int i = 0; i < depth; ++i) {
            space.append(' ');
        }
        return space.toString();
    }

    public Name getTag(Node node) {
        if (this._tagmap.includesKey((Object)node)) {
            return (Name)this._tagmap.at((Object)node);
        }
        if (node instanceof JavaObject) {
            Name tag = this.newTag();
            this._tagmap.putAt((Object)node, (Object)tag);
            return tag;
        }
        return Name.EMPTY;
    }

    public boolean isVisited(Node node) {
        return this._visited.includes((Object)node);
    }

    public void setVisited(Node node) {
        this._visited.include((Object)node);
    }

    public void setUnvisited(Node node) {
        this._visited.removeOneOf((Object)node);
    }
}

