/*
 * Decompiled with CFR 0.152.
 */
package de.renew.formalism.java;

import de.renew.formalism.java.Suggestion;
import de.renew.util.StringUtil;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Collection;

public class ConstructorSuggestion
extends Suggestion {
    private final Constructor<?> _constructor;
    private final String[] _parameters;
    private final String _callWithParameters;

    protected ConstructorSuggestion(String typeName, Constructor<?> constructor) {
        super(typeName, typeName);
        this._constructor = constructor;
        Class<?>[] parameterTypes = constructor.getParameterTypes();
        this._parameters = new String[parameterTypes.length];
        for (int i = 0; i < parameterTypes.length; ++i) {
            this._parameters[i] = parameterTypes[i].getSimpleName();
        }
        this._callWithParameters = this._name + "(" + StringUtil.join((String[])this._parameters, (String)", ") + ")";
    }

    public static Collection<ConstructorSuggestion> suggest(Class<?> clazz) {
        Constructor<?>[] constructors;
        ArrayList<ConstructorSuggestion> suggestions = new ArrayList<ConstructorSuggestion>();
        for (Constructor<?> constructor : constructors = clazz.getConstructors()) {
            suggestions.add(new ConstructorSuggestion(clazz.getSimpleName(), constructor));
        }
        return suggestions;
    }

    public Constructor<?> getConstructor() {
        return this._constructor;
    }

    public String getCallWithParameters() {
        return this._callWithParameters;
    }

    public String[] getParameters() {
        return this._parameters;
    }

    @Override
    public String toString() {
        return "<html>" + this.getCallWithParameters() + " <font color=gray>- " + this._constructor.getDeclaringClass().getSimpleName() + "</font></html>";
    }
}

